/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { from } from '../from';

/**
 * Types the DefaultFromString as:
 *   - If null or undefined, then a default of the string "now-6m" will be used
 */
export var DefaultFromString = new t.Type('DefaultFromString', t.string.is, function (input, context) {
  if (input == null) {
    return t.success('now-6m');
  }
  return from.validate(input, context);
}, t.identity);