import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

export var validateComments = function validateComments(item) {
  if (item.comments == null) {
    return [];
  }
  var _item$comments$reduce = item.comments.reduce(function (acc, comment) {
      var _acc = _slicedToArray(acc, 2),
        hasNewComments = _acc[1];
      if (comment.id == null) {
        return [true, true];
      }
      if (hasNewComments && comment.id != null) {
        return [false, true];
      }
      return acc;
    }, [true, false]),
    _item$comments$reduce2 = _slicedToArray(_item$comments$reduce, 1),
    appendOnly = _item$comments$reduce2[0];
  if (!appendOnly) {
    return ['item "comments" are append only'];
  } else {
    return [];
  }
};
export var updateExceptionListItemValidate = function updateExceptionListItemValidate(schema) {
  return _toConsumableArray(validateComments(schema));
};