/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { _version } from '../../common/underscore_version';
import { id } from '../../common/id';
import { value } from '../../common/value';
import { meta } from '../../common/meta';
export var updateListItemSchema = t.intersection([t.exact(t.type({
  id: id,
  value: value
})), t.exact(t.partial({
  _version: _version,
  // defaults to undefined if not set during decode
  meta: meta // defaults to undefined if not set during decode
}))]);