/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

export var draggableIdPrefix = 'draggableId';
export var droppableIdPrefix = 'droppableId';
export var draggableContentPrefix = "".concat(draggableIdPrefix, ".content.");
export var draggableTimelineProvidersPrefix = "".concat(draggableIdPrefix, ".timelineProviders.");
export var draggableFieldPrefix = "".concat(draggableIdPrefix, ".field.");
export var droppableContentPrefix = "".concat(droppableIdPrefix, ".content.");
export var droppableFieldPrefix = "".concat(droppableIdPrefix, ".field.");
export var droppableTimelineProvidersPrefix = "".concat(droppableIdPrefix, ".timelineProviders.");
export var droppableTimelineColumnsPrefix = "".concat(droppableIdPrefix, ".timelineColumns.");
export var droppableTimelineFlyoutBottomBarPrefix = "".concat(droppableIdPrefix, ".flyoutButton.");
export var getDraggableId = function getDraggableId(dataProviderId) {
  return "".concat(draggableContentPrefix).concat(dataProviderId);
};
export var getDraggableFieldId = function getDraggableFieldId(_ref) {
  var contextId = _ref.contextId,
    fieldId = _ref.fieldId;
  return "".concat(draggableFieldPrefix).concat(escapeContextId(contextId), ".").concat(escapeFieldId(fieldId));
};
export var getTimelineProviderDroppableId = function getTimelineProviderDroppableId(_ref2) {
  var groupIndex = _ref2.groupIndex,
    timelineId = _ref2.timelineId;
  return "".concat(droppableTimelineProvidersPrefix).concat(timelineId, ".group.").concat(groupIndex);
};
export var getTimelineProviderDraggableId = function getTimelineProviderDraggableId(_ref3) {
  var dataProviderId = _ref3.dataProviderId,
    groupIndex = _ref3.groupIndex,
    timelineId = _ref3.timelineId;
  return "".concat(draggableTimelineProvidersPrefix).concat(timelineId, ".group.").concat(groupIndex, ".").concat(dataProviderId);
};
export var getDroppableId = function getDroppableId(visualizationPlaceholderId) {
  return "".concat(droppableContentPrefix).concat(visualizationPlaceholderId);
};
export var sourceIsContent = function sourceIsContent(result) {
  return result.source.droppableId.startsWith(droppableContentPrefix);
};
export var sourceAndDestinationAreSameTimelineProviders = function sourceAndDestinationAreSameTimelineProviders(result) {
  var regex = /^droppableId\.timelineProviders\.(\S+)\./;
  var sourceMatches = result.source.droppableId.match(regex) || [];
  var destinationMatches = result.destination && result.destination.droppableId.match(regex) || [];
  return sourceMatches.length >= 2 && destinationMatches.length >= 2 && sourceMatches[1] === destinationMatches[1];
};
export var draggableIsContent = function draggableIsContent(result) {
  return result.draggableId.startsWith(draggableContentPrefix);
};
export var draggableIsField = function draggableIsField(result) {
  return result.draggableId.startsWith(draggableFieldPrefix);
};
export var reasonIsDrop = function reasonIsDrop(result) {
  return result.reason === 'DROP';
};
export var destinationIsTimelineProviders = function destinationIsTimelineProviders(result) {
  return result.destination != null && result.destination.droppableId.startsWith(droppableTimelineProvidersPrefix);
};
export var destinationIsTimelineColumns = function destinationIsTimelineColumns(result) {
  return result.destination != null && result.destination.droppableId.startsWith(droppableTimelineColumnsPrefix);
};
export var destinationIsTimelineButton = function destinationIsTimelineButton(result) {
  return result.destination != null && result.destination.droppableId.startsWith(droppableTimelineFlyoutBottomBarPrefix);
};
export var getProviderIdFromDraggable = function getProviderIdFromDraggable(result) {
  return result.draggableId.substring(result.draggableId.lastIndexOf('.') + 1);
};
export var getFieldIdFromDraggable = function getFieldIdFromDraggable(result) {
  return unEscapeFieldId(result.draggableId.substring(result.draggableId.lastIndexOf('.') + 1));
};
export var escapeDataProviderId = function escapeDataProviderId(path) {
  return path.replace(/\./g, '_');
};
export var escapeContextId = function escapeContextId(path) {
  return path.replace(/\./g, '_');
};
export var escapeFieldId = function escapeFieldId(path) {
  return path.replace(/\./g, '!!!DOT!!!');
};
export var unEscapeFieldId = function unEscapeFieldId(path) {
  return path.replace(/!!!DOT!!!/g, '.');
};
export var providerWasDroppedOnTimeline = function providerWasDroppedOnTimeline(result) {
  return reasonIsDrop(result) && draggableIsContent(result) && sourceIsContent(result) && destinationIsTimelineProviders(result);
};
export var userIsReArrangingProviders = function userIsReArrangingProviders(result) {
  return reasonIsDrop(result) && sourceAndDestinationAreSameTimelineProviders(result);
};
export var fieldWasDroppedOnTimelineColumns = function fieldWasDroppedOnTimelineColumns(result) {
  return reasonIsDrop(result) && draggableIsField(result) && destinationIsTimelineColumns(result);
};

/**
 * Prevents fields from being dragged or dropped to any area other than column
 * header drop zone in the timeline
 */
export var DRAG_TYPE_FIELD = 'drag-type-field';

/** This class is added to the document body while timeline field dragging */
export var IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME = 'is-timeline-field-dragging';