"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPromise = isPromise;
exports.withTimeout = withTimeout;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function withTimeout({
  promise,
  timeoutMs
}) {
  let timeout;
  try {
    return await Promise.race([promise.then(v => ({
      value: v,
      timedout: false
    })), new Promise(resolve => {
      timeout = setTimeout(() => resolve({
        timedout: true
      }), timeoutMs);
    })]);
  } finally {
    if (timeout !== undefined) {
      clearTimeout(timeout);
    }
  }
}
function isPromise(maybePromise) {
  return maybePromise ? typeof maybePromise.then === 'function' : false;
}