"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFileCacheKey = exports.generateFileHash = void 0;
var _fs = require("fs");
var _crypto = require("crypto");
var Rx = _interopRequireWildcard(require("rxjs"));
var _operators = require("rxjs/operators");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const generateFileHash = fd => {
  const hash = (0, _crypto.createHash)('sha1');
  const read = (0, _fs.createReadStream)(null, {
    fd,
    start: 0,
    autoClose: false
  });
  return Rx.merge(Rx.fromEvent(read, 'data'), Rx.fromEvent(read, 'error').pipe((0, _operators.map)(error => {
    throw error;
  }))).pipe((0, _operators.takeUntil)(Rx.fromEvent(read, 'end'))).forEach(chunk => hash.update(chunk)).then(() => hash.digest('hex'));
};
exports.generateFileHash = generateFileHash;
const getFileCacheKey = (path, stat) => `${path}:${stat.ino}:${stat.size}:${stat.mtime.getTime()}`;
exports.getFileCacheKey = getFileCacheKey;