"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readWithPit = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
var _open_pit = require("./open_pit");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/** @internal */

/*
 * Requests documents from the index using PIT mechanism.
 * */
const readWithPit = ({
  client,
  pitId,
  query,
  batchSize,
  searchAfter,
  seqNoPrimaryTerm
}) => () => {
  return client.search({
    allow_partial_search_results: false,
    seq_no_primary_term: seqNoPrimaryTerm,
    body: {
      // Sort fields are required to use searchAfter
      sort: {
        // the most efficient option as order is not important for the migration
        _shard_doc: {
          order: 'asc'
        }
      },
      pit: {
        id: pitId,
        keep_alive: _open_pit.pitKeepAlive
      },
      size: batchSize,
      search_after: searchAfter,
      /**
       * We want to know how many documents we need to process so we can log the progress.
       * But we also want to increase the performance of these requests,
       * so we ask ES to report the total count only on the first request (when searchAfter does not exist)
       */
      track_total_hits: typeof searchAfter === 'undefined',
      query
    }
  }).then(response => {
    var _response$body$hits$t;
    const totalHits = typeof response.body.hits.total === 'number' ? response.body.hits.total // This format is to be removed in 8.0
    : (_response$body$hits$t = response.body.hits.total) === null || _response$body$hits$t === void 0 ? void 0 : _response$body$hits$t.value;
    const hits = response.body.hits.hits;
    if (hits.length > 0) {
      return Either.right({
        // @ts-expect-error @elastic/elasticsearch _source is optional
        outdatedDocuments: hits,
        lastHitSortValue: hits[hits.length - 1].sort,
        totalHits
      });
    }
    return Either.right({
      outdatedDocuments: [],
      lastHitSortValue: undefined,
      totalHits
    });
  }).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
};
exports.readWithPit = readWithPit;