"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfiguration = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionHandshakeParamsSchema = exports.ExecutorSubActionGetSeverityParamsSchema = exports.ExecutorSubActionGetIncidentTypesParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalIncidentServiceConfiguration = exports.ExternalIncidentServiceConfiguration = {
  apiUrl: _configSchema.schema.string(),
  orgId: _configSchema.schema.string()
};
const ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = _configSchema.schema.object(ExternalIncidentServiceConfiguration);
const ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceSecretConfiguration = {
  apiKeyId: _configSchema.schema.string(),
  apiKeySecret: _configSchema.schema.string()
};
const ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = _configSchema.schema.object(ExternalIncidentServiceSecretConfiguration);
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _configSchema.schema.object({
  incident: _configSchema.schema.object({
    name: _configSchema.schema.string(),
    description: _configSchema.schema.nullable(_configSchema.schema.string()),
    externalId: _configSchema.schema.nullable(_configSchema.schema.string()),
    incidentTypes: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number())),
    severityCode: _configSchema.schema.nullable(_configSchema.schema.number())
  }),
  comments: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
    comment: _configSchema.schema.string(),
    commentId: _configSchema.schema.string()
  })))
});
const ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = _configSchema.schema.object({
  externalId: _configSchema.schema.string()
});

// Reserved for future implementation
const ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = _configSchema.schema.object({});
const ExecutorSubActionHandshakeParamsSchema = exports.ExecutorSubActionHandshakeParamsSchema = _configSchema.schema.object({});
const ExecutorSubActionGetIncidentTypesParamsSchema = exports.ExecutorSubActionGetIncidentTypesParamsSchema = _configSchema.schema.object({});
const ExecutorSubActionGetSeverityParamsSchema = exports.ExecutorSubActionGetSeverityParamsSchema = _configSchema.schema.object({});
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  subAction: _configSchema.schema.literal('getFields'),
  subActionParams: ExecutorSubActionCommonFieldsParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('getIncident'),
  subActionParams: ExecutorSubActionGetIncidentParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('handshake'),
  subActionParams: ExecutorSubActionHandshakeParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('pushToService'),
  subActionParams: ExecutorSubActionPushParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('incidentTypes'),
  subActionParams: ExecutorSubActionGetIncidentTypesParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal('severity'),
  subActionParams: ExecutorSubActionGetSeverityParamsSchema
})]);