"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityOverviewRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _to_number_rt = require("@kbn/io-ts-utils/to_number_rt");
var _setup_request = require("../lib/helpers/setup_request");
var _get_service_count = require("../lib/observability_overview/get_service_count");
var _get_transactions_per_minute = require("../lib/observability_overview/get_transactions_per_minute");
var _has_data = require("../lib/observability_overview/has_data");
var _default_api_types = require("./default_api_types");
var _aggregated_transactions = require("../lib/helpers/aggregated_transactions");
var _with_apm_span = require("../utils/with_apm_span");
var _create_apm_server_route_repository = require("./create_apm_server_route_repository");
var _create_apm_server_route = require("./create_apm_server_route");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const observabilityOverviewHasDataRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/observability_overview/has_data',
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const setup = await (0, _setup_request.setupRequest)(resources);
    return await (0, _has_data.getHasData)({
      setup
    });
  }
});
const observabilityOverviewRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/observability_overview',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, t.type({
      bucketSize: _to_number_rt.toNumberRt,
      intervalString: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      bucketSize,
      intervalString,
      start,
      end
    } = resources.params.query;
    const searchAggregatedTransactions = await (0, _aggregated_transactions.getSearchAggregatedTransactions)({
      apmEventClient: setup.apmEventClient,
      config: setup.config,
      start,
      end,
      kuery: ''
    });
    return (0, _with_apm_span.withApmSpan)('observability_overview', async () => {
      const [serviceCount, transactionPerMinute] = await Promise.all([(0, _get_service_count.getServiceCount)({
        setup,
        searchAggregatedTransactions,
        start,
        end
      }), (0, _get_transactions_per_minute.getTransactionsPerMinute)({
        setup,
        bucketSize,
        searchAggregatedTransactions,
        start,
        end,
        intervalString
      })]);
      return {
        serviceCount,
        transactionPerMinute
      };
    });
  }
});
const observabilityOverviewRouteRepository = exports.observabilityOverviewRouteRepository = (0, _create_apm_server_route_repository.createApmServerRouteRepository)().add(observabilityOverviewRoute).add(observabilityOverviewHasDataRoute);