"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceNodeRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_apm_server_route_repository = require("./create_apm_server_route_repository");
var _create_apm_server_route = require("./create_apm_server_route");
var _setup_request = require("../lib/helpers/setup_request");
var _service_nodes = require("../lib/service_nodes");
var _default_api_types = require("./default_api_types");
var _environment_rt = require("../../common/environment_rt");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceNodesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/serviceNodes',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _environment_rt.environmentRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      kuery,
      environment,
      start,
      end
    } = params.query;
    const serviceNodes = await (0, _service_nodes.getServiceNodes)({
      kuery,
      setup,
      serviceName,
      environment,
      start,
      end
    });
    return {
      serviceNodes
    };
  }
});
const serviceNodeRouteRepository = exports.serviceNodeRouteRepository = (0, _create_apm_server_route_repository.createApmServerRouteRepository)().add(serviceNodesRoute);