"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchUrl = fetchUrl;
exports.getFetchOptions = getFetchOptions;
exports.getResponse = getResponse;
exports.getResponseStream = getResponseStream;
var _nodeFetch = _interopRequireWildcard(require("node-fetch"));
var _pRetry = _interopRequireDefault(require("p-retry"));
var _streams = require("../streams");
var _app_context = require("../../app_context");
var _errors = require("../../../errors");
var _proxy = require("./proxy");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// not sure what to call this function, but we're not exporting it
async function registryFetch(url) {
  const response = await (0, _nodeFetch.default)(url, getFetchOptions(url));
  if (response.ok) {
    return response;
  } else {
    // 4xx & 5xx responses
    const {
      status,
      statusText,
      url: resUrl
    } = response;
    const message = `'${status} ${statusText}' error response from package registry at ${resUrl || url}`;
    const responseError = new _errors.RegistryResponseError(message, status);
    throw new _pRetry.default.AbortError(responseError);
  }
}
async function getResponse(url) {
  try {
    // we only want to retry certain failures like network issues
    // the rest should only try the one time then fail as they do now
    const response = await (0, _pRetry.default)(() => registryFetch(url), {
      factor: 2,
      retries: 5,
      onFailedAttempt: error => {
        // we only want to retry certain types of errors, like `ECONNREFUSED` and other operational errors
        // and let the others through without retrying
        //
        // throwing in onFailedAttempt will abandon all retries & fail the request
        // we only want to retry system errors, so re-throw for everything else
        if (!isSystemError(error)) {
          throw error;
        }
      }
    });
    return response;
  } catch (error) {
    // isSystemError here means we didn't succeed after max retries
    if (isSystemError(error)) {
      throw new _errors.RegistryConnectionError(`Error connecting to package registry: ${error.message}`);
    }
    // don't wrap our own errors
    if (error instanceof _errors.RegistryError) {
      throw error;
    } else {
      throw new _errors.RegistryError(error);
    }
  }
}
async function getResponseStream(url) {
  const res = await getResponse(url);
  return res.body;
}
async function fetchUrl(url) {
  return getResponseStream(url).then(_streams.streamToString);
}

// node-fetch throws a FetchError for those types of errors and
// "All errors originating from Node.js core are marked with error.type = 'system'"
// https://github.com/node-fetch/node-fetch/blob/master/docs/ERROR-HANDLING.md#error-handling-with-node-fetch
function isFetchError(error) {
  return error instanceof _nodeFetch.FetchError || error.name === 'FetchError';
}
function isSystemError(error) {
  return isFetchError(error) && error.type === 'system';
}
function getFetchOptions(targetUrl) {
  const options = {
    headers: {
      'User-Agent': `Kibana/${_app_context.appContextService.getKibanaVersion()} node-fetch`
    }
  };
  const proxyUrl = (0, _proxy.getRegistryProxyUrl)();
  if (!proxyUrl) {
    return options;
  }
  const logger = _app_context.appContextService.getLogger();
  logger.debug(`Using ${proxyUrl} as proxy for ${targetUrl}`);
  options.agent = (0, _proxy.getProxyAgent)({
    proxyUrl,
    targetUrl
  });
  return options;
}