"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAgentPolicyRequestSchema = exports.GetOneAgentPolicyRequestSchema = exports.GetFullAgentPolicyRequestSchema = exports.GetAgentPoliciesRequestSchema = exports.DeleteAgentPolicyRequestSchema = exports.CreateAgentPolicyRequestSchema = exports.CopyAgentPolicyRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _models = require("../models");
var _index = require("./index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetAgentPoliciesRequestSchema = exports.GetAgentPoliciesRequestSchema = {
  query: _index.ListWithKuerySchema.extends({
    full: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const GetOneAgentPolicyRequestSchema = exports.GetOneAgentPolicyRequestSchema = {
  params: _configSchema.schema.object({
    agentPolicyId: _configSchema.schema.string()
  })
};
const CreateAgentPolicyRequestSchema = exports.CreateAgentPolicyRequestSchema = {
  body: _models.NewAgentPolicySchema,
  query: _configSchema.schema.object({
    sys_monitoring: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const UpdateAgentPolicyRequestSchema = exports.UpdateAgentPolicyRequestSchema = {
  ...GetOneAgentPolicyRequestSchema,
  body: _models.NewAgentPolicySchema
};
const CopyAgentPolicyRequestSchema = exports.CopyAgentPolicyRequestSchema = {
  ...GetOneAgentPolicyRequestSchema,
  body: _configSchema.schema.object({
    name: _configSchema.schema.string({
      minLength: 1
    }),
    description: _configSchema.schema.maybe(_configSchema.schema.string())
  })
};
const DeleteAgentPolicyRequestSchema = exports.DeleteAgentPolicyRequestSchema = {
  body: _configSchema.schema.object({
    agentPolicyId: _configSchema.schema.string()
  })
};
const GetFullAgentPolicyRequestSchema = exports.GetFullAgentPolicyRequestSchema = {
  params: _configSchema.schema.object({
    agentPolicyId: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    download: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    standalone: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    kubernetes: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};