"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceConfigurationConfigFilePropertiesRT = exports.TimestampFromString = exports.StaticSourceConfigurationRuntimeType = exports.SourceStatusRuntimeType = exports.SourceRuntimeType = exports.SourceResponseRuntimeType = exports.SourceConfigurationTimestampColumnRuntimeType = exports.SourceConfigurationSavedObjectRuntimeType = exports.SourceConfigurationRuntimeType = exports.SourceConfigurationRT = exports.SourceConfigurationMessageColumnRuntimeType = exports.SourceConfigurationFieldColumnRuntimeType = exports.SourceConfigurationColumnRuntimeType = exports.SavedSourceConfigurationRuntimeType = void 0;
var _lodash = require("lodash");
var rt = _interopRequireWildcard(require("io-ts"));
var _moment = _interopRequireDefault(require("moment"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _log_sources = require("../log_sources");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * These are the core source configuration types that represent a Source Configuration in
 * it's entirety. There are then subsets of this configuration that form the Logs Source Configuration
 * and Metrics Source Configuration. The Logs Source Configuration is further expanded to it's resolved form.
 * -> Source Configuration
 *  -> Logs source configuration
 *    -> Resolved Logs Source Configuration
 *  -> Metrics Source Configuration
 */

/* eslint-disable @typescript-eslint/no-empty-interface */

const TimestampFromString = exports.TimestampFromString = new rt.Type('TimestampFromString', input => typeof input === 'number', (input, context) => (0, _pipeable.pipe)(rt.string.validate(input, context), (0, _Either.chain)(stringInput => {
  const momentValue = (0, _moment.default)(stringInput);
  return momentValue.isValid() ? rt.success(momentValue.valueOf()) : rt.failure(stringInput, context);
})), output => new Date(output).toISOString());

/**
 * Source configuration config file properties.
 * These are properties that can appear in the kibana.yml file.
 * This is a legacy method of providing properties, and will be deprecated in the future (v 8.0.0).
 */

const sourceConfigurationConfigFilePropertiesRT = exports.sourceConfigurationConfigFilePropertiesRT = rt.type({
  sources: rt.type({
    default: rt.partial({
      logAlias: rt.string,
      // Cannot be deprecated until 8.0.0. Will be converted to an indexName reference.
      metricAlias: rt.string,
      fields: rt.partial({
        timestamp: rt.string,
        message: rt.array(rt.string),
        tiebreaker: rt.string,
        host: rt.string,
        container: rt.string,
        pod: rt.string
      })
    })
  })
});
/**
 * Log columns
 */

const SourceConfigurationTimestampColumnRuntimeType = exports.SourceConfigurationTimestampColumnRuntimeType = rt.type({
  timestampColumn: rt.type({
    id: rt.string
  })
});
const SourceConfigurationMessageColumnRuntimeType = exports.SourceConfigurationMessageColumnRuntimeType = rt.type({
  messageColumn: rt.type({
    id: rt.string
  })
});
const SourceConfigurationFieldColumnRuntimeType = exports.SourceConfigurationFieldColumnRuntimeType = rt.type({
  fieldColumn: rt.type({
    id: rt.string,
    field: rt.string
  })
});
const SourceConfigurationColumnRuntimeType = exports.SourceConfigurationColumnRuntimeType = rt.union([SourceConfigurationTimestampColumnRuntimeType, SourceConfigurationMessageColumnRuntimeType, SourceConfigurationFieldColumnRuntimeType]);
/**
 * Fields
 */

const SourceConfigurationFieldsRT = rt.type({
  container: rt.string,
  host: rt.string,
  pod: rt.string,
  tiebreaker: rt.string,
  timestamp: rt.string,
  message: rt.array(rt.string)
});

/**
 * Properties that represent a full source configuration, which is the result of merging static values with
 * saved values.
 */
const SourceConfigurationRT = exports.SourceConfigurationRT = rt.type({
  name: rt.string,
  description: rt.string,
  metricAlias: rt.string,
  logIndices: _log_sources.logIndexReferenceRT,
  inventoryDefaultView: rt.string,
  metricsExplorerDefaultView: rt.string,
  fields: SourceConfigurationFieldsRT,
  logColumns: rt.array(SourceConfigurationColumnRuntimeType),
  anomalyThreshold: rt.number
});

/**
 * Stored source configuration as read from and written to saved objects
 */
const SavedSourceConfigurationFieldsRuntimeType = rt.partial((0, _lodash.omit)(SourceConfigurationFieldsRT.props, ['message']));
const SavedSourceConfigurationRuntimeType = exports.SavedSourceConfigurationRuntimeType = rt.intersection([rt.partial((0, _lodash.omit)(SourceConfigurationRT.props, ['fields'])), rt.partial({
  fields: SavedSourceConfigurationFieldsRuntimeType
})]);
/**
 * Static source configuration, the result of merging values from the config file and
 * hardcoded defaults.
 */

const StaticSourceConfigurationFieldsRuntimeType = rt.partial(SourceConfigurationFieldsRT.props);
const StaticSourceConfigurationRuntimeType = exports.StaticSourceConfigurationRuntimeType = rt.partial({
  ...SourceConfigurationRT.props,
  fields: StaticSourceConfigurationFieldsRuntimeType
});

/**
 * Full source configuration type after all cleanup has been done at the edges
 */

const SourceConfigurationRuntimeType = exports.SourceConfigurationRuntimeType = rt.type({
  ...SourceConfigurationRT.props,
  fields: SourceConfigurationFieldsRT,
  logColumns: rt.array(SourceConfigurationColumnRuntimeType)
});
/**
 * Source status
 */
const SourceStatusFieldRuntimeType = rt.type({
  name: rt.string,
  type: rt.string,
  searchable: rt.boolean,
  aggregatable: rt.boolean,
  displayable: rt.boolean
});
const SourceStatusRuntimeType = exports.SourceStatusRuntimeType = rt.type({
  logIndicesExist: rt.boolean,
  metricIndicesExist: rt.boolean,
  indexFields: rt.array(SourceStatusFieldRuntimeType)
});
/**
 * Source configuration along with source status and metadata
 */
const SourceRuntimeType = exports.SourceRuntimeType = rt.intersection([rt.type({
  id: rt.string,
  origin: rt.keyof({
    fallback: null,
    internal: null,
    stored: null
  }),
  configuration: SourceConfigurationRuntimeType
}), rt.partial({
  version: rt.string,
  updatedAt: rt.number,
  status: SourceStatusRuntimeType
})]);
const SourceResponseRuntimeType = exports.SourceResponseRuntimeType = rt.type({
  source: SourceRuntimeType
});
/**
 * Saved object type with metadata
 */

const SourceConfigurationSavedObjectRuntimeType = exports.SourceConfigurationSavedObjectRuntimeType = rt.intersection([rt.type({
  id: rt.string,
  attributes: SavedSourceConfigurationRuntimeType
}), rt.partial({
  version: rt.string,
  updated_at: TimestampFromString
})]);