"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertHistogramBucketsToTimeseries = void 0;
var _lodash = require("lodash");
var rt = _interopRequireWildcard(require("io-ts"));
var _types = require("../types");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_COLUMNS = [{
  name: 'timestamp',
  type: 'date'
}];
const ValueObjectTypeRT = rt.union([rt.string, rt.number, _types.MetricValueTypeRT]);
const getValue = valueObject => {
  if (_types.NormalizedMetricValueRT.is(valueObject)) {
    return valueObject.normalized_value || valueObject.value;
  }
  if (_types.PercentilesTypeRT.is(valueObject)) {
    const percentileValues = (0, _lodash.values)(valueObject.values);
    if (percentileValues.length > 1) {
      throw new Error('Metrics API only supports a single percentile, multiple percentiles should be sent separately');
    }
    return (0, _lodash.first)(percentileValues) || null;
  }
  if (_types.PercentilesKeyedTypeRT.is(valueObject)) {
    if (valueObject.values.length > 1) {
      throw new Error('Metrics API only supports a single percentile, multiple percentiles should be sent separately');
    }
    const percentileValue = (0, _lodash.first)(valueObject.values);
    return percentileValue && percentileValue.value || null;
  }
  if (_types.BasicMetricValueRT.is(valueObject)) {
    return valueObject.value;
  }
  if (_types.TopMetricsTypeRT.is(valueObject)) {
    return valueObject.top.map(res => res.metrics);
  }
  return null;
};
const dropOutOfBoundsBuckets = (from, to, bucketSizeInMillis) => row => row.timestamp >= from && row.timestamp + bucketSizeInMillis <= to;
const convertBucketsToRows = (options, buckets) => {
  return buckets.map(bucket => {
    const ids = options.metrics.map(metric => metric.id);
    const metrics = ids.reduce((acc, id) => {
      const valueObject = (0, _lodash.get)(bucket, [id]);
      return {
        ...acc,
        [id]: ValueObjectTypeRT.is(valueObject) ? getValue(valueObject) : null
      };
    }, {});
    return {
      timestamp: bucket.key,
      ...metrics
    };
  });
};
const convertHistogramBucketsToTimeseries = (keys, options, buckets, bucketSizeInMillis) => {
  const id = keys.join(':');
  // If there are no metrics then we just return the empty series
  // but still maintain the groupings.
  if (options.metrics.length === 0) {
    return {
      id,
      keys,
      columns: [],
      rows: []
    };
  }
  const columns = options.metrics.map(metric => ({
    name: metric.id,
    type: 'number'
  }));
  const allRows = convertBucketsToRows(options, buckets);
  const rows = options.dropPartialBuckets ? allRows.filter(dropOutOfBoundsBuckets(options.timerange.from, options.timerange.to, bucketSizeInMillis)) : allRows;
  return {
    id,
    keys,
    rows,
    columns: [...BASE_COLUMNS, ...columns]
  };
};
exports.convertHistogramBucketsToTimeseries = convertHistogramBucketsToTimeseries;