"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.textOrUndefined = exports.text = exports.shortOrUndefined = exports.short = exports.shapeOrUndefined = exports.shape = exports.long_range = exports.longRangeOrUndefined = exports.longOrUndefined = exports.long = exports.keywordOrUndefined = exports.keyword = exports.ip_range = exports.ipRangeOrUndefined = exports.ipOrUndefined = exports.ip = exports.integer_range = exports.integerRangeOrUndefined = exports.integerOrUndefined = exports.integer = exports.half_float = exports.halfFloatOrUndefined = exports.geo_shape = exports.geo_point = exports.geoShapeOrUndefined = exports.geoPointOrUndefined = exports.float_range = exports.floatRangeOrUndefined = exports.floatOrUndefined = exports.float = exports.esDataTypeUnion = exports.esDataTypeSingle = exports.esDataTypeRangeTerm = exports.esDataTypeRange = exports.esDataTypeGeoShape = exports.esDataTypeGeoPointRange = exports.esDataTypeGeoPoint = exports.double_range = exports.doubleRangeOrUndefined = exports.doubleOrUndefined = exports.double = exports.date_range = exports.date_nanos = exports.dateRangeOrUndefined = exports.dateOrUndefined = exports.dateNanosOrUndefined = exports.date = exports.byteOrUndefined = exports.byte = exports.booleanOrUndefined = exports.boolean = exports.binaryOrUndefined = exports.binary = exports._index = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

const binary = exports.binary = t.string;
const binaryOrUndefined = exports.binaryOrUndefined = t.union([binary, t.undefined]);
const boolean = exports.boolean = t.string;
const booleanOrUndefined = exports.booleanOrUndefined = t.union([boolean, t.undefined]);
const byte = exports.byte = t.string;
const byteOrUndefined = exports.byteOrUndefined = t.union([byte, t.undefined]);
const date = exports.date = t.string;
const dateOrUndefined = exports.dateOrUndefined = t.union([date, t.undefined]);
const date_nanos = exports.date_nanos = t.string;
const dateNanosOrUndefined = exports.dateNanosOrUndefined = t.union([date_nanos, t.undefined]);
const double = exports.double = t.string;
const doubleOrUndefined = exports.doubleOrUndefined = t.union([double, t.undefined]);
const float = exports.float = t.string;
const floatOrUndefined = exports.floatOrUndefined = t.union([float, t.undefined]);
const geo_shape = exports.geo_shape = t.string;
const geoShapeOrUndefined = exports.geoShapeOrUndefined = t.union([geo_shape, t.undefined]);
const half_float = exports.half_float = t.string;
const halfFloatOrUndefined = exports.halfFloatOrUndefined = t.union([half_float, t.undefined]);
const integer = exports.integer = t.string;
const integerOrUndefined = exports.integerOrUndefined = t.union([integer, t.undefined]);
const ip = exports.ip = t.string;
const ipOrUndefined = exports.ipOrUndefined = t.union([ip, t.undefined]);
const keyword = exports.keyword = t.string;
const keywordOrUndefined = exports.keywordOrUndefined = t.union([keyword, t.undefined]);
const text = exports.text = t.string;
const textOrUndefined = exports.textOrUndefined = t.union([text, t.undefined]);
const long = exports.long = t.string;
const longOrUndefined = exports.longOrUndefined = t.union([long, t.undefined]);
const shape = exports.shape = t.string;
const shapeOrUndefined = exports.shapeOrUndefined = t.union([shape, t.undefined]);
const short = exports.short = t.string;
const shortOrUndefined = exports.shortOrUndefined = t.union([short, t.undefined]);
const esDataTypeRange = exports.esDataTypeRange = t.exact(t.type({
  gte: t.string,
  lte: t.string
}));
const date_range = exports.date_range = esDataTypeRange;
const dateRangeOrUndefined = exports.dateRangeOrUndefined = t.union([date_range, t.undefined]);
const double_range = exports.double_range = esDataTypeRange;
const doubleRangeOrUndefined = exports.doubleRangeOrUndefined = t.union([double_range, t.undefined]);
const float_range = exports.float_range = esDataTypeRange;
const floatRangeOrUndefined = exports.floatRangeOrUndefined = t.union([float_range, t.undefined]);
const integer_range = exports.integer_range = esDataTypeRange;
const integerRangeOrUndefined = exports.integerRangeOrUndefined = t.union([integer_range, t.undefined]);

// ip_range can be just a CIDR value as a range
const ip_range = exports.ip_range = t.union([esDataTypeRange, t.string]);
const ipRangeOrUndefined = exports.ipRangeOrUndefined = t.union([ip_range, t.undefined]);
const long_range = exports.long_range = esDataTypeRange;
const longRangeOrUndefined = exports.longRangeOrUndefined = t.union([long_range, t.undefined]);
const esDataTypeRangeTerm = exports.esDataTypeRangeTerm = t.union([t.exact(t.type({
  date_range
})), t.exact(t.type({
  double_range
})), t.exact(t.type({
  float_range
})), t.exact(t.type({
  integer_range
})), t.exact(t.type({
  ip_range
})), t.exact(t.type({
  long_range
}))]);
const esDataTypeGeoPointRange = exports.esDataTypeGeoPointRange = t.exact(t.type({
  lat: t.string,
  lon: t.string
}));
const geo_point = exports.geo_point = t.union([esDataTypeGeoPointRange, t.string]);
const geoPointOrUndefined = exports.geoPointOrUndefined = t.union([geo_point, t.undefined]);
const esDataTypeGeoPoint = exports.esDataTypeGeoPoint = t.exact(t.type({
  geo_point
}));
const esDataTypeGeoShape = exports.esDataTypeGeoShape = t.union([t.exact(t.type({
  geo_shape: t.string
})), t.exact(t.type({
  shape: t.string
}))]);
const esDataTypeSingle = exports.esDataTypeSingle = t.union([t.exact(t.type({
  binary
})), t.exact(t.type({
  boolean
})), t.exact(t.type({
  byte
})), t.exact(t.type({
  date
})), t.exact(t.type({
  date_nanos
})), t.exact(t.type({
  double
})), t.exact(t.type({
  float
})), t.exact(t.type({
  half_float
})), t.exact(t.type({
  integer
})), t.exact(t.type({
  ip
})), t.exact(t.type({
  keyword
})), t.exact(t.type({
  long
})), t.exact(t.type({
  short
})), t.exact(t.type({
  text
}))]);
const esDataTypeUnion = exports.esDataTypeUnion = t.union([esDataTypeRangeTerm, esDataTypeGeoPoint, esDataTypeGeoShape, esDataTypeSingle]);
const _index = exports._index = t.string;