"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSharingData = getSharingData;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _common = require("../../../../../../../src/plugins/discover/common");
var _get_sort_for_search_source = require("./get_sort_for_search_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isStringArray(arr) {
  return Array.isArray(arr) && arr.every(p => typeof p === 'string');
}
function normalizeFilter(savedSearchFilterTmp) {
  let savedSearchFilter;
  if (savedSearchFilterTmp && Array.isArray(savedSearchFilterTmp)) {
    // can not include functions: could be recursive
    savedSearchFilter = [...savedSearchFilterTmp.filter(f => typeof f !== 'function')];
  } else if (savedSearchFilterTmp && typeof savedSearchFilterTmp !== 'function') {
    savedSearchFilter = [savedSearchFilterTmp];
  }
  return savedSearchFilter;
}

/**
 * Partially copied from src/plugins/discover/public/application/apps/main/utils/get_sharing_data.ts
 */

async function getSharingData(services, currentSearchSource, savedSearch, jobParamsTimeRange, jobParamsUnsavedState) {
  var _savedSearch$attribut, _savedSearch$attribut2;
  const searchSource = currentSearchSource.createCopy();
  const index = searchSource.getField('index');
  if (!index) {
    throw new Error(`Search Source is missing the "index" field`);
  }

  // Inject sort
  searchSource.setField('sort', (0, _get_sort_for_search_source.getSortForSearchSource)(savedSearch.attributes.sort, index));

  // Remove the fields that are not suitable for export and paging
  searchSource.removeField('highlight');
  searchSource.removeField('highlightAll');
  searchSource.removeField('aggs');
  searchSource.removeField('size');
  const [hideTimeColumn, useFieldsFromSource] = await Promise.all([services.uiSettings.get(_common.DOC_HIDE_TIME_COLUMN_SETTING), services.uiSettings.get(_common.SEARCH_FIELDS_FROM_SOURCE)]);

  // Add/adjust columns from the saved search attributes and UI Settings
  let columns;
  let timeFieldName;
  // ignore '_source' column: it may be the only column when the user wishes to export all fields
  const columnsTemp = (_savedSearch$attribut = savedSearch.attributes) === null || _savedSearch$attribut === void 0 ? void 0 : (_savedSearch$attribut2 = _savedSearch$attribut.columns) === null || _savedSearch$attribut2 === void 0 ? void 0 : _savedSearch$attribut2.filter(col => col !== '_source');
  if (typeof columnsTemp !== 'undefined' && columnsTemp.length > 0 && isStringArray(columnsTemp)) {
    columns = columnsTemp;

    // conditionally add the time field column:
    if (index !== null && index !== void 0 && index.timeFieldName && !hideTimeColumn) {
      timeFieldName = index.timeFieldName;
    }
    if (timeFieldName && !columnsTemp.includes(timeFieldName)) {
      columns = [timeFieldName, ...columns];
    }

    /*
     * For querying performance, the searchSource object must have fields set.
     * Otherwise, the requests will ask for all fields, even if only a few are really needed.
     * Discover does not set fields, since having all fields is needed for the UI.
     */
    if (!useFieldsFromSource && columns.length) {
      searchSource.setField('fields', columns);
    }
  } else {
    searchSource.setField('fields', ['*']);
  }

  // Combine the job's time filter into the SearchSource instance
  let jobParamsTimeRangeFilter;
  if ((jobParamsTimeRange !== null && jobParamsTimeRange !== void 0 && jobParamsTimeRange.min || jobParamsTimeRange !== null && jobParamsTimeRange !== void 0 && jobParamsTimeRange.max) && timeFieldName) {
    var _jobParamsTimeRange$t;
    const {
      min,
      max
    } = jobParamsTimeRange;
    const timezone = (_jobParamsTimeRange$t = jobParamsTimeRange.timezone) !== null && _jobParamsTimeRange$t !== void 0 ? _jobParamsTimeRange$t : 'UTC';
    const minTime = min ? _momentTimezone.default.tz(min, timezone) : undefined;
    const maxTime = max ? _momentTimezone.default.tz(max, timezone) : undefined;
    jobParamsTimeRangeFilter = {
      meta: {
        index: index.id
      },
      query: {
        range: {
          [timeFieldName]: {
            format: 'strict_date_optional_time',
            gte: minTime === null || minTime === void 0 ? void 0 : minTime.toISOString(),
            lte: maxTime === null || maxTime === void 0 ? void 0 : maxTime.toISOString()
          }
        }
      }
    };
  }

  // Combine the time range filter from the job request body with any filters that have been saved into the saved search object
  // NOTE: if the filters that were saved into the search are NOT an array, it may be a function. Function
  // filters are not supported in this API.
  let combinedFilters = [];
  const savedSearchFilter = normalizeFilter(searchSource.getField('filter'));
  const jobParamsStateFilter = normalizeFilter(jobParamsUnsavedState === null || jobParamsUnsavedState === void 0 ? void 0 : jobParamsUnsavedState.query);
  if (jobParamsTimeRangeFilter) {
    combinedFilters.push(jobParamsTimeRangeFilter);
  }
  if (savedSearchFilter && savedSearchFilter.length > 0) {
    combinedFilters = combinedFilters.concat(savedSearchFilter);
  }
  if (jobParamsStateFilter && (jobParamsStateFilter === null || jobParamsStateFilter === void 0 ? void 0 : jobParamsStateFilter.length) > 0) {
    combinedFilters = combinedFilters.concat(jobParamsStateFilter);
  }
  searchSource.removeField('filter');
  if (combinedFilters.length > 0) {
    searchSource.setField('filter', combinedFilters);
  }
  return {
    columns,
    searchSource: searchSource.getSerializedFields(true)
  };
}