"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.telemetryIndexPattern = exports.policyIndexPattern = exports.metadataTransformPrefix = exports.metadataIndexPattern = exports.metadataCurrentIndexPattern = exports.failedFleetActionErrorCode = exports.eventsIndexPattern = exports.alertsIndexPattern = exports.UNISOLATE_HOST_ROUTE = exports.TRUSTED_APPS_UPDATE_API = exports.TRUSTED_APPS_SUMMARY_API = exports.TRUSTED_APPS_LIST_API = exports.TRUSTED_APPS_GET_API = exports.TRUSTED_APPS_DELETE_API = exports.TRUSTED_APPS_CREATE_API = exports.METADATA_UNITED_TRANSFORM = exports.METADATA_UNITED_INDEX = exports.METADATA_TRANSFORMS_PATTERN = exports.LIMITED_CONCURRENCY_ENDPOINT_ROUTE_TAG = exports.LIMITED_CONCURRENCY_ENDPOINT_COUNT = exports.ISOLATE_HOST_ROUTE = exports.HOST_METADATA_LIST_ROUTE = exports.HOST_METADATA_GET_ROUTE = exports.ENDPOINT_ACTION_RESPONSES_INDEX_PATTERN = exports.ENDPOINT_ACTION_RESPONSES_INDEX = exports.ENDPOINT_ACTION_RESPONSES_DS = exports.ENDPOINT_ACTION_LOG_ROUTE = exports.ENDPOINT_ACTIONS_INDEX = exports.ENDPOINT_ACTIONS_DS = exports.BASE_POLICY_ROUTE = exports.BASE_POLICY_RESPONSE_ROUTE = exports.BASE_ENDPOINT_ROUTE = exports.AGENT_POLICY_SUMMARY_ROUTE = exports.ACTION_STATUS_ROUTE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** endpoint data streams that are used for host isolation  */
/** for index patterns `.logs-endpoint.actions-* and .logs-endpoint.action.responses-*`*/
const ENDPOINT_ACTIONS_DS = exports.ENDPOINT_ACTIONS_DS = '.logs-endpoint.actions';
const ENDPOINT_ACTIONS_INDEX = exports.ENDPOINT_ACTIONS_INDEX = `${ENDPOINT_ACTIONS_DS}-default`;
const ENDPOINT_ACTION_RESPONSES_DS = exports.ENDPOINT_ACTION_RESPONSES_DS = '.logs-endpoint.action.responses';
const ENDPOINT_ACTION_RESPONSES_INDEX = exports.ENDPOINT_ACTION_RESPONSES_INDEX = `${ENDPOINT_ACTION_RESPONSES_DS}-default`;
// search in all namespaces and not only in default
const ENDPOINT_ACTION_RESPONSES_INDEX_PATTERN = exports.ENDPOINT_ACTION_RESPONSES_INDEX_PATTERN = `${ENDPOINT_ACTION_RESPONSES_DS}-*`;
const eventsIndexPattern = exports.eventsIndexPattern = 'logs-endpoint.events.*';
const alertsIndexPattern = exports.alertsIndexPattern = 'logs-endpoint.alerts-*';

/** index pattern for the data source index (data stream) that the Endpoint streams documents to */
const metadataIndexPattern = exports.metadataIndexPattern = 'metrics-endpoint.metadata-*';

/** index that the metadata transform writes to (destination) and that is used by endpoint APIs */
const metadataCurrentIndexPattern = exports.metadataCurrentIndexPattern = 'metrics-endpoint.metadata_current_*';

/** The metadata Transform Name prefix with NO (package) version) */
const metadataTransformPrefix = exports.metadataTransformPrefix = 'endpoint.metadata_current-default';

// metadata transforms pattern for matching all metadata transform ids
const METADATA_TRANSFORMS_PATTERN = exports.METADATA_TRANSFORMS_PATTERN = 'endpoint.metadata_*';

// united metadata transform id
const METADATA_UNITED_TRANSFORM = exports.METADATA_UNITED_TRANSFORM = 'endpoint.metadata_united-default';

// united metadata transform destination index
const METADATA_UNITED_INDEX = exports.METADATA_UNITED_INDEX = '.metrics-endpoint.metadata_united_default';
const policyIndexPattern = exports.policyIndexPattern = 'metrics-endpoint.policy-*';
const telemetryIndexPattern = exports.telemetryIndexPattern = 'metrics-endpoint.telemetry-*';
const LIMITED_CONCURRENCY_ENDPOINT_ROUTE_TAG = exports.LIMITED_CONCURRENCY_ENDPOINT_ROUTE_TAG = 'endpoint:limited-concurrency';
const LIMITED_CONCURRENCY_ENDPOINT_COUNT = exports.LIMITED_CONCURRENCY_ENDPOINT_COUNT = 100;
const BASE_ENDPOINT_ROUTE = exports.BASE_ENDPOINT_ROUTE = '/api/endpoint';
const HOST_METADATA_LIST_ROUTE = exports.HOST_METADATA_LIST_ROUTE = `${BASE_ENDPOINT_ROUTE}/metadata`;
const HOST_METADATA_GET_ROUTE = exports.HOST_METADATA_GET_ROUTE = `${BASE_ENDPOINT_ROUTE}/metadata/{id}`;
const TRUSTED_APPS_GET_API = exports.TRUSTED_APPS_GET_API = `${BASE_ENDPOINT_ROUTE}/trusted_apps/{id}`;
const TRUSTED_APPS_LIST_API = exports.TRUSTED_APPS_LIST_API = `${BASE_ENDPOINT_ROUTE}/trusted_apps`;
const TRUSTED_APPS_CREATE_API = exports.TRUSTED_APPS_CREATE_API = `${BASE_ENDPOINT_ROUTE}/trusted_apps`;
const TRUSTED_APPS_UPDATE_API = exports.TRUSTED_APPS_UPDATE_API = `${BASE_ENDPOINT_ROUTE}/trusted_apps/{id}`;
const TRUSTED_APPS_DELETE_API = exports.TRUSTED_APPS_DELETE_API = `${BASE_ENDPOINT_ROUTE}/trusted_apps/{id}`;
const TRUSTED_APPS_SUMMARY_API = exports.TRUSTED_APPS_SUMMARY_API = `${BASE_ENDPOINT_ROUTE}/trusted_apps/summary`;
const BASE_POLICY_RESPONSE_ROUTE = exports.BASE_POLICY_RESPONSE_ROUTE = `${BASE_ENDPOINT_ROUTE}/policy_response`;
const BASE_POLICY_ROUTE = exports.BASE_POLICY_ROUTE = `${BASE_ENDPOINT_ROUTE}/policy`;
const AGENT_POLICY_SUMMARY_ROUTE = exports.AGENT_POLICY_SUMMARY_ROUTE = `${BASE_POLICY_ROUTE}/summaries`;

/** Host Isolation Routes */
const ISOLATE_HOST_ROUTE = exports.ISOLATE_HOST_ROUTE = `${BASE_ENDPOINT_ROUTE}/isolate`;
const UNISOLATE_HOST_ROUTE = exports.UNISOLATE_HOST_ROUTE = `${BASE_ENDPOINT_ROUTE}/unisolate`;

/** Endpoint Actions Log Routes */
const ENDPOINT_ACTION_LOG_ROUTE = exports.ENDPOINT_ACTION_LOG_ROUTE = `/api/endpoint/action_log/{agent_id}`;
const ACTION_STATUS_ROUTE = exports.ACTION_STATUS_ROUTE = `/api/endpoint/action_status`;
const failedFleetActionErrorCode = exports.failedFleetActionErrorCode = '424';