"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidUnit = exports.isAlertExecutor = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// used for gap detection code
// eslint-disable-next-line @typescript-eslint/naming-convention

const isValidUnit = unitParam => ['s', 'm', 'h'].includes(unitParam);

/**
 * SignalSource is being used as both a type for documents that match detection engine queries as well as
 * for queries that could be on top of signals. In cases where it is matched against detection engine queries,
 * '@timestamp' might not be there since it is not required and we have timestamp override capabilities. Also
 * the signal addition object, "signal?: {" will not be there unless it's a conflicting field when we are running
 * queries on events.
 *
 * For cases where we are running queries against signals (signals on signals) "@timestamp" should always be there
 * and the "signal?: {" sub-object should always be there.
 */
exports.isValidUnit = isValidUnit;
// This returns true because by default a RuleAlertTypeDefinition is an AlertType
// since we are only increasing the strictness of params.
const isAlertExecutor = obj => {
  return true;
};

/**
 * TODO: Remove this if/when the return filter has its own type exposed
 */
exports.isAlertExecutor = isAlertExecutor;