"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIME_UNITS = exports.REPOSITORY_TYPES = exports.REPOSITORY_PLUGINS_MAP = exports.PLUGIN_REPOSITORY_TYPES = exports.PLUGIN = exports.MAJOR_VERSION = exports.DEFAULT_REPOSITORY_TYPES = exports.APP_SLM_CLUSTER_PRIVILEGES = exports.APP_RESTORE_INDEX_PRIVILEGES = exports.APP_REQUIRED_CLUSTER_PRIVILEGES = exports.API_BASE_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const basicLicense = 'basic';
const PLUGIN = exports.PLUGIN = {
  id: 'snapshot_restore',
  minimumLicenseType: basicLicense,
  getI18nName: i18n => {
    return i18n.translate('xpack.snapshotRestore.appName', {
      defaultMessage: 'Snapshot and Restore'
    });
  }
};
const MAJOR_VERSION = exports.MAJOR_VERSION = '7.16.0';
const API_BASE_PATH = exports.API_BASE_PATH = '/api/snapshot_restore/';
let REPOSITORY_TYPES = exports.REPOSITORY_TYPES = /*#__PURE__*/function (REPOSITORY_TYPES) {
  REPOSITORY_TYPES["fs"] = "fs";
  REPOSITORY_TYPES["url"] = "url";
  REPOSITORY_TYPES["source"] = "source";
  REPOSITORY_TYPES["s3"] = "s3";
  REPOSITORY_TYPES["hdfs"] = "hdfs";
  REPOSITORY_TYPES["azure"] = "azure";
  REPOSITORY_TYPES["gcs"] = "gcs";
  return REPOSITORY_TYPES;
}({}); // Deliberately do not include `source` as a default repository since we treat it as a flag
const DEFAULT_REPOSITORY_TYPES = exports.DEFAULT_REPOSITORY_TYPES = [REPOSITORY_TYPES.fs, REPOSITORY_TYPES.url];
const PLUGIN_REPOSITORY_TYPES = exports.PLUGIN_REPOSITORY_TYPES = [REPOSITORY_TYPES.s3, REPOSITORY_TYPES.hdfs, REPOSITORY_TYPES.azure, REPOSITORY_TYPES.gcs];
const REPOSITORY_PLUGINS_MAP = exports.REPOSITORY_PLUGINS_MAP = {
  'repository-s3': REPOSITORY_TYPES.s3,
  'repository-hdfs': REPOSITORY_TYPES.hdfs,
  'repository-azure': REPOSITORY_TYPES.azure,
  'repository-gcs': REPOSITORY_TYPES.gcs
};
const APP_REQUIRED_CLUSTER_PRIVILEGES = exports.APP_REQUIRED_CLUSTER_PRIVILEGES = ['cluster:admin/snapshot', 'cluster:admin/repository'];
const APP_RESTORE_INDEX_PRIVILEGES = exports.APP_RESTORE_INDEX_PRIVILEGES = ['monitor'];
const APP_SLM_CLUSTER_PRIVILEGES = exports.APP_SLM_CLUSTER_PRIVILEGES = ['manage_slm', 'cluster:monitor/state'];
const TIME_UNITS = exports.TIME_UNITS = {
  DAY: 'd',
  HOUR: 'h',
  MINUTE: 'm',
  SECOND: 's'
};