/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui.compose;

import com.intellij.docker.deployment.ui.DockerComposePaths;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeFilesTextField
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent {
    private static final List<String> DOCKER_COMPOSE_YML_EXT = List.of(".yml", ".yaml");
    private static final List<String> DOCKER_COMPOSE_YML_NAME = List.of("docker-compose", "compose");
    private static final String DOCKER_COMPOSE_OVERRIDE_YML = "docker-compose.override.yml";
    protected static final String SEPARATOR = "; ";
    @Nullable
    private final Project myProject;
    @Nullable
    private final Module myModule;
    private final List<ChangeListener> myListeners = ContainerUtil.createConcurrentList();
    private List<String> myConfigurationFiles = new SmartList();
    private boolean myAllowToChoseFolders = true;

    public DockerComposeFilesTextField(@Nullable Project project, final @Nullable Module module) {
        this.myProject = project;
        this.myModule = module;
        this.setEditable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DockerComposeFileDialog dialog2 = new DockerComposeFileDialog(DockerComposeFilesTextField.this.myProject, module, DockerComposeFilesTextField.this.myConfigurationFiles, DockerComposeFilesTextField.this.myAllowToChoseFolders);
                if (dialog2.showAndGet()) {
                    DockerComposeFilesTextField.this.setConfigurationFiles(dialog2.getConfigurationFiles());
                }
            }
        });
    }

    public void setAllowToChoseFolders(boolean allowToChooseFolders) {
        this.myAllowToChoseFolders = allowToChooseFolders;
    }

    @NotNull
    public List<String> getConfigurationFiles() {
        List<String> list2 = this.myConfigurationFiles;
        if (list2 == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public void setConfigurationFiles(@NotNull List<String> configurationFiles) {
        if (configurationFiles == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(1);
        }
        this.myConfigurationFiles = configurationFiles;
        this.setText(this.getPresentation(configurationFiles));
        this.fireStateChanged();
    }

    @NotNull
    protected String getPresentation(@NotNull List<String> configurationFiles) {
        VirtualFile baseDir;
        if (configurationFiles == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(2);
        }
        if ((baseDir = DockerComposePaths.guessBaseDir(this.myProject, this.myModule)) == null) {
            String string = StringUtil.join(configurationFiles, (String)SEPARATOR);
            if (string == null) {
                DockerComposeFilesTextField.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = configurationFiles.stream().map(path -> LocalFileSystem.getInstance().findFileByPath(path)).filter(Objects::nonNull).map(virtualFile -> this.getFilePresentation(baseDir, (VirtualFile)virtualFile)).collect(Collectors.joining(SEPARATOR));
        if (string == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String getFilePresentation(@NotNull VirtualFile baseDir, @NotNull VirtualFile file) {
        String relativePath;
        if (baseDir == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(6);
        }
        Object object = (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)baseDir)) != null ? "./" + relativePath : file.getPath();
        if (object == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(7);
        }
        return object;
    }

    public void initComposeFilePaths(@NotNull String baseDir) {
        if (baseDir == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(8);
        }
        this.setConfigurationFiles(DockerComposeFilesTextField.getConfigurationFilesFromDir(baseDir, false));
    }

    public void initComposeFilePaths(@NotNull List<String> composerFilePaths) {
        String mainConfiguration;
        if (composerFilePaths == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)(mainConfiguration = (String)ContainerUtil.getFirstItem(composerFilePaths))) && Files.isDirectory(Paths.get(mainConfiguration, new String[0]), new LinkOption[0])) {
            this.setConfigurationFiles(DockerComposeFilesTextField.getConfigurationFilesFromDir(mainConfiguration, true));
        } else {
            this.setConfigurationFiles(composerFilePaths);
        }
    }

    @NotNull
    private static List<String> getConfigurationFilesFromDir(@NotNull String configurationDir, boolean withDefault) {
        if (configurationDir == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(10);
        }
        ArrayList<String> configurationFiles = new ArrayList<String>();
        String mainConfigurationFile = DockerComposeFilesTextField.getMainConfigurationFile(configurationDir, withDefault);
        if (mainConfigurationFile != null) {
            configurationFiles.add(mainConfigurationFile);
            Path overrideConfigurationPath = Paths.get(configurationDir, DOCKER_COMPOSE_OVERRIDE_YML);
            if (Files.exists(overrideConfigurationPath, new LinkOption[0])) {
                configurationFiles.add(overrideConfigurationPath.toString());
            }
        }
        ArrayList<String> arrayList = configurationFiles;
        if (arrayList == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static String getMainConfigurationFile(@NotNull String configurationDir, boolean withDefault) {
        if (configurationDir == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(12);
        }
        for (String fileName : DOCKER_COMPOSE_YML_NAME) {
            for (String fileExt : DOCKER_COMPOSE_YML_EXT) {
                Path path = Paths.get(configurationDir, fileName + fileExt);
                if (!Files.exists(path, new LinkOption[0])) continue;
                return path.toString();
            }
        }
        return withDefault ? Paths.get(configurationDir, DOCKER_COMPOSE_YML_NAME.get(0) + DOCKER_COMPOSE_YML_EXT.get(0)).toString() : null;
    }

    public void fireStateChanged() {
        for (ChangeListener listener : this.myListeners) {
            listener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(13);
        }
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(14);
        }
        this.myListeners.remove(changeListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 8, 9, 10, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/compose/DockerComposeFilesTextField";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFiles";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerFilePaths";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationDir";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFiles";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/compose/DockerComposeFilesTextField";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePresentation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFilesFromDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilePresentation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initComposeFilePaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationFilesFromDir";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMainConfigurationFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 8, 9, 10, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }

    private static class DockerComposeFileDialog
    extends DialogWrapper {
        @Nullable
        private final Project myProject;
        @Nullable
        private final Module myModule;
        @NotNull
        private final JPanel myMainPanel;
        @NotNull
        private final JBList<String> myConfigurationFilesList;
        @NotNull
        private final DefaultListModel<String> myConfigurationFilesModel;
        private final boolean myAllowToChoseFolders;

        protected DockerComposeFileDialog(@Nullable Project project, @Nullable Module module, @NotNull List<String> configurationFiles, boolean allowToChoseFolders) {
            if (configurationFiles == null) {
                DockerComposeFileDialog.$$$reportNull$$$0(0);
            }
            super(project);
            this.setTitle(DockerBundle.message("DockerComposeFilesTextField.DockerComposeFileDialog.title", new Object[0]));
            this.myProject = project;
            this.myModule = module;
            this.myAllowToChoseFolders = allowToChoseFolders;
            this.myConfigurationFilesModel = new DefaultListModel();
            this.myConfigurationFilesList = new JBList(this.myConfigurationFilesModel);
            configurationFiles.forEach(file -> this.myConfigurationFilesModel.addElement(FileUtil.toSystemDependentName((String)file)));
            this.myMainPanel = ToolbarDecorator.createDecorator(this.myConfigurationFilesList).setAddAction(button -> this.addConfigurationFileItem()).setRemoveAction(button -> this.deleteConfigurationFileItems()).createPanel();
            this.init();
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return DockerComposeFileDialog.class.getSimpleName();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        @NotNull
        private String getChooserTitle() {
            String string = this.myAllowToChoseFolders ? DockerBundle.message("DockerComposeFilesTextField.DockerComposeFileDialog.title.chooser.fileOrFolder", new Object[0]) : DockerBundle.message("DockerComposeFilesTextField.DockerComposeFileDialog.title.chooser.fileOnly", new Object[0]);
            if (string == null) {
                DockerComposeFileDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        private void addConfigurationFileItem() {
            FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, this.myAllowToChoseFolders, false, true, false, true);
            fileChooserDescriptor.withTitle(this.getChooserTitle());
            VirtualFile toSelect = this.computeBaseDir();
            FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.myProject, this.myConfigurationFilesList, (VirtualFile)toSelect, this::onConfigurationFileChosen);
        }

        private VirtualFile computeBaseDir() {
            File file;
            if (!this.myConfigurationFilesModel.isEmpty() && (file = new File(this.myConfigurationFilesModel.get(0))).exists()) {
                return VfsUtil.findFileByIoFile((File)file, (boolean)true);
            }
            return DockerComposePaths.guessBaseDir(this.myProject, this.myModule);
        }

        private void onConfigurationFileChosen(List<VirtualFile> chosenFiles) {
            LinkedHashSet<@NlsSafe String> systemDependentPaths = new LinkedHashSet<String>();
            for (VirtualFile nextFile : chosenFiles) {
                if (nextFile.isDirectory()) {
                    DockerComposeFilesTextField.getConfigurationFilesFromDir(nextFile.getPath(), false).stream().map(FileUtil::toSystemDependentName).forEach(systemDependentPaths::add);
                    continue;
                }
                systemDependentPaths.add(FileUtil.toSystemDependentName((String)nextFile.getPath()));
            }
            Collections.list(this.myConfigurationFilesModel.elements()).forEach(systemDependentPaths::remove);
            systemDependentPaths.forEach(configurationFile -> this.myConfigurationFilesModel.addElement((String)configurationFile));
        }

        private void deleteConfigurationFileItems() {
            ListUtil.removeSelectedItems(this.myConfigurationFilesList);
        }

        @NotNull
        public List<String> getConfigurationFiles() {
            SmartList configurationFilePaths = new SmartList();
            for (int i = 0; i < this.myConfigurationFilesList.getModel().getSize(); ++i) {
                configurationFilePaths.add((String)this.myConfigurationFilesList.getModel().getElementAt(i));
            }
            SmartList smartList = configurationFilePaths;
            if (smartList == null) {
                DockerComposeFileDialog.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationFiles";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/deployment/ui/compose/DockerComposeFilesTextField$DockerComposeFileDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/deployment/ui/compose/DockerComposeFilesTextField$DockerComposeFileDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChooserTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

