/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.openapi.util.text.Strings;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerAgentRepositoryConfigImpl
implements DockerAgentRepositoryConfig {
    private final DockerRepositoryModel myModel;
    private final DockerRepoTag myRepoTag;

    public DockerAgentRepositoryConfigImpl(DockerRepositoryModel model2) {
        this.myModel = model2;
        DockerRegistryConfiguration registry = model2.getRegistry();
        Object namespace = Strings.notNullize((String)model2.getNamespace());
        if (Strings.isNotEmpty((String)namespace)) {
            namespace = (String)namespace + "/";
        }
        this.myRepoTag = DockerRepoTag.fromString((String)namespace + model2.getRepository());
        if (this.myRepoTag.getDomain() == null) {
            this.myRepoTag.setDomain(registry != null ? registry.getAddress() : null);
        }
        if (this.myRepoTag.getNamespace() == null) {
            this.myRepoTag.setNamespace(registry != null ? registry.getUsername() : null);
        }
        this.myRepoTag.setTag(model2.getTag());
    }

    @Override
    public DockerAuthConfig getAuthConfig() {
        return Optional.ofNullable(this.myModel.getRegistry()).map(DockerRegistryConfiguration::getAuthConfig).orElse(null);
    }

    @Override
    @NotNull
    public String getQualifiedRepository() {
        String string = this.myRepoTag.getQualifiedRepository();
        if (string == null) {
            DockerAgentRepositoryConfigImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public String getTag() {
        return this.myRepoTag.getTagNotNull();
    }

    @Override
    @Nullable
    public String getPlatform() {
        return this.myRepoTag.getPlatform();
    }

    @Override
    @Nullable
    public String getDigest() {
        return this.myRepoTag.getDigest();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/registry/DockerAgentRepositoryConfigImpl", "getQualifiedRepository"));
    }
}

