/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.google.common.net.HostAndPort;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsCase;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.common.ExtraHostsBuilder;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMappingSettings;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerProcessUtil {
    private static final Logger LOG = Logger.getInstance(DockerProcessUtil.class);

    @NotNull
    public static DockerExecProcess prepareAndStartProcess(@NotNull DockerAgentDeploymentConfigImpl config2, @NotNull GeneralCommandLine commandLine, @NotNull RemoteDockerRuntime dockerRuntime, @Nullable DockerContainerSettings containerSettings, @NotNull PortsBuilder portsBuilder, boolean openForIncomingConnections) throws ServerRuntimeException, RemoteSdkException, IOException {
        if (config2 == null) {
            DockerProcessUtil.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            DockerProcessUtil.$$$reportNull$$$0(1);
        }
        if (dockerRuntime == null) {
            DockerProcessUtil.$$$reportNull$$$0(2);
        }
        if (portsBuilder == null) {
            DockerProcessUtil.$$$reportNull$$$0(3);
        }
        DockerProcessUtil.prepareConfig(config2, commandLine, containerSettings, portsBuilder, openForIncomingConnections, true);
        if (containerSettings != null && containerSettings.getVersion() < 2) {
            DockerExecProcess dockerExecProcess = DockerExecProcess.Factory.startProcessWithRemove(dockerRuntime, config2);
            if (dockerExecProcess == null) {
                DockerProcessUtil.$$$reportNull$$$0(4);
            }
            return dockerExecProcess;
        }
        DockerExecProcess dockerExecProcess = DockerExecProcess.Factory.startProcess(dockerRuntime, config2);
        if (dockerExecProcess == null) {
            DockerProcessUtil.$$$reportNull$$$0(5);
        }
        return dockerExecProcess;
    }

    public static void prepareConfig(@NotNull DockerAgentDeploymentConfigImpl config2, @NotNull GeneralCommandLine commandLine, @Nullable DockerContainerSettings containerSettings, @NotNull PortsBuilder portsBuilder, boolean openForIncomingConnections, boolean setupPorts) {
        if (config2 == null) {
            DockerProcessUtil.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            DockerProcessUtil.$$$reportNull$$$0(7);
        }
        if (portsBuilder == null) {
            DockerProcessUtil.$$$reportNull$$$0(8);
        }
        if (containerSettings != null) {
            portsBuilder.addPortBindings(containerSettings.getPortBindings());
        }
        if (containerSettings != null && containerSettings.getVersion() < 2) {
            config2.withEntrypoint(ArrayUtil.EMPTY_STRING_ARRAY);
        }
        EnvsBuilder envsBuilder = EnvsBuilder.builder().addEnvs(commandLine.getEnvironment());
        if (containerSettings != null) {
            envsBuilder.addEnvs(containerSettings.getEnvVars());
        }
        config2.withEnvs(envsBuilder.withPassParentEnvironment(true).buildEnvs());
        if (setupPorts) {
            if (containerSettings != null && containerSettings.isPublishAllPorts()) {
                config2.withPublishAllPorts(true);
            } else {
                config2.withPortBindings(portsBuilder.buildPortBindings());
            }
            config2.withExposedPorts(portsBuilder.buildExposedPorts());
        }
        if (containerSettings != null && containerSettings.getVersion() < 2) {
            if (containerSettings.isNetworkDisabled()) {
                config2.withNetworkDisabled(true);
            } else if (StringUtil.isNotEmpty((String)containerSettings.getNetworkMode())) {
                config2.withNetworkMode(containerSettings.getNetworkMode());
            }
        } else if (openForIncomingConnections) {
            config2.withNetworkMode("host");
        }
        if (containerSettings != null && containerSettings.getVersion() < 2) {
            config2.withLinks(containerSettings.getLinks());
            config2.withExtraHosts(ExtraHostsBuilder.builder().addExtraHosts(containerSettings.getExtraHosts()).build());
        }
    }

    @NotNull
    public static File buildDockerImageArchive(@NotNull File dockerfile, File ... srcHelpersDirs) throws IOException {
        if (dockerfile == null) {
            DockerProcessUtil.$$$reportNull$$$0(9);
        }
        if (srcHelpersDirs == null) {
            DockerProcessUtil.$$$reportNull$$$0(10);
        }
        File tarFile2 = FileUtil.createTempFile((String)"helpers-docker-image", (String)".tar");
        DockerProcessUtil.debug("Temp file ''{0}'' for building Docker image with helpers created", tarFile2.getPath());
        try (TarArchiveOutputStream tarStream = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile2))));){
            tarStream.setLongFileMode(2);
            tarStream.setBigNumberMode(1);
            for (File srcHelpersDir : srcHelpersDirs) {
                DockerProcessUtil.debug("Traversing ''{0}'' source helpers directory", srcHelpersDir.getPath());
                for (File file : FileUtils.listFiles((File)srcHelpersDir, (IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.directoryFileFilter())) {
                    String tarEntryName = FileUtil.getRelativePath((File)srcHelpersDir, (File)file);
                    if (tarEntryName == null) {
                        DockerProcessUtil.warn("Failed to determine relative path for file ''{0}'' with base directory ''{1}''", srcHelpersDir.getAbsolutePath(), file.getAbsolutePath());
                        continue;
                    }
                    DockerProcessUtil.addArchiveEntry(tarStream, file, tarEntryName);
                }
            }
            DockerProcessUtil.addArchiveEntry(tarStream, dockerfile, "Dockerfile");
        }
        File file = tarFile2;
        if (file == null) {
            DockerProcessUtil.$$$reportNull$$$0(11);
        }
        return file;
    }

    private static void addArchiveEntry(@NotNull TarArchiveOutputStream tarStream, @NotNull File file, @NotNull String tarEntryName) throws IOException {
        block14: {
            if (tarStream == null) {
                DockerProcessUtil.$$$reportNull$$$0(12);
            }
            if (file == null) {
                DockerProcessUtil.$$$reportNull$$$0(13);
            }
            if (tarEntryName == null) {
                DockerProcessUtil.$$$reportNull$$$0(14);
            }
            DockerProcessUtil.debug("Adding ''{0}'' {1} to the archive as ''{2}''", file.getPath(), file.isDirectory() ? "directory" : "file", tarEntryName);
            TarArchiveEntry tarEntry = new TarArchiveEntry(file);
            tarEntry.setName(tarEntryName);
            try (Closeable ignored = DockerProcessUtil.putArchiveEntry(tarStream, tarEntry);){
                if (tarEntry.isDirectory()) break block14;
                try (FileInputStream is = new FileInputStream(file);){
                    IOUtils.copyLarge((InputStream)is, (OutputStream)tarStream);
                }
            }
        }
    }

    private static void debug(@NotNull String pattern, Object ... arguments) {
        if (pattern == null) {
            DockerProcessUtil.$$$reportNull$$$0(15);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(MessageFormat.format(pattern, arguments));
        }
    }

    private static void warn(@NotNull String pattern, Object ... arguments) {
        if (pattern == null) {
            DockerProcessUtil.$$$reportNull$$$0(16);
        }
        LOG.warn(MessageFormat.format(pattern, arguments));
    }

    public static String @NotNull [] getShContainerCommand() {
        String[] stringArray = new String[]{"/bin/sh"};
        if (stringArray == null) {
            DockerProcessUtil.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    @NotNull
    public static VolumesBuilder setupVolumesBinds(@Nullable PathMappingSettings mappings2) {
        return DockerProcessUtil.setupVolumesBinds(mappings2, null);
    }

    @NotNull
    public static VolumesBuilder setupVolumesBinds(@Nullable PathMappingSettings mappings2, @Nullable DockerContainerSettings containerSettings) {
        VolumesBuilder bindingBuilder = VolumesBuilder.builder();
        if (mappings2 != null) {
            for (PathMappingSettings.PathMapping mapping : mappings2.getPathMappings()) {
                String localRoot = mapping.getLocalRoot();
                if (localRoot == null) continue;
                String localPath = FileUtil.toSystemDependentName((String)localRoot);
                bindingBuilder.addBoundVolume(mapping.getRemoteRoot(), localPath);
            }
        }
        if (containerSettings != null) {
            bindingBuilder.addBoundVolumes(containerSettings.getVolumeBindings());
        }
        VolumesBuilder volumesBuilder = bindingBuilder;
        if (volumesBuilder == null) {
            DockerProcessUtil.$$$reportNull$$$0(18);
        }
        return volumesBuilder;
    }

    @NotNull
    public static String getBuildVersion() {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        if (string == null) {
            DockerProcessUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static DockerCredentialsHolder getDockerCredentialsHolder(@NotNull RemoteSdkAdditionalData commonCredentials) {
        if (commonCredentials == null) {
            DockerProcessUtil.$$$reportNull$$$0(20);
        }
        final Ref result2 = Ref.create();
        commonCredentials.switchOnConnectionType(new CredentialsCase[]{new DockerCredentialsCase(){

            public void process(DockerCredentialsHolder credentials) {
                result2.set((Object)credentials);
            }
        }});
        if (result2.isNull()) {
            throw new IllegalArgumentException();
        }
        DockerCredentialsHolder dockerCredentialsHolder = (DockerCredentialsHolder)result2.get();
        if (dockerCredentialsHolder == null) {
            DockerProcessUtil.$$$reportNull$$$0(21);
        }
        return dockerCredentialsHolder;
    }

    @NotNull
    public static PortsBuilder getWebServerBindPorts(@Nullable HostAndPort data2) {
        PortsBuilder portsBuilder = PortsBuilder.builder();
        if (data2 != null && data2.hasPort()) {
            portsBuilder.addPortBinding(data2.getPort(), data2.getPort());
        }
        PortsBuilder portsBuilder2 = portsBuilder;
        if (portsBuilder2 == null) {
            DockerProcessUtil.$$$reportNull$$$0(22);
        }
        return portsBuilder2;
    }

    @NotNull
    private static Closeable putArchiveEntry(final @NotNull TarArchiveOutputStream stream, @NotNull TarArchiveEntry archiveEntry) throws IOException {
        if (stream == null) {
            DockerProcessUtil.$$$reportNull$$$0(23);
        }
        if (archiveEntry == null) {
            DockerProcessUtil.$$$reportNull$$$0(24);
        }
        stream.putArchiveEntry(archiveEntry);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                stream.closeArchiveEntry();
            }
        };
    }

    public static boolean isInvalidLinuxEnvName(@Nullable String string) {
        return StringUtil.isEmptyOrSpaces((String)string) || string.contains("=");
    }

    public static void removeIncorrectVariables(Map<String, String> envs) {
        envs.entrySet().removeIf(e -> DockerProcessUtil.isInvalidLinuxEnvName((String)e.getKey()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 11, 17, 18, 19, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portsBuilder";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerProcessUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerfile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcHelpersDirs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarStream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarEntryName";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCredentials";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerProcessUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareAndStartProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerImageArchive";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getShContainerCommand";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setupVolumesBinds";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildVersion";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerCredentialsHolder";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebServerBindPorts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareAndStartProcess";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareConfig";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerImageArchive";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addArchiveEntry";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDockerCredentialsHolder";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "putArchiveEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 11, 17, 18, 19, 21, 22 -> new IllegalStateException(string);
        };
    }
}

