/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.codeInspection.htmlInspections.XmlAttributeRenameFix;
import com.intellij.codeInspection.htmlInspections.XmlUnknownAttributeQuickFixProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.EditDistance;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownAttributeInspectionBase
extends HtmlUnknownElementInspection {
    private static final Key<HtmlUnknownElementInspection> ATTRIBUTE_KEY = Key.create((String)"HtmlUnknownAttribute");
    private static final Logger LOG = Logger.getInstance(HtmlUnknownAttributeInspectionBase.class);

    public HtmlUnknownAttributeInspectionBase() {
        this("");
    }

    public HtmlUnknownAttributeInspectionBase(String defaultValues) {
        super(defaultValues);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "HtmlUnknownAttribute";
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(0);
        }
        return logger;
    }

    @Override
    protected void checkAttribute(@NotNull XmlAttribute attribute, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        XmlTag tag;
        if (attribute == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(2);
        }
        if ((tag = attribute.getParent()) instanceof HtmlTag) {
            XmlElementDescriptor elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                return;
            }
            ArrayList<LocalQuickFix> quickfixes = new ArrayList<LocalQuickFix>(6);
            String name = attribute.getName();
            boolean isFixRequired = false;
            XmlAttributeDescriptor attributeDescriptor = attribute.getDescriptor();
            if (attributeDescriptor == null && !attribute.isNamespaceDeclaration()) {
                if (!(XmlUtil.attributeFromTemplateFramework(name, tag) || this.isCustomValuesEnabled() && this.isCustomValue(name))) {
                    isFixRequired = true;
                    boolean maySwitchToHtml5 = HtmlUtil.isCustomHtml5Attribute(name) && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag);
                    quickfixes.add(new AddCustomHtmlElementIntentionAction(ATTRIBUTE_KEY, name, XmlAnalysisBundle.message((String)"html.quickfix.add.custom.html.attribute", (Object[])new Object[]{name})));
                    quickfixes.add(new RemoveAttributeIntentionFix(name));
                    if (maySwitchToHtml5) {
                        quickfixes.add(new SwitchToHtml5WithHighPriorityAction());
                    }
                    HtmlUnknownAttributeInspectionBase.addSimilarAttributesQuickFixes(tag, name, quickfixes);
                }
            } else if (attributeDescriptor instanceof XmlAttributeDescriptorEx) {
                ((XmlAttributeDescriptorEx)attributeDescriptor).validateAttributeName(attribute, holder, isOnTheFly);
            }
            ProblemHighlightType highlightType = HtmlUnknownAttributeInspectionBase.addUnknownXmlAttributeQuickFixes(tag, name, quickfixes, holder, isFixRequired);
            if (!quickfixes.isEmpty()) {
                HtmlUnknownAttributeInspectionBase.registerProblemOnAttributeName(attribute, XmlAnalysisBundle.message((String)"xml.inspections.attribute.is.not.allowed.here", (Object[])new Object[]{name}), holder, highlightType, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static void addSimilarAttributesQuickFixes(XmlTag tag, String name, ArrayList<? super LocalQuickFix> quickfixes) {
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        XmlAttributeDescriptor[] descriptors = descriptor.getAttributesDescriptors(tag);
        int initialSize = quickfixes.size();
        for (XmlAttributeDescriptor attr : descriptors) {
            if (EditDistance.optimalAlignment((CharSequence)name, (CharSequence)attr.getName(), (boolean)false, (int)1) <= 1) {
                quickfixes.add(new XmlAttributeRenameFix(attr));
            }
            if (quickfixes.size() >= initialSize + 3) break;
        }
    }

    @NotNull
    private static ProblemHighlightType addUnknownXmlAttributeQuickFixes(XmlTag tag, String name, ArrayList<? super LocalQuickFix> quickfixes, ProblemsHolder holder, boolean isFixRequired) {
        ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        for (XmlUnknownAttributeQuickFixProvider fixProvider : XmlUnknownAttributeQuickFixProvider.EP_NAME.getExtensionList()) {
            quickfixes.addAll(fixProvider.getOrRegisterAttributeFixes(tag, name, holder, isFixRequired));
            ProblemHighlightType providerHighlightType = fixProvider.getProblemHighlightType((PsiElement)tag);
            if (highlightType != ProblemHighlightType.GENERIC_ERROR_OR_WARNING || providerHighlightType == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) continue;
            highlightType = providerHighlightType;
        }
        if (XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)tag) && ProblemHighlightType.WEAK_WARNING.ordinal() < highlightType.ordinal()) {
            highlightType = ProblemHighlightType.WEAK_WARNING;
        }
        ProblemHighlightType problemHighlightType = highlightType;
        if (problemHighlightType == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(3);
        }
        return problemHighlightType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addUnknownXmlAttributeQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

