/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.highlighting.DomCollectionProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptorImpl;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementAnnotationHolderImpl
extends SmartList<DomElementProblemDescriptor>
implements DomElementAnnotationHolder {
    private static final Logger LOG = Logger.getInstance(DomElementAnnotationHolderImpl.class);
    private final SmartList<Annotation> myAnnotations;
    private final boolean myOnTheFly;
    private final DomFileElement myFileElement;
    private final AnnotationHolder myAnnotationHolder;

    public DomElementAnnotationHolderImpl(boolean onTheFly, @NotNull DomFileElement fileElement, @NotNull AnnotationHolder toFill) {
        if (fileElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(0);
        }
        if (toFill == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(1);
        }
        this.myAnnotations = new SmartList();
        this.myOnTheFly = onTheFly;
        this.myFileElement = fileElement;
        this.myAnnotationHolder = toFill;
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @NotNull
    public DomFileElement<?> getFileElement() {
        DomFileElement domFileElement = this.myFileElement;
        if (domFileElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(2);
        }
        return domFileElement;
    }

    @NotNull
    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, @Nullable @InspectionMessage String message, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(3);
        }
        if (fixes == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(4);
        }
        DomElementProblemDescriptor domElementProblemDescriptor = this.createProblem(domElement, HighlightSeverity.ERROR, message, fixes);
        if (domElementProblemDescriptor == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(5);
        }
        return domElementProblemDescriptor;
    }

    @NotNull
    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, DomCollectionChildDescription childDescription, @Nullable @InspectionMessage String message) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(6);
        }
        DomCollectionProblemDescriptorImpl domCollectionProblemDescriptorImpl = this.addProblem(new DomCollectionProblemDescriptorImpl(domElement, message, HighlightSeverity.ERROR, childDescription));
        if (domCollectionProblemDescriptorImpl == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(7);
        }
        return domCollectionProblemDescriptorImpl;
    }

    @NotNull
    public final DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, @InspectionMessage String message) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(8);
        }
        DomElementProblemDescriptor domElementProblemDescriptor = this.createProblem(domElement, highlightType, message, LocalQuickFix.EMPTY_ARRAY);
        if (domElementProblemDescriptor == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(9);
        }
        return domElementProblemDescriptor;
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, @InspectionMessage String message, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(10);
        }
        if (fixes == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(11);
        }
        return this.createProblem(domElement, highlightType, message, (TextRange)null, fixes);
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, @InspectionMessage String message, TextRange textRange, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(12);
        }
        if (fixes == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(13);
        }
        return this.addProblem(new DomElementProblemDescriptorImpl(domElement, message, highlightType, textRange, null, fixes));
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, ProblemHighlightType highlightType, @InspectionMessage String message, @Nullable TextRange textRange, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(14);
        }
        if (fixes == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(15);
        }
        return this.addProblem(new DomElementProblemDescriptorImpl(domElement, message, HighlightSeverity.ERROR, textRange, highlightType, fixes));
    }

    @NotNull
    public DomElementResolveProblemDescriptor createResolveProblem(@NotNull GenericDomValue element, @NotNull PsiReference reference) {
        if (element == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(16);
        }
        if (reference == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(17);
        }
        DomElementResolveProblemDescriptor domElementResolveProblemDescriptor = this.addProblem(new DomElementResolveProblemDescriptorImpl(element, reference, this.getQuickFixes(element, reference)));
        if (domElementResolveProblemDescriptor == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(18);
        }
        return domElementResolveProblemDescriptor;
    }

    @NotNull
    public AnnotationHolder getAnnotationHolder() {
        AnnotationHolder annotationHolder = this.myAnnotationHolder;
        if (annotationHolder == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(19);
        }
        return annotationHolder;
    }

    public final SmartList<Annotation> getAnnotations() {
        return this.myAnnotations;
    }

    public int getSize() {
        return this.size();
    }

    @NotNull
    private @NotNull LocalQuickFix @NotNull [] getQuickFixes(GenericDomValue element, PsiReference reference) {
        Object[] localQuickFixes;
        if (!this.myOnTheFly) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                DomElementAnnotationHolderImpl.$$$reportNull$$$0(20);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        Converter converter = WrappingConverter.getDeepestConverter((Converter)element.getConverter(), (GenericDomValue)element);
        if (converter instanceof ResolvingConverter) {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
            ContainerUtil.addAll((Collection)result2, (Object[])resolvingConverter.getQuickFixes(ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)element))));
        }
        if (reference instanceof LocalQuickFixProvider && (localQuickFixes = ((LocalQuickFixProvider)reference).getQuickFixes()) != null) {
            ContainerUtil.addAll((Collection)result2, (Object[])localQuickFixes);
        }
        LocalQuickFix[] localQuickFixArray = result2.isEmpty() ? LocalQuickFix.EMPTY_ARRAY : result2.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(21);
        }
        return localQuickFixArray;
    }

    public <T extends DomElementProblemDescriptor> T addProblem(T problemDescriptor) {
        this.add(problemDescriptor);
        return problemDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7, 9, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFill";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileElement";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblem";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolveProblem";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationHolder";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createProblem";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createResolveProblem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7, 9, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

