/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedChildDescriptionImpl
extends DomChildDescriptionImpl
implements DomFixedChildDescription {
    private final Collection<JavaMethod>[] myGetterMethods;
    private final int myCount;

    public FixedChildDescriptionImpl(XmlName tagName, Type type, int count, Collection<JavaMethod>[] getterMethods) {
        super(tagName, type);
        assert (getterMethods.length == count || getterMethods == ArrayUtilRt.EMPTY_COLLECTION_ARRAY);
        this.myCount = count;
        this.myGetterMethods = getterMethods;
    }

    public JavaMethod getGetterMethod(int index) {
        if (this.myGetterMethods.length == 0) {
            return null;
        }
        Collection<JavaMethod> methods = this.myGetterMethods[index];
        return methods == null || methods.isEmpty() ? null : methods.iterator().next();
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(int index, Class<? extends T> annotationClass) {
        T annotation;
        Annotation annotation2;
        JavaMethod method = this.getGetterMethod(index);
        if (method != null && (annotation2 = method.getAnnotation(annotationClass)) != null) {
            return (T)annotation2;
        }
        Type elemType = this.getType();
        if (elemType instanceof AnnotatedElement && (annotation = ((AnnotatedElement)((Object)elemType)).getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        return super.getAnnotation(annotationClass);
    }

    public int getCount() {
        return this.myCount;
    }

    @NotNull
    public List<? extends DomElement> getValues(@NotNull DomElement element) {
        if (element == null) {
            FixedChildDescriptionImpl.$$$reportNull$$$0(0);
        }
        SmartList result2 = new SmartList();
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(element);
        if (handler2 != null) {
            for (int i = 0; i < this.myCount; ++i) {
                result2.add(handler2.getFixedChild((Pair<? extends FixedChildDescriptionImpl, Integer>)Pair.create((Object)this, (Object)i)).getProxy());
            }
        } else {
            for (Collection<JavaMethod> methods : this.myGetterMethods) {
                if (methods == null || methods.isEmpty()) continue;
                result2.add((DomElement)methods.iterator().next().invoke((Object)element, ArrayUtilRt.EMPTY_OBJECT_ARRAY));
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            FixedChildDescriptionImpl.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    @NotNull
    @NlsSafe
    public String getCommonPresentableName(@NotNull DomNameStrategy strategy) {
        if (strategy == null) {
            FixedChildDescriptionImpl.$$$reportNull$$$0(2);
        }
        String string = StringUtil.capitalizeWords((String)strategy.splitIntoWords(this.getXmlElementName()), (boolean)true);
        if (string == null) {
            FixedChildDescriptionImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(0, annotationClass);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FixedChildDescriptionImpl that = (FixedChildDescriptionImpl)o;
        if (this.myCount != that.myCount) {
            return false;
        }
        return Arrays.equals(this.myGetterMethods, that.myGetterMethods);
    }

    public String toString() {
        return this.getXmlElementName() + " " + String.valueOf(this.getGetterMethod(0)) + " " + String.valueOf(this.getType());
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 29 * result2 + this.myCount;
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/FixedChildDescriptionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/FixedChildDescriptionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPresentableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

