/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import org.intellij.plugins.relaxNG.validation.Psi2SaxAdapter;
import org.intellij.plugins.relaxNG.validation.RngParser;
import org.intellij.plugins.relaxNG.validation.RngSchemaValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class XmlInstanceValidator {
    private static final Logger LOG = Logger.getInstance(XmlInstanceValidator.class);

    private XmlInstanceValidator() {
    }

    public static void doValidation(@NotNull XmlDocument doc, Validator.ValidationHost host, XmlFile descriptorFile) {
        if (doc == null) {
            XmlInstanceValidator.$$$reportNull$$$0(0);
        }
        try {
            Schema schema = RngParser.getCachedSchema(descriptorFile);
            if (schema == null) {
                return;
            }
            ErrorHandler eh = MyErrorHandler.create(doc, host);
            if (eh == null) {
                return;
            }
            PropertyMapBuilder builder2 = new PropertyMapBuilder();
            builder2.put(ValidateProperty.ERROR_HANDLER, eh);
            ContentHandler handler2 = schema.createValidator(builder2.toPropertyMap()).getContentHandler();
            doc.accept((PsiElementVisitor)new Psi2SaxAdapter(handler2));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "org/intellij/plugins/relaxNG/validation/XmlInstanceValidator", "doValidation"));
    }

    private static final class MyErrorHandler
    implements ErrorHandler {
        private final Validator.ValidationHost myHost;
        private final Document myDocument;
        private final PsiFile myFile;

        private MyErrorHandler(XmlDocument doc, Validator.ValidationHost host) {
            this.myHost = host;
            this.myFile = doc.getContainingFile();
            this.myDocument = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        }

        @Override
        public void warning(SAXParseException exception) {
            RngSchemaValidator.handleError(exception, this.myFile, this.myDocument, new RngSchemaValidator.ValidationMessageConsumer(){

                @Override
                public void onMessage(@NotNull PsiElement context, @NotNull String message) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (message == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    myHost.addMessage(context, message, Validator.ValidationHost.ErrorType.WARNING);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "message";
                            break;
                        }
                    }
                    objectArray[1] = "org/intellij/plugins/relaxNG/validation/XmlInstanceValidator$MyErrorHandler$1";
                    objectArray[2] = "onMessage";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Override
        public void error(SAXParseException exception) {
            RngSchemaValidator.handleError(exception, this.myFile, this.myDocument, new RngSchemaValidator.ValidationMessageConsumer(){

                @Override
                public void onMessage(@NotNull PsiElement context, @NotNull String message) {
                    if (context == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (message == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    myHost.addMessage(context, message, Validator.ValidationHost.ErrorType.ERROR);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "message";
                            break;
                        }
                    }
                    objectArray[1] = "org/intellij/plugins/relaxNG/validation/XmlInstanceValidator$MyErrorHandler$2";
                    objectArray[2] = "onMessage";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Override
        public void fatalError(SAXParseException exception) {
            RngSchemaValidator.handleError(exception, this.myFile, this.myDocument, new RngSchemaValidator.ValidationMessageConsumer(){

                @Override
                public void onMessage(@NotNull PsiElement context, @NotNull String message) {
                    if (context == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (message == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    myHost.addMessage(context, message, Validator.ValidationHost.ErrorType.ERROR);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "message";
                            break;
                        }
                    }
                    objectArray[1] = "org/intellij/plugins/relaxNG/validation/XmlInstanceValidator$MyErrorHandler$3";
                    objectArray[2] = "onMessage";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Nullable
        public static ErrorHandler create(XmlDocument doc, Validator.ValidationHost host) {
            XmlTag rootTag = doc.getRootTag();
            if (rootTag == null) {
                return null;
            }
            return new MyErrorHandler(doc, host);
        }
    }
}

