/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColors;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.ui.Gray;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramColorManager {
    @NotNull
    public Color getNodeHeaderBackground(@NotNull DiagramBuilder builder, @NotNull DiagramNode node, Object element) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(0);
        }
        if (node == null) {
            DiagramColorManager.$$$reportNull$$$0(1);
        }
        Color color = Objects.requireNonNull(builder.getColorScheme().getColor(DiagramColors.NODE_HEADER));
        if (color == null) {
            DiagramColorManager.$$$reportNull$$$0(2);
        }
        return color;
    }

    @NotNull
    public Color getNodeBackground(@NotNull DiagramBuilder builder, @NotNull DiagramNode node, Object element, boolean selected) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(3);
        }
        if (node == null) {
            DiagramColorManager.$$$reportNull$$$0(4);
        }
        if (selected) {
            Color color = UIUtil.getListSelectionBackground((boolean)true);
            if (color == null) {
                DiagramColorManager.$$$reportNull$$$0(5);
            }
            return color;
        }
        return DiagramColorManager.getColorFromScheme(builder, node instanceof DiagramNoteNode ? DiagramColors.NOTE_BACKGROUND : DiagramColors.NODE_BACKGROUND);
    }

    @NotNull
    public Color getNodeSloppyBackgroundColor(@NotNull DiagramBuilder builder, @NotNull DiagramNode node, boolean selected) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(6);
        }
        if (node == null) {
            DiagramColorManager.$$$reportNull$$$0(7);
        }
        return DiagramColorManager.getColorFromScheme(builder, node instanceof DiagramNoteNode ? DiagramColors.NOTE_SLOPPY_BACKGROUND : DiagramColors.NODE_SLOPPY_BACKGROUND);
    }

    @NotNull
    public Color getNodeBorderColor(@NotNull DiagramBuilder builder, @Nullable DiagramNode node, boolean isSelected) {
        Color permanentHighlighted;
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(8);
        }
        if (GraphExportService.getInstance().isPrintMode()) {
            Gray gray = Gray._168;
            if (gray == null) {
                DiagramColorManager.$$$reportNull$$$0(9);
            }
            return gray;
        }
        if (isSelected) {
            Color color = this.getSelectedNodeBorderColor(builder, node);
            if (color == null) {
                DiagramColorManager.$$$reportNull$$$0(10);
            }
            return color;
        }
        Color color = permanentHighlighted = node == null ? null : DiagramSelectionService.getInstance().getPermanentHighlighting(builder, node);
        if (permanentHighlighted != null) {
            Color color2 = permanentHighlighted;
            if (color2 == null) {
                DiagramColorManager.$$$reportNull$$$0(11);
            }
            return color2;
        }
        return DiagramColorManager.getColorFromScheme(builder, node instanceof DiagramNoteNode ? DiagramColors.NOTE_BORDER : DiagramColors.NODE_BORDER);
    }

    @NotNull
    public Color getSelectedNodeBorderColor(@NotNull DiagramBuilder builder, @Nullable DiagramNode node) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(12);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.SELECTED_NODE_BORDER);
    }

    @NotNull
    public Color getHighlightedNodeBorderColor(@NotNull DiagramBuilder builder, @Nullable DiagramNode node) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(13);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.HIGHLIGHTED_NODE_BORDER);
    }

    @NotNull
    public Color getNodeForeground(@NotNull DiagramBuilder builder, @NotNull DiagramNode node, @Nullable Object element, boolean selected) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(14);
        }
        if (node == null) {
            DiagramColorManager.$$$reportNull$$$0(15);
        }
        Color color = builder.getColorScheme().getDefaultForeground();
        if (color == null) {
            DiagramColorManager.$$$reportNull$$$0(16);
        }
        return color;
    }

    @NotNull
    public Color getEdgeColor(@NotNull DiagramBuilder builder, @NotNull DiagramEdge edge) {
        ColorKey colorKey;
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(17);
        }
        if (edge == null) {
            DiagramColorManager.$$$reportNull$$$0(18);
        }
        Color color = (colorKey = this.getEdgeColorKey(builder, edge)) != null ? DiagramColorManager.getColorFromScheme(builder, colorKey) : this.getEdgeColor(edge);
        if (color == null) {
            DiagramColorManager.$$$reportNull$$$0(19);
        }
        return color;
    }

    @Nullable
    public ColorKey getEdgeColorKey(@NotNull DiagramBuilder builder, @NotNull DiagramEdge edge) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(20);
        }
        if (edge == null) {
            DiagramColorManager.$$$reportNull$$$0(21);
        }
        return null;
    }

    @Deprecated
    public Color getEdgeColor(@NotNull DiagramEdge edge) {
        if (edge == null) {
            DiagramColorManager.$$$reportNull$$$0(22);
        }
        return DiagramColors.DEFAULT_EDGE.getDefaultColor();
    }

    @NotNull
    public Color getEdgeSelectionColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(23);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.EDGE_SELECTION);
    }

    @NotNull
    public Color getBendColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(24);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.BEND);
    }

    @NotNull
    public Color getBendSelectionColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(25);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.BEND_SELECTION);
    }

    @NotNull
    public Color getSelectionBoxBorderColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(26);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.SELECTION_BOX_BORDER);
    }

    @NotNull
    public Color getSelectionBoxBackgroundColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(27);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.SELECTION_BOX_BACKGROUND);
    }

    @NotNull
    public Color getHotSpotColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(28);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.HOT_SPOT);
    }

    @NotNull
    public Color getPortColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(29);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.PORT);
    }

    @NotNull
    public Color getSnappingColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(30);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.SNAPPING);
    }

    @NotNull
    public Color getFineGridColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(31);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.FINE_GRID);
    }

    @NotNull
    public Color getCoarseGridColor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(32);
        }
        return DiagramColorManager.getColorFromScheme(builder, DiagramColors.COARSE_GRID);
    }

    @NotNull
    public Color getToolbarBackground() {
        Color color = UIUtil.getPanelBackground();
        if (color == null) {
            DiagramColorManager.$$$reportNull$$$0(33);
        }
        return color;
    }

    @NotNull
    public Font getNodeBodyFont() {
        Font font = StartupUiUtil.getLabelFont();
        if (font == null) {
            DiagramColorManager.$$$reportNull$$$0(34);
        }
        return font;
    }

    @NotNull
    public Font getNodeHeaderFont(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(35);
        }
        Font bodyFont = this.getNodeBodyFont();
        Font font = builder.isPopupMode() ? bodyFont : bodyFont.deriveFont((float)bodyFont.getSize() * 1.25f);
        if (font == null) {
            DiagramColorManager.$$$reportNull$$$0(36);
        }
        return font;
    }

    @NotNull
    public Font getNodeLabelFont(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(37);
        }
        Font font = StartupUiUtil.getLabelFont();
        if (font == null) {
            DiagramColorManager.$$$reportNull$$$0(38);
        }
        return font;
    }

    @NotNull
    public static Color getColorFromScheme(@NotNull DiagramBuilder builder, @NotNull ColorKey colorKey) {
        Color color;
        if (builder == null) {
            DiagramColorManager.$$$reportNull$$$0(39);
        }
        if (colorKey == null) {
            DiagramColorManager.$$$reportNull$$$0(40);
        }
        if ((color = builder.getColorScheme().getColor(colorKey)) == null) {
            color = colorKey.getDefaultColor();
        }
        Color color2 = Objects.requireNonNull(color);
        if (color2 == null) {
            DiagramColorManager.$$$reportNull$$$0(41);
        }
        return color2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 9, 10, 11, 16, 19, 33, 34, 36, 38, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 19: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramColorManager";
                break;
            }
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramColorManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeHeaderBackground";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeBackground";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeBorderColor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeForeground";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeColor";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarBackground";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeBodyFont";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeHeaderFont";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeLabelFont";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorFromScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeHeaderBackground";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 19: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodeBackground";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNodeSloppyBackgroundColor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodeBorderColor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodeBorderColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightedNodeBorderColor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForeground";
                break;
            }
            case 17: 
            case 18: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeColor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeColorKey";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeSelectionColor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBendColor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBendSelectionColor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionBoxBorderColor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionBoxBackgroundColor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getHotSpotColor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPortColor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSnappingColor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFineGridColor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCoarseGridColor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNodeHeaderFont";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNodeLabelFont";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getColorFromScheme";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 9, 10, 11, 16, 19, 33, 34, 36, 38, 41 -> new IllegalStateException(string);
        };
    }
}

