/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.psi.impl.Jinja2RelationExpressionImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.intellij.python.django.lang.template.inspection.DjangoTemplateLocalInspectionTool;
import com.jetbrains.django.ui.DjangoBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoComparisonSyntaxInspection
extends DjangoTemplateLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "DjangoRelationInspection";
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static boolean noWhitespace(@Nullable ASTNode node) {
        return node != null && !DjangoTemplateTokenTypes.WHITESPACES.contains(node.getElementType());
    }

    private static final class DjangoTagVisitor
    extends DjangoInspectionVisitorAdapter {
        private DjangoTagVisitor(@NotNull InspectionManager manager) {
            if (manager == null) {
                DjangoTagVisitor.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        public void visitRelationExpression(Jinja2RelationExpressionImpl relationExpression) {
            ASTNode relation = relationExpression.getNode().findChildByType(DjangoTemplateTokenTypes.DJANGO_RELATION_OPERATORS);
            if (relation != null) {
                boolean before = false;
                boolean after = false;
                if (DjangoComparisonSyntaxInspection.noWhitespace(relation.getTreePrev())) {
                    before = true;
                }
                if (DjangoComparisonSyntaxInspection.noWhitespace(relation.getTreeNext())) {
                    after = true;
                }
                String msg = null;
                if (before && after) {
                    msg = DjangoBundle.message((String)"django.inspection.message.whitespace.expected.before.and.after.comparison", (Object[])new Object[0]);
                } else if (before) {
                    msg = DjangoBundle.message((String)"django.inspection.message.whitespace.expected.before.comparison", (Object[])new Object[0]);
                } else if (after) {
                    msg = DjangoBundle.message((String)"django.inspection.message.whitespace.expected.after.comparison", (Object[])new Object[0]);
                }
                if (msg != null) {
                    this.reportProblem(relation.getPsi(), msg);
                }
            }
        }

        private void reportProblem(PsiElement elem, @InspectionMessage String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, new TextRange(0, elem.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR, false, new LocalQuickFix[0]);
            this.myProblems.add(d);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/python/django/lang/template/inspection/DjangoComparisonSyntaxInspection$DjangoTagVisitor", "<init>"));
        }
    }
}

