/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.CoroutinesKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigListener;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0014\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010\u001a\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u000bH\u0002J\f\u0010 \u001a\u00020\u000b*\u00020\fH\u0002J9\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2$\u0010#\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u0012\u0004\u0012\u0002H\"0$H\u0002\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rd\u0010\b\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f \r*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n0\n \r**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f \r*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n0\n\u0018\u00010\u000e0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/PerforceExternalConfigTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "trackedConfigFiles", "", "Lkotlin/Pair;", "", "Ljava/nio/file/WatchKey;", "kotlin.jvm.PlatformType", "", "Ljava/util/Set;", "watchService", "Ljava/nio/file/WatchService;", "trackJob", "Lkotlinx/coroutines/Job;", "startTracking", "", "stopTracking", "addConfigsToTrack", "configPaths", "createWatchService", "trackConfigs", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "notifyConfigChanged", "configPath", "toPathSafe", "Ljava/nio/file/Path;", "toPath", "processTracked", "R", "processor", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "intellij.vcs.perforce"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPerforceExternalConfigTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerforceExternalConfigTracker.kt\norg/jetbrains/idea/perforce/perforce/connections/PerforceExternalConfigTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,160:1\n1#2:161\n2632#3,3:162\n1557#3:165\n1628#3,3:166\n15#4:169\n*S KotlinDebug\n*F\n+ 1 PerforceExternalConfigTracker.kt\norg/jetbrains/idea/perforce/perforce/connections/PerforceExternalConfigTracker\n*L\n73#1:162,3\n105#1:165\n105#1:166,3\n144#1:169\n*E\n"})
public final class PerforceExternalConfigTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    private final Set<Pair<String, WatchKey>> trackedConfigFiles;
    @Nullable
    private WatchService watchService;
    @Nullable
    private Job trackJob;
    @NotNull
    private static final Logger LOG;

    public PerforceExternalConfigTracker(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.trackedConfigFiles = Collections.synchronizedSet(new LinkedHashSet());
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)this.cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PerforceExternalConfigTracker this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.stopTracking();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startTracking() {
        Set<Pair<String, WatchKey>> set = this.trackedConfigFiles;
        Intrinsics.checkNotNullExpressionValue(set, (String)"trackedConfigFiles");
        Set<Pair<String, WatchKey>> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            Job runningTrackJob = this.trackJob;
            if (runningTrackJob != null && runningTrackJob.isActive()) {
                return;
            }
            this.watchService = this.createWatchService();
            this.trackJob = BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ PerforceExternalConfigTracker this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = PerforceExternalConfigTracker.access$trackConfigs(this.this$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopTracking() {
        Set<Pair<String, WatchKey>> set = this.trackedConfigFiles;
        Intrinsics.checkNotNullExpressionValue(set, (String)"trackedConfigFiles");
        Set<Pair<String, WatchKey>> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            try {
                WatchService watchService = this.watchService;
                if (watchService != null) {
                    watchService.close();
                }
                Job job = this.trackJob;
                if (job == null) {
                    return;
                }
                Job trackJob = job;
                if (trackJob.isActive()) {
                    Job.DefaultImpls.cancel$default((Job)trackJob, null, (int)1, null);
                }
                this.watchService = null;
                this.trackJob = null;
            }
            catch (IOException e) {
                LOG.warn("Unable to stop tracking", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void addConfigsToTrack(@NotNull Set<String> configPaths) {
        Intrinsics.checkNotNullParameter(configPaths, (String)"configPaths");
        this.processTracked(arg_0 -> PerforceExternalConfigTracker.addConfigsToTrack$lambda$3(this, configPaths, arg_0));
    }

    private final WatchService createWatchService() {
        try {
            return FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            LOG.warn("Unable to create watch service", (Throwable)e);
            return null;
        }
    }

    private final Object trackConfigs(Continuation<? super Unit> $completion) {
        WatchKey watchKey = null;
        WatchService watchService = this.watchService;
        if (watchService == null) {
            return Unit.INSTANCE;
        }
        WatchService watchService2 = watchService;
        try {
            while (true) {
                if (watchService2.take() == null) {
                    return Unit.INSTANCE;
                }
                JobKt.ensureActive((CoroutineContext)$completion.getContext());
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    Object context;
                    String fileName;
                    boolean configFileChanged;
                    JobKt.ensureActive((CoroutineContext)$completion.getContext());
                    if (event.context() == null || !(configFileChanged = ((Boolean)this.processTracked(arg_0 -> PerforceExternalConfigTracker.trackConfigs$lambda$5(fileName = context.toString(), arg_0))).booleanValue())) continue;
                    String configDir = this.toPath(watchKey);
                    String configPath = configDir + File.separator + fileName;
                    this.notifyConfigChanged(this.project, configPath);
                }
                watchKey.reset();
                WatchService watchService3 = this.watchService;
                if (watchService3 != null) {
                    continue;
                }
                break;
            }
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    private final void notifyConfigChanged(Project project, String configPath) {
        ((P4ConfigListener)BackgroundTaskUtil.syncPublisher((Project)project, P4ConfigListener.TOPIC)).notifyConfigChanged(configPath);
    }

    private final Path toPathSafe(String $this$toPathSafe) {
        try {
            return Path.of($this$toPathSafe, new String[0]);
        }
        catch (InvalidPathException e) {
            LOG.warn("Unable to track invalid path " + $this$toPathSafe, (Throwable)e);
            return null;
        }
    }

    private final String toPath(WatchKey $this$toPath) {
        Watchable watchable = $this$toPath.watchable();
        boolean bl = false;
        Object object = watchable instanceof Path ? (Path)watchable : null;
        if (object == null || (object = object.toString()) == null) {
            object = watchable.toString();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R processTracked(Function1<? super Set<Pair<String, WatchKey>>, ? extends R> processor) {
        Object object;
        Set<Pair<String, WatchKey>> set = this.trackedConfigFiles;
        Intrinsics.checkNotNullExpressionValue(set, (String)"trackedConfigFiles");
        Set<Pair<String, WatchKey>> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            Set<Pair<String, WatchKey>> set3 = this.trackedConfigFiles;
            Intrinsics.checkNotNullExpressionValue(set3, (String)"trackedConfigFiles");
            object = processor.invoke(set3);
        }
        return (R)object;
    }

    private static final Unit addConfigsToTrack$lambda$3(PerforceExternalConfigTracker this$0, Set $configPaths, Set registeredConfigs) {
        Intrinsics.checkNotNullParameter((Object)registeredConfigs, (String)"registeredConfigs");
        WatchService watchService = this$0.watchService;
        if (watchService == null) {
            return Unit.INSTANCE;
        }
        WatchService watchService2 = watchService;
        for (String configPath : $configPaths) {
            Path configDir;
            boolean bl;
            String configName;
            block5: {
                Path configPath2;
                if (this$0.toPathSafe(configPath) == null || configPath2.getParent() == null) continue;
                configName = PathsKt.getName((Path)configPath2);
                Iterable $this$none$iv = registeredConfigs;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl2 = false;
                        String name = (String)pair.component1();
                        WatchKey directory = (WatchKey)pair.component2();
                        if (!(Intrinsics.areEqual((Object)name, (Object)configName) && Intrinsics.areEqual((Object)directory, (Object)configDir))) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
            WatchKey watchKey = configDir.register(watchService2, kindArray);
            registeredConfigs.add(TuplesKt.to((Object)configName, (Object)watchKey));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean trackConfigs$lambda$5(String $fileName, Set tracked) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tracked, (String)"tracked");
        Iterable $this$map$iv = tracked;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).contains($fileName);
    }

    public static final /* synthetic */ Object access$trackConfigs(PerforceExternalConfigTracker $this, Continuation $completion) {
        return $this.trackConfigs((Continuation<? super Unit>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerforceExternalConfigTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/PerforceExternalConfigTracker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

