/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vcs.changes.ui.HoverChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.ui.render.LabelPainter;
import git4idea.GitReference;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lgit4idea/stash/ui/GitStashBranchComponent;", "Ljavax/swing/JPanel;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "iconCache", "Lcom/intellij/vcs/log/ui/render/LabelIconCache;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/vcs/log/ui/render/LabelIconCache;)V", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "labelPainter", "Lcom/intellij/vcs/log/ui/render/LabelPainter;", "rightGap", "", "getRightGap", "()I", "customise", "", "branchName", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "row", "selected", "", "getLabelForeground", "Ljava/awt/Color;", "paintComponent", "g", "Ljava/awt/Graphics;", "getPreferredSize", "Ljava/awt/Dimension;", "StashRefGroup", "intellij.vcs.git"})
public final class GitStashBranchComponent
extends JPanel {
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final LabelPainter labelPainter;

    public GitStashBranchComponent(@NotNull ChangesTree tree, @NotNull LabelIconCache iconCache) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)iconCache, (String)"iconCache");
        this.tree = tree;
        this.labelPainter = new LabelPainter((JComponent)this.tree, iconCache);
        this.setOpaque(false);
        this.labelPainter.setOpaque(false);
    }

    @NotNull
    public final ChangesTree getTree() {
        return this.tree;
    }

    private final int getRightGap() {
        return UIUtil.getScrollBarWidth();
    }

    public final void customise(@NotNull String branchName, @NotNull VirtualFile root, int row, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.tree.getProject()).getRepositoryForRootQuick(root);
        Object object = repository;
        boolean isCurrentBranch = Intrinsics.areEqual((Object)(object != null && (object = object.getCurrentBranch()) != null ? ((GitReference)object).getName() : null), (Object)branchName);
        int nodeLocation = TreeUtil.getNodeRowX((JTree)((JTree)this.tree), (int)row) + this.tree.getInsets().left;
        int availableWidth = this.tree.getWidth() - this.getRightGap() - nodeLocation;
        Color foreground = this.getLabelForeground(selected);
        this.labelPainter.customizePainter(HoverChangesTree.Companion.getBackground((Tree)this.tree, row, selected), foreground, selected, availableWidth, CollectionsKt.listOf((Object)new StashRefGroup(branchName, isCurrentBranch)));
    }

    private final Color getLabelForeground(boolean selected) {
        if (selected) {
            Color color = UIUtil.getLabelForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelForeground(...)");
            return color;
        }
        if (ExperimentalUI.Companion.isNewUI()) {
            JBColor jBColor = JBColor.namedColor((String)"VersionControl.Log.Commit.Reference.foreground", (Color)((Color)CurrentBranchComponent.TEXT_COLOR));
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
            return (Color)jBColor;
        }
        return (Color)CurrentBranchComponent.TEXT_COLOR;
    }

    @Override
    protected void paintComponent(@Nullable Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics2D = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g2 = graphics2D;
        this.labelPainter.paint(g2, 0, 0, this.getHeight());
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.labelPainter.getSize();
        dimension.width += this.getRightGap();
        Intrinsics.checkNotNull((Object)dimension);
        return dimension;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/stash/ui/GitStashBranchComponent$StashRefGroup;", "Lcom/intellij/vcs/log/RefGroup;", "branchName", "", "Lcom/intellij/openapi/util/NlsSafe;", "isCurrent", "", "<init>", "(Ljava/lang/String;Z)V", "getName", "getRefs", "", "Lcom/intellij/vcs/log/VcsRef;", "isExpanded", "getColors", "", "Ljava/awt/Color;", "intellij.vcs.git"})
    private static final class StashRefGroup
    implements RefGroup {
        @NotNull
        private final String branchName;
        private final boolean isCurrent;

        public StashRefGroup(@NotNull String branchName, boolean isCurrent) {
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            this.branchName = branchName;
            this.isCurrent = isCurrent;
        }

        @NotNull
        public String getName() {
            return this.branchName;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            return new ArrayList();
        }

        public boolean isExpanded() {
            return false;
        }

        @NotNull
        public List<Color> getColors() {
            if (this.isCurrent) {
                return CollectionsKt.listOf((Object)GitRefManager.HEAD.getBackgroundColor());
            }
            return CollectionsKt.listOf((Object)GitRefManager.LOCAL_BRANCH.getBackgroundColor());
        }
    }
}

