/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.data;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.dto.GitLabMergeRequestDraftNoteRestDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabNoteDTO;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00152\u00020\u0001:\u0003\u0013\u0014\u0015B-\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "", "parentSha", "", "sha", "filePathBefore", "filePathAfter", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getParentSha", "()Ljava/lang/String;", "getSha", "getFilePathBefore", "getFilePathAfter", "equals", "", "other", "hashCode", "", "Text", "Image", "Companion", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Image;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Text;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabNotePosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabNotePosition.kt\norg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n15#2:121\n*S KotlinDebug\n*F\n+ 1 GitLabNotePosition.kt\norg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition\n*L\n58#1:121\n*E\n"})
public abstract class GitLabNotePosition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String parentSha;
    @NotNull
    private final String sha;
    @Nullable
    private final String filePathBefore;
    @Nullable
    private final String filePathAfter;
    @NotNull
    private static final Logger LOG;

    private GitLabNotePosition(String parentSha, String sha, String filePathBefore, String filePathAfter) {
        this.parentSha = parentSha;
        this.sha = sha;
        this.filePathBefore = filePathBefore;
        this.filePathAfter = filePathAfter;
    }

    @NotNull
    public final String getParentSha() {
        return this.parentSha;
    }

    @NotNull
    public final String getSha() {
        return this.sha;
    }

    @Nullable
    public final String getFilePathBefore() {
        return this.filePathBefore;
    }

    @Nullable
    public final String getFilePathAfter() {
        return this.filePathAfter;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.mergerequest.data.GitLabNotePosition");
        GitLabNotePosition cfr_ignored_0 = (GitLabNotePosition)other;
        if (!Intrinsics.areEqual((Object)this.parentSha, (Object)((GitLabNotePosition)other).parentSha)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sha, (Object)((GitLabNotePosition)other).sha)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filePathBefore, (Object)((GitLabNotePosition)other).filePathBefore)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.filePathAfter, (Object)((GitLabNotePosition)other).filePathAfter);
    }

    public int hashCode() {
        int result2 = this.parentSha.hashCode();
        result2 = 31 * result2 + this.sha.hashCode();
        String string = this.filePathBefore;
        result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
        String string2 = this.filePathAfter;
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        return result2;
    }

    public /* synthetic */ GitLabNotePosition(String parentSha, String sha, String filePathBefore, String filePathAfter, DefaultConstructorMarker $constructor_marker) {
        this(parentSha, sha, filePathBefore, filePathAfter);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitLabNotePosition.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "from", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "position", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabNoteDTO$Position;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabMergeRequestDraftNoteRestDTO$Position;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GitLabNotePosition from(@NotNull GitLabNoteDTO.Position position) {
            GitLabNotePosition gitLabNotePosition;
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            if (position.getDiffRefs().getBaseSha() == null) {
                LOG.debug("Missing merge base in note position: " + position);
                return null;
            }
            String parentSha = position.getDiffRefs().getBaseSha();
            String sha = position.getDiffRefs().getHeadSha();
            if (Intrinsics.areEqual((Object)position.getPositionType(), (Object)"text")) {
                Integer n = position.getOldLine();
                Integer n2 = position.getNewLine();
                gitLabNotePosition = new Text(parentSha, sha, position.getOldPath(), position.getNewPath(), n != null ? Integer.valueOf(n + -1) : null, n2 != null ? Integer.valueOf(n2 + -1) : null);
            } else {
                gitLabNotePosition = new Image(parentSha, sha, position.getOldPath(), position.getNewPath());
            }
            return gitLabNotePosition;
        }

        @Nullable
        public final GitLabNotePosition from(@NotNull GitLabMergeRequestDraftNoteRestDTO.Position position) {
            GitLabNotePosition gitLabNotePosition;
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            if (position.getBaseSha() == null) {
                LOG.debug("Missing merge base in note position: " + position);
                return null;
            }
            String parentSha = position.getBaseSha();
            String string = position.getHeadSha();
            if (string == null) {
                return null;
            }
            String sha = string;
            if (Intrinsics.areEqual((Object)position.getPositionType(), (Object)"text")) {
                Integer n = position.getOldLine();
                Integer n2 = position.getNewLine();
                gitLabNotePosition = new Text(parentSha, sha, position.getOldPath(), position.getNewPath(), n != null ? Integer.valueOf(n + -1) : null, n2 != null ? Integer.valueOf(n2 + -1) : null);
            } else {
                gitLabNotePosition = new Image(parentSha, sha, position.getOldPath(), position.getNewPath());
            }
            return gitLabNotePosition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Image;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "parentSha", "", "sha", "filePathBefore", "filePathAfter", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "equals", "", "other", "", "intellij.vcs.gitlab"})
    public static final class Image
    extends GitLabNotePosition {
        public Image(@NotNull String parentSha, @NotNull String sha, @Nullable String filePathBefore, @Nullable String filePathAfter) {
            Intrinsics.checkNotNullParameter((Object)parentSha, (String)"parentSha");
            Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
            super(parentSha, sha, filePathBefore, filePathAfter, null);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            return super.equals(other);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\bH\u0016R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0015\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Text;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "parentSha", "", "sha", "filePathBefore", "filePathAfter", "lineIndexLeft", "", "lineIndexRight", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getLineIndexLeft", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getLineIndexRight", "equals", "", "other", "", "hashCode", "intellij.vcs.gitlab"})
    public static final class Text
    extends GitLabNotePosition {
        @Nullable
        private final Integer lineIndexLeft;
        @Nullable
        private final Integer lineIndexRight;

        public Text(@NotNull String parentSha, @NotNull String sha, @Nullable String filePathBefore, @Nullable String filePathAfter, @Nullable Integer lineIndexLeft, @Nullable Integer lineIndexRight) {
            Intrinsics.checkNotNullParameter((Object)parentSha, (String)"parentSha");
            Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
            super(parentSha, sha, filePathBefore, filePathAfter, null);
            this.lineIndexLeft = lineIndexLeft;
            this.lineIndexRight = lineIndexRight;
        }

        @Nullable
        public final Integer getLineIndexLeft() {
            return this.lineIndexLeft;
        }

        @Nullable
        public final Integer getLineIndexRight() {
            return this.lineIndexRight;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Text)) {
                return false;
            }
            if (!super.equals(other)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lineIndexLeft, (Object)((Text)other).lineIndexLeft)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lineIndexRight, (Object)((Text)other).lineIndexRight);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            Integer n = this.lineIndexLeft;
            result2 = 31 * result2 + (n != null ? n : 0);
            Integer n2 = this.lineIndexRight;
            result2 = 31 * result2 + (n2 != null ? n2 : 0);
            return result2;
        }
    }
}

