/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.google.common.collect.Iterables;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyStringFormatParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySubstitutionChunkReference
extends PsiReferenceBase<PyStringLiteralExpression>
implements PsiReferenceEx {
    @NotNull
    private final PyStringFormatParser.SubstitutionChunk myChunk;
    private final boolean myIsPercent;
    private final int myPosition;

    public PySubstitutionChunkReference(@NotNull PyStringLiteralExpression element, @NotNull PyStringFormatParser.SubstitutionChunk chunk) {
        if (element == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(0);
        }
        if (chunk == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(1);
        }
        super((PsiElement)element, PySubstitutionChunkReference.getKeywordRange(element, chunk));
        this.myChunk = chunk;
        this.myIsPercent = chunk instanceof PyStringFormatParser.PercentSubstitutionChunk;
        this.myPosition = (Integer)ObjectUtils.chooseNotNull((Object)chunk.getPosition(), (Object)-1);
    }

    @Override
    @Nullable
    public HighlightSeverity getUnresolvedHighlightSeverity(@NotNull TypeEvalContext context) {
        if (context == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(2);
        }
        return HighlightSeverity.WARNING;
    }

    @Override
    @Nullable
    public String getUnresolvedDescription() {
        return null;
    }

    @NotNull
    private static TextRange getKeywordRange(@NotNull PyStringLiteralExpression element, @NotNull PyStringFormatParser.SubstitutionChunk chunk) {
        if (element == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(3);
        }
        if (chunk == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(4);
        }
        TextRange textRange = chunk.getTextRange();
        if (chunk.getMappingKey() != null) {
            int start = textRange.getStartOffset() + chunk.getTextRange().substring(element.getText()).indexOf(chunk.getMappingKey());
            TextRange textRange2 = TextRange.from((int)start, (int)chunk.getMappingKey().length());
            if (textRange2 == null) {
                PySubstitutionChunkReference.$$$reportNull$$$0(5);
            }
            return textRange2;
        }
        TextRange textRange3 = textRange;
        if (textRange3 == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(6);
        }
        return textRange3;
    }

    @Nullable
    public PsiElement resolve() {
        return this.myIsPercent ? this.resolvePercentString() : this.resolveFormatString();
    }

    @Nullable
    private PsiElement resolveFormatString() {
        PyArgumentList argumentList = PySubstitutionChunkReference.getArgumentList(this.getElement());
        if (argumentList == null || argumentList.getArguments().length == 0) {
            return null;
        }
        return this.myChunk.getMappingKey() != null ? (PsiElement)this.resolveKeywordFormat(argumentList).get() : this.resolvePositionalFormat(argumentList);
    }

    @Nullable
    private PsiElement resolvePositionalFormat(@NotNull PyArgumentList argumentList) {
        if (argumentList == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(7);
        }
        int n = 0;
        boolean notSureAboutStarArgs = false;
        PyStarArgument firstStarArg = null;
        for (PyExpression arg : argumentList.getArguments()) {
            PyStarArgument starArg = PyUtil.as(arg, PyStarArgument.class);
            if (starArg != null) {
                Ref<PyExpression> resolvedRef;
                if (starArg.isKeyword()) continue;
                if (firstStarArg == null) {
                    firstStarArg = starArg;
                }
                if ((resolvedRef = this.resolvePositionalStarExpression(starArg, n)) != null) {
                    PsiElement resolved = (PsiElement)resolvedRef.get();
                    if (resolved == null) continue;
                    return resolved;
                }
                notSureAboutStarArgs = true;
                continue;
            }
            if (arg instanceof PyKeywordArgument) continue;
            if (this.myPosition == n) {
                return arg;
            }
            ++n;
        }
        return notSureAboutStarArgs ? firstStarArg : null;
    }

    @NotNull
    private Ref<PyExpression> resolveKeywordFormat(@NotNull PyArgumentList argumentList) {
        Ref<PyExpression> valueExprRef;
        block8: {
            String indexElement;
            if (argumentList == null) {
                PySubstitutionChunkReference.$$$reportNull$$$0(8);
            }
            valueExprRef = this.getKeyValueFromArguments(argumentList);
            String string = indexElement = this.myChunk instanceof PyStringFormatParser.NewStyleSubstitutionChunk ? ((PyStringFormatParser.NewStyleSubstitutionChunk)this.myChunk).getMappingKeyElementIndex() : null;
            if (valueExprRef != null && !valueExprRef.isNull() && indexElement != null) {
                Ref<PyExpression> ref;
                PyExpression valueExpr = PyPsiUtils.flattenParens((PyExpression)valueExprRef.get());
                assert (valueExpr != null);
                try {
                    Integer index = Integer.valueOf(indexElement);
                    Ref<PyExpression> resolvedRef = this.resolveNumericIndex(valueExpr, index);
                    if (resolvedRef == null) break block8;
                    ref = resolvedRef;
                }
                catch (NumberFormatException e) {
                    Ref<PyExpression> resolvedRef = this.resolveStringIndex(valueExpr, indexElement);
                    if (resolvedRef == null) break block8;
                    Ref<PyExpression> ref2 = resolvedRef;
                    if (ref2 == null) {
                        PySubstitutionChunkReference.$$$reportNull$$$0(10);
                    }
                    return ref2;
                }
                if (ref == null) {
                    PySubstitutionChunkReference.$$$reportNull$$$0(9);
                }
                return ref;
            }
        }
        Ref<PyExpression> ref = valueExprRef == null ? Ref.create() : valueExprRef;
        if (ref == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(11);
        }
        return ref;
    }

    @Nullable
    private Ref<PyExpression> getKeyValueFromArguments(@NotNull PyArgumentList argumentList) {
        if (argumentList == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(12);
        }
        PyKeywordArgument valueFromKeywordArg = argumentList.getKeywordArgument(this.myChunk.getMappingKey());
        List<PyStarArgument> keywordStarArgs = PySubstitutionChunkReference.getStarArguments(argumentList, true);
        Ref<PyExpression> valueExprRef = null;
        if (valueFromKeywordArg != null) {
            valueExprRef = Ref.create((Object)valueFromKeywordArg.getValueExpression());
        } else if (!keywordStarArgs.isEmpty()) {
            for (PyStarArgument arg : keywordStarArgs) {
                Ref<PyExpression> resolvedRef = this.resolveKeywordStarExpression(arg);
                if (resolvedRef == null || valueExprRef != null && valueExprRef.get() != null) continue;
                valueExprRef = resolvedRef;
            }
            if (valueExprRef == null) {
                valueExprRef = Ref.create((Object)((PyExpression)Iterables.getFirst(keywordStarArgs, null)));
            }
        }
        return valueExprRef;
    }

    @Nullable
    private Ref<PyExpression> resolveStringIndex(@NotNull PyExpression valueExpr, @NotNull String indexElement) {
        if (valueExpr == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(13);
        }
        if (indexElement == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(14);
        }
        if (valueExpr instanceof PyCallExpression) {
            return this.resolveDictCall((PyCallExpression)valueExpr, indexElement, false);
        }
        if (valueExpr instanceof PyDictLiteralExpression) {
            Ref<PyExpression> resolvedRef = this.getElementFromDictLiteral((PyDictLiteralExpression)valueExpr, indexElement);
            if (resolvedRef != null) {
                return resolvedRef;
            }
        } else if (valueExpr instanceof PyReferenceExpression) {
            return Ref.create((Object)valueExpr);
        }
        return null;
    }

    @Nullable
    private Ref<PyExpression> resolveNumericIndex(@NotNull PyExpression valueExpr, @NotNull Integer index) {
        if (valueExpr == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(15);
        }
        if (index == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(16);
        }
        if (PsiTreeUtil.instanceOf((Object)valueExpr, (Class[])new Class[]{PyListLiteralExpression.class, PyTupleExpression.class, PyStringLiteralExpression.class})) {
            Ref<PyExpression> elementRef = PySubstitutionChunkReference.getElementByIndex(valueExpr, index);
            if (elementRef != null) {
                return elementRef;
            }
        } else {
            if (valueExpr instanceof PyDictLiteralExpression) {
                return this.getElementFromDictLiteral((PyDictLiteralExpression)valueExpr, index);
            }
            if (valueExpr instanceof PyReferenceExpression) {
                return Ref.create((Object)valueExpr);
            }
        }
        return null;
    }

    @Nullable
    private Ref<PyExpression> getElementFromDictLiteral(@NotNull PyDictLiteralExpression valueExpr, @NotNull Integer index) {
        PyKeyValueExpression[] elements;
        if (valueExpr == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(17);
        }
        if (index == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(18);
        }
        boolean allKeysForSure = true;
        for (PyKeyValueExpression element : elements = valueExpr.getElements()) {
            PyNumericLiteralExpression key = PyUtil.as(element.getKey(), PyNumericLiteralExpression.class);
            if (key != null && Long.valueOf(index.intValue()).equals(key.getLongValue())) {
                return Ref.create((Object)element.getValue());
            }
            if (element.getKey() instanceof PyLiteralExpression) continue;
            allKeysForSure = false;
        }
        return this.resolveDoubleStar(valueExpr, String.valueOf(index), true, allKeysForSure);
    }

    @Nullable
    public static Ref<PyExpression> getElementByIndex(@NotNull PyExpression listTupleExpr, int index) {
        PyExpression[] elements;
        if (listTupleExpr == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(19);
        }
        boolean noElementsForSure = true;
        int seenElementsNumber = 0;
        for (PyExpression element : elements = PySubstitutionChunkReference.getElementsFromListOrTuple(listTupleExpr)) {
            if (element instanceof PyStarExpression) {
                if (!LanguageLevel.forElement((PsiElement)element).isAtLeast(LanguageLevel.PYTHON35)) continue;
                PyExpression underStarExpr = PyPsiUtils.flattenParens(((PyStarExpression)element).getExpression());
                if (PsiTreeUtil.instanceOf((Object)underStarExpr, (Class[])new Class[]{PyListLiteralExpression.class, PyTupleExpression.class})) {
                    int subsequenceElementIndex = index - seenElementsNumber;
                    Object[] subSequenceElements = PySubstitutionChunkReference.getElementsFromListOrTuple(underStarExpr);
                    if (subsequenceElementIndex < subSequenceElements.length) {
                        return Ref.create((Object)subSequenceElements[subsequenceElementIndex]);
                    }
                    if (noElementsForSure) {
                        noElementsForSure = !ContainerUtil.exists((Object[])subSequenceElements, it -> it instanceof PyStarExpression);
                    }
                    seenElementsNumber += subSequenceElements.length;
                    continue;
                }
                noElementsForSure = false;
                break;
            }
            if (index == seenElementsNumber) {
                return Ref.create((Object)element);
            }
            ++seenElementsNumber;
        }
        return noElementsForSure ? Ref.create() : null;
    }

    public static PyExpression[] getElementsFromListOrTuple(@NotNull PyExpression expression) {
        if (expression == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(20);
        }
        if (expression instanceof PyListLiteralExpression) {
            PyListLiteralExpression list = (PyListLiteralExpression)expression;
            return list.getElements();
        }
        if (expression instanceof PyTupleExpression) {
            PyTupleExpression tuple = (PyTupleExpression)expression;
            return tuple.getElements();
        }
        if (expression instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression string = (PyStringLiteralExpression)expression;
            String value = string.getStringValue();
            Object[] result2 = new PyExpression[value.length()];
            Arrays.fill(result2, expression);
            return result2;
        }
        return PyExpression.EMPTY_ARRAY;
    }

    @NotNull
    private static List<PyStarArgument> getStarArguments(@NotNull PyArgumentList argumentList, boolean isKeyword) {
        if (argumentList == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(21);
        }
        List<PyStarArgument> list = Arrays.stream(argumentList.getArguments()).map(expression -> PyUtil.as(expression, PyStarArgument.class)).filter(argument -> argument != null && argument.isKeyword() == isKeyword).collect(Collectors.toList());
        if (list == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Nullable
    private PsiElement resolvePercentString() {
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyBinaryExpression.class);
        if (binaryExpression != null) {
            PyExpression rightExpression = binaryExpression.getRightExpression();
            if (rightExpression == null) {
                return null;
            }
            boolean isKeyWordSubstitution = this.myChunk.getMappingKey() != null;
            return isKeyWordSubstitution ? this.resolveKeywordPercent(rightExpression, this.myChunk.getMappingKey()) : this.resolvePositionalPercent(rightExpression);
        }
        return null;
    }

    @Nullable
    private PyExpression resolveKeywordPercent(@NotNull PyExpression expression, @NotNull String key) {
        Ref<PyExpression> elementRef;
        PyExpression containedExpr;
        if (expression == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(23);
        }
        if (key == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(24);
        }
        if (PsiTreeUtil.instanceOf((Object)(containedExpr = PyPsiUtils.flattenParens(expression)), (Class[])new Class[]{PyDictLiteralExpression.class})) {
            Ref<PyExpression> resolvedRef = this.getElementFromDictLiteral((PyDictLiteralExpression)containedExpr, key);
            return resolvedRef != null ? (PyExpression)resolvedRef.get() : containedExpr;
        }
        if (PsiTreeUtil.instanceOf((Object)containedExpr, (Class[])new Class[]{PyLiteralExpression.class, PySetLiteralExpression.class, PyListLiteralExpression.class, PyTupleExpression.class})) {
            return null;
        }
        if (containedExpr instanceof PyCallExpression && this.myChunk.getMappingKey() != null && (elementRef = this.resolveDictCall((PyCallExpression)containedExpr, this.myChunk.getMappingKey(), true)) != null) {
            return (PyExpression)elementRef.get();
        }
        return containedExpr;
    }

    @Nullable
    private PsiElement resolvePositionalPercent(@NotNull PyExpression expression) {
        PyExpression callee;
        if (expression == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(25);
        }
        assert (this.myPosition >= 0);
        PyExpression containedExpression = PyPsiUtils.flattenParens(expression);
        if (containedExpression instanceof PyTupleExpression) {
            PyExpression[] elements = ((PyTupleExpression)containedExpression).getElements();
            return this.myPosition < elements.length ? elements[this.myPosition] : null;
        }
        if (containedExpression instanceof PyBinaryExpression && ((PyBinaryExpression)containedExpression).isOperator("+")) {
            return this.resolveNotNestedBinaryExpression((PyBinaryExpression)containedExpression);
        }
        if (containedExpression instanceof PyCallExpression ? (callee = ((PyCallExpression)containedExpression).getCallee()) != null && "dict".equals(callee.getName()) && this.myPosition != 0 : this.myPosition != 0 && PsiTreeUtil.instanceOf((Object)containedExpression, (Class[])new Class[]{PyLiteralExpression.class, PySetLiteralExpression.class, PyListLiteralExpression.class, PyDictLiteralExpression.class})) {
            return null;
        }
        return containedExpression;
    }

    @Nullable
    private PsiElement resolveNotNestedBinaryExpression(@NotNull PyBinaryExpression containedExpression) {
        PyExpression leftTuple;
        if (containedExpression == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(26);
        }
        assert (this.myPosition >= 0);
        PyExpression left = containedExpression.getLeftExpression();
        PyExpression right = containedExpression.getRightExpression();
        if (left instanceof PyParenthesizedExpression && (leftTuple = PyPsiUtils.flattenParens(left)) instanceof PyTupleExpression) {
            PyExpression[] rightTupleElements;
            int rightLength;
            PyExpression[] leftTupleElements = ((PyTupleExpression)leftTuple).getElements();
            int leftTupleLength = leftTupleElements.length;
            if (leftTupleLength > this.myPosition) {
                return leftTupleElements[this.myPosition];
            }
            if (right instanceof PyTupleExpression && leftTupleLength + (rightLength = (rightTupleElements = ((PyTupleExpression)right).getElements()).length) > this.myPosition) {
                return rightTupleElements[this.myPosition - leftTupleLength];
            }
        }
        return containedExpression;
    }

    @Nullable
    private static PyArgumentList getArgumentList(PsiElement original) {
        PsiElement pyReferenceExpression = PsiTreeUtil.getParentOfType((PsiElement)original, PyReferenceExpression.class);
        return (PyArgumentList)PsiTreeUtil.getNextSiblingOfType((PsiElement)pyReferenceExpression, PyArgumentList.class);
    }

    @Nullable
    private Ref<PyExpression> resolveKeywordStarExpression(@NotNull PyStarArgument starArgument) {
        if (starArgument == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(27);
        }
        PyDictLiteralExpression dictExpr = (PyDictLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)starArgument, PyDictLiteralExpression.class);
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getChildOfType((PsiElement)starArgument, PyCallExpression.class);
        String key = this.myChunk.getMappingKey();
        assert (key != null);
        if (dictExpr != null) {
            return this.getElementFromDictLiteral(dictExpr, key);
        }
        if (callExpression != null) {
            return this.resolveDictCall(callExpression, key, false);
        }
        return null;
    }

    @Nullable
    private Ref<PyExpression> resolvePositionalStarExpression(@NotNull PyStarArgument starArgument, int argumentPosition) {
        if (starArgument == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(28);
        }
        assert (this.myPosition >= 0);
        PyExpression expr = PyPsiUtils.flattenParens((PyExpression)PsiTreeUtil.getChildOfAnyType((PsiElement)starArgument, (Class[])new Class[]{PyListLiteralExpression.class, PyParenthesizedExpression.class, PyStringLiteralExpression.class}));
        if (expr == null) {
            return Ref.create((Object)starArgument);
        }
        int position = this.myPosition - argumentPosition;
        return PySubstitutionChunkReference.getElementByIndex(expr, position);
    }

    @Nullable
    private Ref<PyExpression> getElementFromDictLiteral(@NotNull PyDictLiteralExpression expression, @NotNull String mappingKey) {
        PyKeyValueExpression[] keyValueExpressions;
        if (expression == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(29);
        }
        if (mappingKey == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(30);
        }
        boolean allKeysForSure = true;
        for (PyKeyValueExpression keyValueExpression : keyValueExpressions = expression.getElements()) {
            PyExpression keyExpression = keyValueExpression.getKey();
            if (keyExpression instanceof PyStringLiteralExpression) {
                PyStringLiteralExpression key = (PyStringLiteralExpression)keyExpression;
                if (!key.getStringValue().equals(mappingKey)) continue;
                return Ref.create((Object)keyValueExpression.getValue());
            }
            if (keyExpression instanceof PyLiteralExpression) continue;
            allKeysForSure = false;
        }
        return this.resolveDoubleStar(expression, mappingKey, false, allKeysForSure);
    }

    @Nullable
    private Ref<PyExpression> resolveDoubleStar(@NotNull PyDictLiteralExpression expression, @NotNull String mappingKey, boolean isNumeric, boolean allKeysForSure) {
        if (expression == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(31);
        }
        if (mappingKey == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(32);
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)expression);
        PyDoubleStarExpression[] starExpressions = (PyDoubleStarExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)expression, PyDoubleStarExpression.class);
        if (languageLevel.isAtLeast(LanguageLevel.PYTHON35) && starExpressions != null) {
            for (PyDoubleStarExpression expr : starExpressions) {
                Ref<PyExpression> element;
                PyExpression underStarExpr = PyPsiUtils.flattenParens(expr.getExpression());
                if (underStarExpr == null) continue;
                if (underStarExpr instanceof PyDictLiteralExpression) {
                    element = isNumeric ? this.getElementFromDictLiteral((PyDictLiteralExpression)underStarExpr, Integer.valueOf(mappingKey)) : this.getElementFromDictLiteral((PyDictLiteralExpression)underStarExpr, mappingKey);
                    boolean bl = allKeysForSure = element != null;
                    if (element == null || element.isNull()) continue;
                    return element;
                }
                if (underStarExpr instanceof PyCallExpression) {
                    element = this.resolveDictCall((PyCallExpression)underStarExpr, mappingKey, true);
                    boolean bl = allKeysForSure = element != null;
                    if (element == null || element.isNull()) continue;
                    return element;
                }
                allKeysForSure = false;
            }
        }
        return allKeysForSure ? Ref.create() : null;
    }

    @Nullable
    private Ref<PyExpression> resolveDictCall(@NotNull PyCallExpression expression, @NotNull String key, boolean goDeep) {
        String name2;
        if (expression == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(33);
        }
        if (key == null) {
            PySubstitutionChunkReference.$$$reportNull$$$0(34);
        }
        PyExpression callee = expression.getCallee();
        boolean allKeysForSure = true;
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)expression);
        if (callee != null && "dict".equals(name2 = callee.getName())) {
            PyArgumentList argumentList = expression.getArgumentList();
            for (PyExpression arg : expression.getArguments()) {
                if (languageLevel.isAtLeast(LanguageLevel.PYTHON35) && goDeep && arg instanceof PyStarExpression) {
                    PyExpression expr = ((PyStarExpression)arg).getExpression();
                    if (expr instanceof PyDictLiteralExpression) {
                        element = this.getElementFromDictLiteral((PyDictLiteralExpression)expr, key);
                        if (element != null) {
                            return element;
                        }
                    } else if (expr instanceof PyCallExpression) {
                        element = this.resolveDictCall((PyCallExpression)expr, key, false);
                        if (element != null) {
                            return element;
                        }
                    } else {
                        allKeysForSure = false;
                    }
                }
                if (arg instanceof PyKeywordArgument) continue;
                allKeysForSure = false;
            }
            if (argumentList != null) {
                PyKeywordArgument argument = argumentList.getKeywordArgument(key);
                if (argument != null) {
                    return Ref.create((Object)argument);
                }
                return allKeysForSure ? Ref.create() : null;
            }
        }
        return Ref.create((Object)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9, 10, 11, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/PySubstitutionChunkReference";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExpr";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexElement";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listTupleExpr";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containedExpression";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starArgument";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/PySubstitutionChunkReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordRange";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveKeywordFormat";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStarArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedHighlightSeverity";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordRange";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolvePositionalFormat";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveKeywordFormat";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getKeyValueFromArguments";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveStringIndex";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveNumericIndex";
                break;
            }
            case 17: 
            case 18: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromDictLiteral";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getElementByIndex";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getElementsFromListOrTuple";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getStarArguments";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveKeywordPercent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolvePositionalPercent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveNotNestedBinaryExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveKeywordStarExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolvePositionalStarExpression";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveDoubleStar";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveDictCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9, 10, 11, 22 -> new IllegalStateException(string);
        };
    }
}

