/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.facet;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.library.PythonLibraryType;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class FacetLibraryConfigurator {
    private FacetLibraryConfigurator() {
    }

    public static void attachPythonLibrary(final Module module, final @Nullable ModifiableRootModel existingModel, final String libraryName, final List<String> paths) {
        final ModifiableModelsProvider modelsProvider = ModifiableModelsProvider.getInstance();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Library lib;
                ModifiableRootModel model2 = existingModel != null ? existingModel : modelsProvider.getModuleModifiableModel(module);
                LibraryOrderEntry orderEntry = OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)model2, (String)libraryName);
                if (orderEntry != null && (lib = orderEntry.getLibrary()) != null) {
                    if (lib instanceof LibraryEx && ((LibraryEx)lib).getKind() == null) {
                        model2.removeOrderEntry((OrderEntry)orderEntry);
                        LibraryTablesRegistrar.getInstance().getLibraryTable(model2.getProject()).removeLibrary(lib);
                        this.createNewLibrary(model2);
                        return;
                    }
                    FacetLibraryConfigurator.fillLibrary(lib, paths);
                    if (existingModel == null) {
                        modelsProvider.commitModuleModifiableModel(model2);
                    }
                    return;
                }
                this.createNewLibrary(model2);
            }

            private void createNewLibrary(ModifiableRootModel model2) {
                LibraryTable.ModifiableModel projectLibrariesModel = modelsProvider.getLibraryTableModifiableModel(model2.getProject());
                Library lib = projectLibrariesModel.createLibrary(libraryName, PythonLibraryType.getInstance().getKind());
                FacetLibraryConfigurator.fillLibrary(lib, paths);
                projectLibrariesModel.commit();
                model2.addLibraryEntry(lib);
                if (existingModel == null) {
                    modelsProvider.commitModuleModifiableModel(model2);
                }
            }
        });
    }

    private static void fillLibrary(Library lib, List<String> paths) {
        Library.ModifiableModel modifiableModel = lib.getModifiableModel();
        for (String root : lib.getUrls(OrderRootType.CLASSES)) {
            modifiableModel.removeRoot(root, OrderRootType.CLASSES);
        }
        if (paths != null) {
            for (String dir : paths) {
                VirtualFile pathEntry = LocalFileSystem.getInstance().findFileByPath(dir);
                if (pathEntry != null && !pathEntry.isDirectory() && pathEntry.getFileType() instanceof ArchiveFileType) {
                    pathEntry = JarFileSystem.getInstance().getJarRootForLocalFile(pathEntry);
                }
                if (pathEntry != null) {
                    modifiableModel.addRoot(pathEntry, OrderRootType.CLASSES);
                    continue;
                }
                modifiableModel.addRoot("file://" + dir, OrderRootType.CLASSES);
            }
        }
        modifiableModel.commit();
    }

    public static void detachPythonLibrary(Module module, String libraryName) {
        ModifiableModelsProvider modelsProvider = ModifiableModelsProvider.getInstance();
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel model2 = modelsProvider.getModuleModifiableModel(module);
            LibraryOrderEntry entry = OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)model2, (String)libraryName);
            if (entry == null) {
                modelsProvider.disposeModuleModifiableModel(model2);
            } else {
                model2.removeOrderEntry((OrderEntry)entry);
                modelsProvider.commitModuleModifiableModel(model2);
            }
        });
    }
}

