/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.packaging.PyPIPackageCache;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyAbstractPackageCache {
    private static final Logger LOG = Logger.getInstance(PyPIPackageCache.class);
    private static final Gson ourGson = new GsonBuilder().registerTypeAdapter(new TypeToken<TreeMap<String, PackageInfo>>(){}.getType(), type2 -> new TreeMap(String.CASE_INSENSITIVE_ORDER)).registerTypeAdapter(PackageInfo.class, (Object)new JsonDeserializer<PackageInfo>(){
        final Gson defaultGson = new Gson();

        public PackageInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && json.getAsJsonObject().isEmpty()) {
                return PackageInfo.EMPTY;
            }
            return (PackageInfo)this.defaultGson.fromJson(json, typeOfT);
        }
    }).create();
    @SerializedName(value="packages")
    protected final TreeMap<String, PackageInfo> myPackages = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    protected PyAbstractPackageCache() {
    }

    @NotNull
    protected static <T extends PyAbstractPackageCache> T load(@NotNull Class<T> classToken, @NotNull T fallbackValue, @NotNull Path cacheFilePath) {
        if (classToken == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(0);
        }
        if (fallbackValue == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(1);
        }
        if (cacheFilePath == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(2);
        }
        Object cache = fallbackValue;
        try (BufferedReader reader = Files.newBufferedReader(cacheFilePath, StandardCharsets.UTF_8);){
            cache = (PyAbstractPackageCache)ourGson.fromJson((Reader)reader, classToken);
            LOG.info("Loaded " + ((PyAbstractPackageCache)cache).getPackageNames().size() + " packages from " + String.valueOf(cacheFilePath));
        }
        catch (NoSuchFileException exception) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info("Package cache " + String.valueOf(cacheFilePath) + " was not found");
            }
        }
        catch (JsonSyntaxException exception) {
            LOG.warn("Corrupted package cache " + String.valueOf(cacheFilePath), (Throwable)exception);
            try {
                Files.deleteIfExists(cacheFilePath);
            }
            catch (IOException iOException) {}
        }
        catch (JsonIOException | IOException exception) {
            LOG.warn("Cannot load package cache " + String.valueOf(cacheFilePath), exception);
        }
        T t = cache;
        if (t == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(3);
        }
        return t;
    }

    protected static void store(@NotNull PyAbstractPackageCache newValue, @NotNull String cacheFileName) {
        if (newValue == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(4);
        }
        if (cacheFileName == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(5);
        }
        try {
            Path cacheFilePath = PyAbstractPackageCache.getDefaultCachePath(cacheFileName);
            Files.createDirectories(cacheFilePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(cacheFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                ourGson.toJson((Object)newValue, (Appendable)writer);
            }
        }
        catch (JsonIOException | IOException exception) {
            LOG.error("Cannot save " + cacheFileName + " package cache to the filesystem", exception);
        }
    }

    @NotNull
    protected static Path getDefaultCachePath(@NotNull String cacheFileName) {
        if (cacheFileName == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(6);
        }
        Path path2 = Paths.get(PathManager.getSystemPath(), "python_packages", cacheFileName);
        if (path2 == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(7);
        }
        return path2;
    }

    @NotNull
    public Set<String> getPackageNames() {
        Set<String> set = Collections.unmodifiableSet(this.myPackages.keySet());
        if (set == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(8);
        }
        return set;
    }

    public boolean containsPackage(@NotNull String name2) {
        if (name2 == null) {
            PyAbstractPackageCache.$$$reportNull$$$0(9);
        }
        return this.myPackages.containsKey(name2);
    }

    public String toString() {
        return String.format("%s(size=%d): %s...", this.getClass().getSimpleName(), this.myPackages.size(), ((StreamEx)StreamEx.ofKeys(this.myPackages).limit(5L)).joining((CharSequence)", "));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToken";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFilePath";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyAbstractPackageCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyAbstractPackageCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCachePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCachePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsPackage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8 -> new IllegalStateException(string);
        };
    }

    protected static class PackageInfo {
        public static final PackageInfo EMPTY = new PackageInfo();
        @SerializedName(value="v")
        private List<String> myVersions;

        public PackageInfo(@NotNull List<String> versions2) {
            if (versions2 == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            this.myVersions = versions2;
        }

        public PackageInfo() {
        }

        @Nullable
        public List<String> getVersions() {
            return this.myVersions != null ? Collections.unmodifiableList(this.myVersions) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/jetbrains/python/packaging/PyAbstractPackageCache$PackageInfo", "<init>"));
        }
    }
}

