/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.endpoints;

import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.ExternalEndpointsFilter;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerCoreIcons;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.api.SwEndpoint;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.model.specification.SwaggerFileHelper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/swagger/endpoints/AsyncapiEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "Lcom/intellij/swagger/core/model/api/SwEndpoint;", "<init>", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getEndpoints", "", "group", "getEndpointGroups", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "endpoint", "isValidEndpoint", "", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "intellij.swagger.endpoints"})
public final class AsyncapiEndpointsProvider
implements EndpointsProvider<SwSpecificationFile, SwEndpoint> {
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("AsyncAPI", SwaggerBundle.message("asyncapi.specification", new Object[0]), SwSpecificationType.ASYNCAPI_2_6.INSTANCE.getIcon());

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.API_DEFINITION_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public Iterable<SwEndpoint> getEndpoints(@NotNull SwSpecificationFile group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        return group2.getEndpoints();
    }

    @NotNull
    public Iterable<SwSpecificationFile> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (filter instanceof ExternalEndpointsFilter) {
            return CollectionsKt.emptyList();
        }
        SearchScopeEndpointsFilter searchScopeEndpointsFilter = filter instanceof SearchScopeEndpointsFilter ? (SearchScopeEndpointsFilter)filter : null;
        if (searchScopeEndpointsFilter == null || (searchScopeEndpointsFilter = searchScopeEndpointsFilter.getContentSearchScope()) == null) {
            return CollectionsKt.emptyList();
        }
        SearchScopeEndpointsFilter searchScope = searchScopeEndpointsFilter;
        return SequencesKt.asIterable(SwaggerFileHelper.INSTANCE.collectSpecificationFiles(project, (GlobalSearchScope)searchScope, (Function1<? super SwSpecificationFile, Boolean>)((Function1)AsyncapiEndpointsProvider::getEndpointGroups$lambda$0)));
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SwaggerUtilsKt.getYamlJsonModificationTracker(project);
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull SwSpecificationFile group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String string = endpoint.getUrl();
        Object object = group2.getSourcePsi();
        if (object == null || (object = object.getName()) == null) {
            object = SwaggerBundle.message("unknown.specification", new Object[0]);
        }
        return (ItemPresentation)new HttpMethodPresentation(string, endpoint.getHttpMethod().getValue(), (String)object, SwaggerCoreIcons.AsyncAPI, null, 16, null);
    }

    public boolean isValidEndpoint(@NotNull SwSpecificationFile group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return SwaggerUtilsKt.isElementValid(endpoint);
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull SwSpecificationFile group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getSourcePsi();
    }

    private static final boolean getEndpointGroups$lambda$0(SwSpecificationFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSpecificationType() instanceof SwSpecificationType.AsyncAPIFamily;
    }
}

