/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoFileUtil {
    private DjangoFileUtil() {
    }

    public static Set<String> readFileLines(Class<?> baseClass, String relativeName) throws IOException {
        Package aPackage = baseClass.getPackage();
        String fileName = "/" + aPackage.getName().replace(".", "/") + "/" + relativeName;
        InputStream in = baseClass.getResourceAsStream(fileName);
        return DjangoFileUtil.readFileLines(in);
    }

    public static Set<String> readFileLines(String fileName) throws IOException {
        try (FileInputStream in = new FileInputStream(fileName);){
            Set<String> set = DjangoFileUtil.readFileLines(in);
            return set;
        }
    }

    public static Set<String> readFileLines(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            Set<String> set = reader.lines().collect(Collectors.toSet());
            return set;
        }
    }

    public static void add(@NotNull String path2, @NotNull String content) throws IOException {
        File file;
        if (path2 == null) {
            DjangoFileUtil.$$$reportNull$$$0(0);
        }
        if (content == null) {
            DjangoFileUtil.$$$reportNull$$$0(1);
        }
        if ((file = DjangoFileUtil.getFile(path2)) == null) {
            return;
        }
        DjangoFileUtil.writeContent(file, FileUtil.loadFile((File)file) + "\n" + content);
    }

    @Nullable
    private static File getFile(@NotNull String path2) {
        File file;
        if (path2 == null) {
            DjangoFileUtil.$$$reportNull$$$0(2);
        }
        if (!(file = new File(path2)).exists()) {
            return null;
        }
        return file;
    }

    public static void replace(String path2, String start, String end, String replacement, boolean skipStart) throws IOException {
        File file = DjangoFileUtil.getFile(path2);
        Object content = FileUtil.loadFile((File)file);
        int pos = ((String)content).indexOf(start);
        if (pos != -1) {
            int endPos;
            if (skipStart) {
                pos += start.length();
            }
            if ((endPos = ((String)content).indexOf(end, pos)) != -1) {
                content = ((String)content).substring(0, pos) + replacement + ((String)content).substring(endPos);
                DjangoFileUtil.writeContent(file, (String)content);
            }
        }
    }

    private static void writeContent(File file, String content) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/util/DjangoFileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

