/*
 * Decompiled with CFR 0.152.
 */
package org.joox;

import jakarta.xml.bind.DataBindingException;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import org.joox.Content;
import org.joox.Context;
import org.joox.Each;
import org.joox.Elements;
import org.joox.FastFilter;
import org.joox.Filter;
import org.joox.Impl;
import org.joox.Mapper;
import org.joox.Match;
import org.joox.Util;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JOOX {
    private static final Set<String> TRUE_VALUES = new HashSet<String>();
    private static final Set<String> FALSE_VALUES = new HashSet<String>();
    private static final FastFilter NONE;
    private static final FastFilter ALL;
    private static final FastFilter EVEN;
    private static final FastFilter ODD;
    private static final FastFilter LEAF;

    public static Match $() {
        return JOOX.$(JOOX.builder().newDocument());
    }

    public static Match $(Object object) {
        Document document = JOOX.builder().newDocument();
        if (object != null) {
            DOMResult result2 = new DOMResult(document);
            JAXB.marshal(object, result2);
        }
        return JOOX.$(document);
    }

    public static Match $(String name) {
        Document document = JOOX.builder().newDocument();
        DocumentFragment fragment = Util.createContent(document, name, true);
        if (fragment != null) {
            NodeList children = fragment.getChildNodes();
            int i = 0;
            block3: while (i < children.getLength()) {
                Node node = children.item(i);
                switch (node.getNodeType()) {
                    case 3: 
                    case 4: {
                        ++i;
                        continue block3;
                    }
                }
                document.appendChild(node);
            }
        } else {
            document.appendChild(document.createElement(name));
        }
        return JOOX.$(document);
    }

    public static Match $(String name, String content2) {
        return JOOX.$(name).append(content2);
    }

    public static Match $(String name, Element ... content2) {
        return JOOX.$(name).append(content2);
    }

    public static Match $(String name, Match ... content2) {
        return JOOX.$(name).append(content2);
    }

    public static Match $(Document document) {
        if (document == null) {
            return JOOX.$();
        }
        if (document.getDocumentElement() == null) {
            return new Impl(document, null);
        }
        return JOOX.$(document.getDocumentElement());
    }

    public static Match $(Element element) {
        if (element == null) {
            return JOOX.$();
        }
        return new Impl(element.getOwnerDocument(), null).addElements(element);
    }

    public static Match $(Node node) {
        if (node instanceof Document) {
            return JOOX.$((Document)node);
        }
        if (node instanceof Element) {
            return JOOX.$((Element)node);
        }
        return JOOX.$();
    }

    public static Match $(NodeList list2) {
        if (list2 != null && list2.getLength() > 0) {
            return new Impl(list2.item(0).getOwnerDocument(), null).addNodeList(list2);
        }
        return JOOX.$();
    }

    public static Match $(Context context2) {
        if (context2 == null) {
            return JOOX.$();
        }
        return JOOX.$(context2.element());
    }

    public static Match $(Match match) {
        if (match == null) {
            return JOOX.$();
        }
        return match;
    }

    public static Match $(URL url) throws SAXException, IOException {
        return JOOX.$(url.openStream());
    }

    public static Match $(URI uri) throws SAXException, IOException {
        return JOOX.$(new File(uri));
    }

    public static Match $(File file) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(file));
    }

    public static Match $(Path path) throws SAXException, IOException {
        return JOOX.$(path.toFile());
    }

    public static Match $(InputStream stream2) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(stream2));
    }

    public static Match $(Reader reader) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(new InputSource(reader)));
    }

    public static Match $(InputSource source) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(source));
    }

    public static FastFilter none() {
        return NONE;
    }

    public static FastFilter all() {
        return ALL;
    }

    public static FastFilter even() {
        return EVEN;
    }

    public static FastFilter odd() {
        return ODD;
    }

    public static FastFilter leaf() {
        return LEAF;
    }

    public static FastFilter at(int ... indexes) {
        return context2 -> {
            for (int i : indexes) {
                if (i != context2.elementIndex()) continue;
                return true;
            }
            return false;
        };
    }

    public static Filter selector(String selector) {
        return JOOX.tag(selector);
    }

    public static FastFilter tag(String tagName) {
        return JOOX.tag(tagName, true);
    }

    public static FastFilter tag(String tagName, boolean ignoreNamespace) {
        if (tagName == null || tagName.equals("")) {
            return JOOX.none();
        }
        if ("*".equals(tagName)) {
            return JOOX.all();
        }
        return context2 -> {
            String localName = context2.element().getTagName();
            if (ignoreNamespace) {
                localName = Util.stripNamespace(localName);
            }
            return tagName.equals(localName);
        };
    }

    public static FastFilter namespacePrefix(String namespacePrefix) {
        if ("*".equals(namespacePrefix)) {
            return JOOX.all();
        }
        return context2 -> {
            String match = JOOX.$(context2).namespacePrefix();
            if (match == null || "".equals(match)) {
                return namespacePrefix == null || "".equals(namespacePrefix);
            }
            return match.equals(namespacePrefix);
        };
    }

    public static FastFilter namespaceURI(String namespaceURI) {
        if ("*".equals(namespaceURI)) {
            return JOOX.all();
        }
        return context2 -> {
            String match = JOOX.$(context2).namespaceURI();
            if (match == null || "".equals(match)) {
                return namespaceURI == null || "".equals(namespaceURI);
            }
            return match.equals(namespaceURI);
        };
    }

    public static FastFilter matchText(String regex) {
        if (regex == null || regex.equals("")) {
            return JOOX.none();
        }
        Pattern pattern = Pattern.compile(regex);
        return context2 -> pattern.matcher(JOOX.$(context2).text()).matches();
    }

    public static FastFilter matchAttr(String name, String valueRegex) {
        if (name == null || name.equals("") || valueRegex == null || valueRegex.equals("")) {
            return JOOX.none();
        }
        Pattern pattern = Pattern.compile(valueRegex);
        return context2 -> {
            String value2 = JOOX.$(context2).attr(name);
            if (value2 == null) {
                return false;
            }
            return pattern.matcher(value2).matches();
        };
    }

    public static FastFilter matchTag(String regex) {
        return JOOX.matchTag(regex, true);
    }

    public static FastFilter matchTag(String regex, boolean ignoreNamespace) {
        if (regex == null || regex.equals("")) {
            return JOOX.none();
        }
        Pattern pattern = Pattern.compile(regex);
        return context2 -> {
            String localName = context2.element().getTagName();
            if (ignoreNamespace) {
                localName = Util.stripNamespace(localName);
            }
            return pattern.matcher(localName).matches();
        };
    }

    public static FastFilter attr(String name) {
        if (name == null || name.equals("")) {
            return context2 -> context2.element().getAttributes().getLength() == 0;
        }
        return context2 -> JOOX.$(context2).attr(name) != null;
    }

    public static FastFilter attr(String name, String value2) {
        if (name == null || name.equals("")) {
            return JOOX.attr(name);
        }
        return context2 -> Objects.equals(JOOX.$(context2).attr(name), value2);
    }

    public static FastFilter attr(String name, String ... values) {
        List<String> list2 = Arrays.asList(values);
        if (name == null || name.equals("")) {
            return JOOX.attr(name);
        }
        return context2 -> list2.contains(JOOX.$(context2).attr(name));
    }

    public static Filter and(Filter ... filters) {
        return context2 -> {
            for (Filter filter2 : filters) {
                if (filter2.filter(context2)) continue;
                return false;
            }
            return true;
        };
    }

    public static Filter or(Filter ... filters) {
        return context2 -> {
            for (Filter filter2 : filters) {
                if (!filter2.filter(context2)) continue;
                return true;
            }
            return false;
        };
    }

    public static Filter not(Filter filter2) {
        return context2 -> !filter2.filter(context2);
    }

    public static FastFilter ids(String ... ids) {
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(ids));
        return context2 -> set2.contains(JOOX.$(context2).attr("id"));
    }

    public static Content content(String value2) {
        return context2 -> value2;
    }

    public static Content content(final Object value2) {
        if (value2 == null) {
            return JOOX.content("");
        }
        return new Content(){
            private String marshalled;

            @Override
            public String content(Context context2) {
                if (this.marshalled == null) {
                    try {
                        JAXBContext jaxb = JAXBContext.newInstance(value2.getClass());
                        Marshaller marshaller = jaxb.createMarshaller();
                        marshaller.setProperty("jaxb.fragment", true);
                        StringWriter writer = new StringWriter();
                        marshaller.marshal(value2, writer);
                        this.marshalled = writer.toString();
                    }
                    catch (JAXBException e) {
                        throw new DataBindingException(e);
                    }
                }
                return this.marshalled;
            }
        };
    }

    public static Mapper<String> ids() {
        return JOOX.attrs("id");
    }

    public static Mapper<String> attrs(String attributeName) {
        return context2 -> JOOX.$(context2).attr(attributeName);
    }

    public static Mapper<String> paths() {
        return context2 -> Util.path(context2.element());
    }

    public static Each chain(Each ... each) {
        return JOOX.chain(Arrays.asList(each));
    }

    public static Each chain(Iterable<? extends Each> each) {
        return context2 -> {
            if (each != null) {
                for (Each e : each) {
                    e.each(context2);
                }
            }
        };
    }

    public static Iterable<Element> iterable(NodeList elements) {
        return new Elements(elements);
    }

    public static Iterator<Element> iterator(NodeList elements) {
        return new Elements(elements).iterator();
    }

    public static List<Element> list(NodeList elements) {
        ArrayList<Element> list2 = new ArrayList<Element>();
        for (Element element : JOOX.iterable(elements)) {
            list2.add(element);
        }
        return list2;
    }

    public static DocumentBuilder builder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                factory.setXIncludeAware(false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            factory.setExpandEntityReferences(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T convert(String value2, Class<T> type) {
        if (value2 == null && type.isPrimitive()) {
            value2 = "0";
        }
        if (value2 == null) {
            return null;
        }
        if (type.isArray()) {
            Class<?> component2 = type.getComponentType();
            List<String> split = Util.split(value2);
            return (T)JOOX.convert(split, component2).toArray((Object[])Array.newInstance(component2, split.size()));
        }
        if (type == String.class) {
            return (T)value2;
        }
        if (type == Object.class) {
            return (T)value2;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            try {
                return (T)Byte.valueOf(new BigDecimal(value2).byteValue());
            }
            catch (Exception e) {
                return (T)(type == Byte.class ? null : Byte.valueOf((byte)0));
            }
        }
        if (type == Short.class || type == Short.TYPE) {
            try {
                return (T)Short.valueOf(new BigDecimal(value2).shortValue());
            }
            catch (Exception e) {
                return (T)(type == Short.class ? null : Short.valueOf((short)0));
            }
        }
        if (type == Integer.class || type == Integer.TYPE) {
            try {
                return (T)Integer.valueOf(new BigDecimal(value2).intValue());
            }
            catch (Exception e) {
                return (T)(type == Integer.class ? null : Integer.valueOf(0));
            }
        }
        if (type == Long.class || type == Long.TYPE) {
            try {
                return (T)Long.valueOf(new BigDecimal(value2).longValue());
            }
            catch (Exception e) {
                return (T)(type == Long.class ? null : Long.valueOf(0L));
            }
        }
        if (type == Float.class || type == Float.TYPE) {
            try {
                return (T)Float.valueOf(value2);
            }
            catch (Exception e) {
                return (T)(type == Float.class ? null : Float.valueOf(0.0f));
            }
        }
        if (type == Double.class || type == Double.TYPE) {
            try {
                return (T)Double.valueOf(value2);
            }
            catch (Exception e) {
                return (T)(type == Double.class ? null : Double.valueOf(0.0));
            }
        }
        if (type == BigDecimal.class) {
            try {
                return (T)new BigDecimal(value2);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == BigInteger.class) {
            try {
                return (T)new BigDecimal(value2).toBigInteger();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            String s = value2.toLowerCase();
            if (TRUE_VALUES.contains(s)) {
                return (T)Boolean.TRUE;
            }
            if (FALSE_VALUES.contains(s)) {
                return (T)Boolean.FALSE;
            }
            return (T)(type == Boolean.class ? null : Boolean.valueOf(false));
        }
        if (type == java.util.Date.class) {
            try {
                return (T)Util.parseDate(value2);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Calendar.class) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(Util.parseDate(value2));
                return (T)cal;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == GregorianCalendar.class) {
            try {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(Util.parseDate(value2));
                return (T)cal;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Timestamp.class) {
            try {
                return (T)new Timestamp(Util.parseDate(value2).getTime());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Date.class) {
            try {
                return (T)new Date(Util.parseDate(value2).getTime());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Time.class) {
            try {
                return (T)new Time(Util.parseDate(value2).getTime());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static <T> List<T> convert(List<String> values, Class<T> type) {
        ArrayList<T> result2 = new ArrayList<T>();
        for (String value2 : values) {
            result2.add(JOOX.convert(value2, type));
        }
        return result2;
    }

    static {
        TRUE_VALUES.add("1");
        TRUE_VALUES.add("y");
        TRUE_VALUES.add("yes");
        TRUE_VALUES.add("true");
        TRUE_VALUES.add("on");
        TRUE_VALUES.add("enabled");
        FALSE_VALUES.add("0");
        FALSE_VALUES.add("n");
        FALSE_VALUES.add("no");
        FALSE_VALUES.add("false");
        FALSE_VALUES.add("off");
        FALSE_VALUES.add("disabled");
        NONE = context2 -> false;
        ALL = context2 -> true;
        EVEN = context2 -> context2.elementIndex() % 2 == 0;
        ODD = context2 -> context2.elementIndex() % 2 != 0;
        LEAF = context2 -> {
            NodeList children = context2.element().getChildNodes();
            int i = 0;
            Node item;
            while ((item = children.item(i)) != null) {
                if (item.getNodeType() == 1) {
                    return false;
                }
                ++i;
            }
            return true;
        };
    }
}

