/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.shortcut;

import com.intellij.codeInsight.hints.presentation.InputHandler;
import com.intellij.codeInsight.inline.completion.shortcut.HintState;
import com.intellij.codeInsight.inline.completion.shortcut.InlineCompletionChooseShortcutElementKt;
import com.intellij.codeInsight.inline.completion.shortcut.InlineCompletionShortcutHintRendererBase;
import com.intellij.codeInsight.inline.completion.shortcut.ShortcutRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0014\u0010\u0013\u001a\u00020\b2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000eJ\n\u0010\u0017\u001a\u00020\u0010*\u00020\u0010J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0019H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/codeInsight/inline/completion/shortcut/RendererBase;", "Lcom/intellij/codeInsight/inline/completion/shortcut/InlineCompletionShortcutHintRendererBase;", "Lcom/intellij/codeInsight/hints/presentation/InputHandler;", "text", "", "hintState", "Lcom/intellij/codeInsight/inline/completion/shortcut/HintState;", "lineNumber", "", "<init>", "(Ljava/lang/String;Lcom/intellij/codeInsight/inline/completion/shortcut/HintState;I)V", "getHintState", "()Lcom/intellij/codeInsight/inline/completion/shortcut/HintState;", "myInlay", "Lcom/intellij/openapi/editor/Inlay;", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "editor", "Lcom/intellij/openapi/editor/Editor;", "calcWidthInPixels", "inlay", "initialize", "", "updateIfHovering", "isEnabledAdditional", "", "mousePressed", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "mouseReleased", "mouseMoved", "mouseExited", "updateState", "isHovered", "updateCursor", "guessPopupPoint", "Lcom/intellij/ui/awt/RelativePoint;", "intellij.platform.inline.completion"})
@SourceDebugExtension(value={"SMAP\nInlineCompletionChooseShortcutElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCompletionChooseShortcutElement.kt\ncom/intellij/codeInsight/inline/completion/shortcut/RendererBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n295#2,2:274\n1#3:276\n*S KotlinDebug\n*F\n+ 1 InlineCompletionChooseShortcutElement.kt\ncom/intellij/codeInsight/inline/completion/shortcut/RendererBase\n*L\n200#1:274,2\n*E\n"})
abstract class RendererBase
extends InlineCompletionShortcutHintRendererBase
implements InputHandler {
    @NotNull
    private final HintState hintState;
    private final int lineNumber;
    private Inlay<?> myInlay;

    public RendererBase(@Nullable String text, @NotNull HintState hintState, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)hintState, (String)"hintState");
        super(text);
        this.hintState = hintState;
        this.lineNumber = lineNumber;
    }

    @NotNull
    public final HintState getHintState() {
        return this.hintState;
    }

    @Nullable
    protected TextAttributes getTextAttributes(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextAttributes textAttributes = super.getTextAttributes(editor);
        return textAttributes != null ? this.updateIfHovering(textAttributes) : null;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return !InlineCompletionChooseShortcutElementKt.access$choiceShouldRender() ? 1 : super.calcWidthInPixels(inlay);
    }

    public final void initialize(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        if (!(this.myInlay == null)) {
            throw new IllegalStateException("Check failed.");
        }
        this.myInlay = inlay;
        DisposerUtilKt.whenDisposed((Disposable)((Disposable)inlay), () -> RendererBase.initialize$lambda$0(this));
        this.hintState.whenUpdated((Function0<Unit>)((Function0)() -> RendererBase.initialize$lambda$1(inlay)));
    }

    @NotNull
    public final TextAttributes updateIfHovering(@NotNull TextAttributes $this$updateIfHovering) {
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)$this$updateIfHovering, (String)"<this>");
        if (this.hintState.isHovered()) {
            TextAttributes textAttributes2;
            TextAttributes textAttributes3 = $this$updateIfHovering.clone();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes3, (String)"clone(...)");
            TextAttributes $this$updateIfHovering_u24lambda_u242 = textAttributes2 = textAttributes3;
            boolean bl = false;
            $this$updateIfHovering_u24lambda_u242.setForegroundColor(JBUI.CurrentTheme.Link.Foreground.ENABLED);
            textAttributes = textAttributes2;
        } else {
            textAttributes = $this$updateIfHovering;
        }
        return textAttributes;
    }

    @Override
    protected boolean isEnabledAdditional(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return InlineCompletionChooseShortcutElementKt.access$choiceShouldRender();
    }

    public void mousePressed(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (InlineCompletionChooseShortcutElementKt.access$choiceShouldRender()) {
            event.consume();
        }
    }

    public void mouseReleased(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (InlineCompletionChooseShortcutElementKt.access$choiceShouldRender()) {
            Inlay<?> inlay = this.myInlay;
            if (inlay == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
                inlay = null;
            }
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            InlineCompletionChooseShortcutElementKt.access$showChooseShortcutPopup(editor, this.guessPopupPoint(event), this.lineNumber);
        }
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (InlineCompletionChooseShortcutElementKt.access$choiceShouldRender()) {
            this.updateState(true);
        }
    }

    public void mouseExited() {
        if (InlineCompletionChooseShortcutElementKt.access$choiceShouldRender()) {
            this.updateState(false);
        }
    }

    private final void updateState(boolean isHovered) {
        this.hintState.setHovered(isHovered);
        Inlay<?> inlay = this.myInlay;
        if (inlay == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
            inlay = null;
        }
        if (inlay.isValid()) {
            this.updateCursor(isHovered);
            this.hintState.update();
        }
    }

    private final void updateCursor(boolean isHovered) {
        Cursor cursor;
        boolean bl = isHovered;
        if (bl) {
            cursor = Cursor.getPredefinedCursor(12);
        } else if (!bl) {
            cursor = Cursor.getPredefinedCursor(0);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Cursor cursor2 = cursor;
        Inlay<?> inlay = this.myInlay;
        if (inlay == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
            inlay = null;
        }
        JComponent jComponent = inlay.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent contentComponent = jComponent;
        if (!Intrinsics.areEqual((Object)contentComponent.getCursor(), (Object)cursor2)) {
            UIUtil.setCursor((Component)contentComponent, (Cursor)cursor2);
        }
    }

    private final RelativePoint guessPopupPoint(MouseEvent event) {
        Point point;
        Inlay shortcutInlay;
        Object object;
        Object v2;
        Inlay it;
        block5: {
            Inlay<?> inlay = this.myInlay;
            if (inlay == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
                inlay = null;
            }
            List list = inlay.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(this.lineNumber);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAfterLineEndElementsForLogicalLine(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Inlay)element$iv;
                boolean bl = false;
                if (!(it.getRenderer() instanceof ShortcutRenderer)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        if ((object = (shortcutInlay = (Inlay)v2)) != null && (object = object.getBounds()) != null) {
            it = object;
            boolean bl = false;
            point = new Point(it.x, it.y);
        } else {
            point = event.getPoint();
        }
        Point point2 = point;
        Component component = event.getComponent();
        int n = point2.x;
        int n2 = point2.y;
        Inlay<?> inlay = this.myInlay;
        if (inlay == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
            inlay = null;
        }
        return new RelativePoint(component, new Point(n, n2 + inlay.getEditor().getLineHeight()));
    }

    private static final Unit initialize$lambda$0(RendererBase this$0) {
        this$0.updateState(false);
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(Inlay $inlay) {
        $inlay.update();
        return Unit.INSTANCE;
    }
}

