/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistoryPartnerAdapter;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.MergeSourceDetailsAction;
import org.jetbrains.idea.svn.history.SvnDiffFromHistoryHandler;
import org.jetbrains.idea.svn.history.SvnEditCommitMessageFromFileHistoryAction;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.history.SvnHistorySession;
import org.jetbrains.idea.svn.history.SvnMergeSourceDetails;
import org.jetbrains.idea.svn.history.SvnMergeSourceTracker;
import org.jetbrains.idea.svn.history.SvnPathThroughHistoryCorrection;
import org.jetbrains.idea.svn.info.Info;

public class SvnHistoryProvider
implements VcsHistoryProvider,
VcsCacheableHistorySessionFactory<Boolean, SvnHistorySession> {
    private final SvnVcs myVcs;
    private static final Object MERGE_SOURCE_DETAILS_TAG = new Object();

    public SvnHistoryProvider(SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return new SvnDiffFromHistoryHandler(this.myVcs);
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        if (file == null) {
            SvnHistoryProvider.$$$reportNull$$$0(0);
        }
        return true;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        JPanel addComp;
        Consumer listener2;
        ColumnInfo[] columns;
        if (((SvnHistorySession)session).isHaveMergeSources()) {
            MergeSourceColumnInfo mergeSourceColumn = new MergeSourceColumnInfo((SvnHistorySession)session);
            columns = new ColumnInfo[]{new CopyFromColumnInfo(), mergeSourceColumn};
            final JTextArea field = new JTextArea(){
                final StatusText statusText = new StatusText(this){

                    protected boolean isStatusVisible() {
                        return this.getDocument().getLength() == 0;
                    }
                };
                {
                    this.statusText.setText(SvnBundle.message("status.text.merge.sources", new Object[0]));
                    this.setEditable(false);
                    this.setWrapStyleWord(true);
                    this.setLineWrap(true);
                }

                @Override
                public Color getBackground() {
                    return UIUtil.getEditorPaneBackground();
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    this.statusText.paint((Component)this, g);
                }
            };
            listener2 = vcsFileRevision -> {
                field.setText(mergeSourceColumn.getText((VcsFileRevision)vcsFileRevision));
                field.setCaretPosition(0);
                field.repaint();
            };
            MergeSourceDetailsAction sourceAction = new MergeSourceDetailsAction();
            sourceAction.registerSelf(forShortcutRegistration);
            JPanel fieldPanel = new ToolbarDecorator(){

                @NotNull
                protected JComponent getComponent() {
                    JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)field, (boolean)true);
                    if (jScrollPane == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return jScrollPane;
                }

                protected void updateButtons() {
                }

                protected void installDnDSupport() {
                }

                protected boolean isModelEditable() {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnHistoryProvider$2", "getComponent"));
                }
            }.initPosition().addExtraAction((AnAction)sourceAction).createPanel();
            fieldPanel.setBorder((Border)JBUI.Borders.empty());
            addComp = fieldPanel;
        } else {
            columns = new ColumnInfo[]{new CopyFromColumnInfo()};
            addComp = null;
            listener2 = null;
        }
        return new VcsDependentHistoryComponents(columns, listener2, addComp);
    }

    public FilePath getUsedFilePath(SvnHistorySession session) {
        return session.getCommittedPath();
    }

    public Boolean getAdditionallyCachedData(SvnHistorySession session) {
        return session.isHaveMergeSources();
    }

    public SvnHistorySession createFromCachedData(Boolean aBoolean, @NotNull List<? extends VcsFileRevision> revisions, @NotNull FilePath filePath, VcsRevisionNumber currentRevision) {
        if (revisions == null) {
            SvnHistoryProvider.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            SvnHistoryProvider.$$$reportNull$$$0(2);
        }
        return new SvnHistorySession(this.myVcs, revisions, filePath, aBoolean, currentRevision, false, !filePath.isNonLocal());
    }

    @Nullable
    public VcsHistorySession createSessionFor(FilePath filePath) throws VcsException {
        VcsAppendableHistoryPartnerAdapter adapter = new VcsAppendableHistoryPartnerAdapter();
        this.reportAppendableHistory(filePath, (VcsAppendableHistorySessionPartner)adapter);
        adapter.check();
        return adapter.getSession();
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myVcs.getProject());
        int limit = configuration.LIMIT_HISTORY ? configuration.MAXIMUM_HISTORY_ROWS + 1 : 0;
        this.reportAppendableHistory(path, partner, null, null, limit, null, false);
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner, @Nullable Revision from, @Nullable Revision to, int limit, Revision peg, boolean forceBackwards) throws VcsException {
        FilePath committedPath = path;
        Change change = ChangeListManager.getInstance((Project)this.myVcs.getProject()).getChange(path);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && afterRevision.getFile().equals(path)) {
                committedPath = beforeRevision.getFile();
            }
            if (peg == null && change.getBeforeRevision() != null && change.getBeforeRevision().getRevisionNumber() instanceof SvnRevisionNumber) {
                peg = ((SvnRevisionNumber)change.getBeforeRevision().getRevisionNumber()).getRevision();
            }
        }
        boolean showMergeSources = this.myVcs.getSvnConfiguration().isShowMergeSourcesInAnnotate();
        LogLoader logLoader = path.isNonLocal() ? new RepositoryLoader(this.myVcs, committedPath, from, to, limit, peg, forceBackwards, showMergeSources) : new LocalLoader(this.myVcs, committedPath, from, to, limit, peg, showMergeSources);
        logLoader.preliminary();
        logLoader.check();
        if (showMergeSources) {
            logLoader.initSupports15();
        }
        SvnHistorySession historySession = new SvnHistorySession(this.myVcs, Collections.emptyList(), committedPath, showMergeSources && logLoader.mySupport15, null, false, !path.isNonLocal());
        Ref sessionReported = new Ref();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(SvnBundle.message("progress.text2.collecting.history", path.getName()));
        }
        Consumer consumer = vcsFileRevision -> {
            if (!Boolean.TRUE.equals(sessionReported.get())) {
                partner.reportCreatedEmptySession((VcsAbstractHistorySession)historySession);
                sessionReported.set((Object)true);
            }
            partner.acceptRevision(vcsFileRevision);
        };
        logLoader.setConsumer((Consumer<VcsFileRevision>)consumer);
        logLoader.load();
        logLoader.check();
    }

    public String getHelpId() {
        return null;
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[]{ShowAllAffectedGenericAction.getInstance(), ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction"), new MergeSourceDetailsAction(), new SvnEditCommitMessageFromFileHistoryAction()};
    }

    public boolean isDateOmittable() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/history/SvnHistoryProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowHistoryFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromCachedData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MergeSourceColumnInfo
    extends ColumnInfo<VcsFileRevision, RevisionMergeSourceInfo> {
        private final MergeSourceRenderer myRenderer;

        private MergeSourceColumnInfo(SvnHistorySession session) {
            super(SvnBundle.message("column.name.merge.sources", new Object[0]));
            this.myRenderer = new MergeSourceRenderer(session);
        }

        public TableCellRenderer getRenderer(VcsFileRevision vcsFileRevision) {
            return this.myRenderer;
        }

        public RevisionMergeSourceInfo valueOf(VcsFileRevision vcsFileRevision) {
            return vcsFileRevision != null ? new RevisionMergeSourceInfo(vcsFileRevision) : null;
        }

        public String getText(VcsFileRevision vcsFileRevision) {
            return this.myRenderer.getText(vcsFileRevision);
        }

        public int getAdditionalWidth() {
            return 20;
        }

        public String getPreferredStringValue() {
            return "1234567, 1234567, 1234567";
        }
    }

    private static class CopyFromColumnInfo
    extends ColumnInfo<VcsFileRevision, String> {
        private final Icon myIcon = PlatformIcons.COPY_ICON;
        private final ColoredTableCellRenderer myRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof String && !((String)value).isEmpty()) {
                    this.setIcon(myIcon);
                    this.setToolTipText(SvnBundle.message("copy.column.tooltip", value));
                } else {
                    this.setToolTipText("");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/idea/svn/history/SvnHistoryProvider$CopyFromColumnInfo$1", "customizeCellRenderer"));
            }
        };

        CopyFromColumnInfo() {
            super(SvnBundle.message("copy.column.title", new Object[0]));
        }

        public String valueOf(VcsFileRevision o) {
            return o instanceof SvnFileRevision ? ((SvnFileRevision)o).getCopyFromPath() : "";
        }

        public TableCellRenderer getRenderer(VcsFileRevision vcsFileRevision) {
            return this.myRenderer;
        }

        public String getMaxStringValue() {
            return SvnBundle.message("copy.column.title", new Object[0]);
        }

        public int getAdditionalWidth() {
            return 6;
        }
    }

    private static final class RepositoryLoader
    extends LogLoader {
        private final boolean myForceBackwards;

        private RepositoryLoader(SvnVcs vcs, FilePath file, Revision from, Revision to, int limit, Revision peg, boolean forceBackwards, boolean showMergeSources) {
            super(vcs, file, from, to, limit, peg, showMergeSources);
            this.myForceBackwards = forceBackwards;
        }

        @Override
        protected void preliminary() throws SvnBindException {
            this.myUrl = SvnUtil.createUrl(this.myFile.getPath(), false);
        }

        @Override
        protected void load() {
            if (this.myPI != null) {
                this.myPI.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", this.myUrl.toDecodedString()));
            }
            try {
                if (this.myForceBackwards && !this.existsNow(this.myUrl)) {
                    this.loadBackwards(this.myUrl);
                    return;
                }
                Revision operationalFrom = this.myFrom == null ? Revision.HEAD : this.myFrom;
                Url rootURL = SvnUtil.getRepositoryRoot(this.myVcs, this.myUrl);
                if (rootURL == null) {
                    throw new VcsException(SvnBundle.message("error.can.not.find.repository.root.for.url", this.myUrl.toDecodedString()));
                }
                String relativeUrl = SvnUtil.getRelativeUrl(rootURL, this.myUrl);
                Target target = Target.on(this.myUrl, this.myPeg == null ? this.myFrom : this.myPeg);
                RepositoryLogEntryHandler handler = new RepositoryLogEntryHandler(this.myVcs, this.myUrl, Revision.UNDEFINED, relativeUrl, (ThrowableConsumer<VcsFileRevision, SvnBindException>)((ThrowableConsumer)arg_0 -> ((Consumer)this.myConsumer).consume(arg_0)), rootURL);
                this.myVcs.getFactory(target).createHistoryClient().doLog(target, operationalFrom, this.myTo == null ? Revision.of(1L) : this.myTo, false, true, this.myShowMergeSources && this.mySupport15, this.myLimit, null, handler);
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }

        private void loadBackwards(Url svnurl) throws VcsException {
            Info info = this.myVcs.getInfo(svnurl, this.myPeg, this.myPeg);
            if (info == null || info.getRepositoryRootUrl() == null) {
                throw new VcsException(SvnBundle.message("error.can.not.find.repository.root.for.url.in.revision", svnurl, this.myPeg));
            }
            Url rootURL = info.getRepositoryRootUrl();
            String relativeUrl = SvnUtil.getRelativeUrl(rootURL, this.myUrl);
            RepositoryLogEntryHandler repositoryLogEntryHandler = new RepositoryLogEntryHandler(this.myVcs, this.myUrl, Revision.UNDEFINED, relativeUrl, (ThrowableConsumer<VcsFileRevision, SvnBindException>)((ThrowableConsumer)revision -> this.myConsumer.consume(revision)), rootURL);
            repositoryLogEntryHandler.setThrowCancelOnMeetPathCreation(true);
            Target target = Target.on(rootURL, this.myFrom);
            this.myVcs.getFactory(target).createHistoryClient().doLog(target, this.myFrom, this.myTo == null ? Revision.of(1L) : this.myTo, false, true, this.myShowMergeSources && this.mySupport15, 1L, null, repositoryLogEntryHandler);
        }

        private boolean existsNow(Url svnurl) {
            Info info;
            try {
                info = this.myVcs.getInfo(svnurl, Revision.HEAD, Revision.HEAD);
            }
            catch (SvnBindException e) {
                return false;
            }
            return info != null && info.getUrl() != null && info.getRevision().isValid();
        }
    }

    private static final class LocalLoader
    extends LogLoader {
        private Info myInfo;

        private LocalLoader(SvnVcs vcs, FilePath file, Revision from, Revision to, int limit, Revision peg, boolean showMergeSources) {
            super(vcs, file, from, to, limit, peg, showMergeSources);
        }

        @Override
        protected void preliminary() {
            this.myInfo = this.myVcs.getInfo(this.myFile.getIOFile());
            if (this.myInfo == null || this.myInfo.getRepositoryRootUrl() == null) {
                this.myException = new VcsException(SvnBundle.message("error.file.is.not.under.version.control", this.myFile.getPath()));
                return;
            }
            if (this.myInfo.getUrl() == null) {
                this.myException = new VcsException(SvnBundle.message("error.file.is.not.under.subversion", this.myFile.getPath()));
                return;
            }
            this.myUrl = this.myInfo.getUrl();
        }

        @Override
        protected void load() {
            Url repoRootURL = this.myInfo.getRepositoryRootUrl();
            String relativeUrl = SvnUtil.getRelativeUrl(repoRootURL, this.myUrl);
            if (this.myPI != null) {
                this.myPI.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", this.myUrl.toDecodedString()));
            }
            Revision pegRevision = this.myInfo.getRevision();
            Target target = Target.on(this.myFile.getIOFile(), this.myPeg);
            try {
                this.myVcs.getFactory(target).createHistoryClient().doLog(target, this.myFrom == null ? Revision.HEAD : this.myFrom, this.myTo == null ? Revision.of(1L) : this.myTo, false, true, this.myShowMergeSources && this.mySupport15, this.myLimit, null, new MyLogEntryHandler(this.myVcs, this.myUrl, pegRevision, relativeUrl, (ThrowableConsumer<VcsFileRevision, SvnBindException>)((ThrowableConsumer)arg_0 -> ((Consumer)this.myConsumer).consume(arg_0)), repoRootURL));
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }
    }

    private static abstract class LogLoader {
        protected final boolean myShowMergeSources;
        protected Url myUrl;
        protected boolean mySupport15;
        protected final SvnVcs myVcs;
        protected final FilePath myFile;
        protected final Revision myFrom;
        protected final Revision myTo;
        protected final int myLimit;
        protected final Revision myPeg;
        protected Consumer<VcsFileRevision> myConsumer;
        protected final ProgressIndicator myPI;
        protected VcsException myException;

        protected LogLoader(SvnVcs vcs, FilePath file, Revision from, Revision to, int limit, Revision peg, boolean showMergeSources) {
            this.myVcs = vcs;
            this.myFile = file;
            this.myFrom = from;
            this.myTo = to;
            this.myLimit = limit;
            this.myPeg = peg;
            this.myPI = ProgressManager.getInstance().getProgressIndicator();
            this.myShowMergeSources = showMergeSources;
        }

        public void setConsumer(Consumer<VcsFileRevision> consumer) {
            this.myConsumer = consumer;
        }

        protected void initSupports15() {
            assert (this.myUrl != null);
            this.mySupport15 = SvnUtil.checkRepositoryVersion15(this.myVcs, this.myUrl);
        }

        public void check() throws VcsException {
            if (this.myException != null) {
                throw this.myException;
            }
        }

        protected abstract void preliminary() throws SvnBindException;

        protected abstract void load();
    }

    private final class MergeSourceRenderer
    extends ColoredTableCellRenderer {
        private MergeSourceDetailsLinkListener myListener;
        private final VirtualFile myFile;

        private MergeSourceRenderer(SvnHistorySession session) {
            this.myFile = session.getCommittedPath().getVirtualFile();
        }

        public String getText(VcsFileRevision value) {
            return RevisionMergeSourceInfo.toString(value);
        }

        protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (table == null) {
                MergeSourceRenderer.$$$reportNull$$$0(0);
            }
            if (this.myListener == null) {
                this.myListener = new MergeSourceDetailsLinkListener(MERGE_SOURCE_DETAILS_TAG, this.myFile);
                this.myListener.installOn(table);
            }
            this.appendMergeSourceText(table, row, column, value instanceof RevisionMergeSourceInfo ? ((RevisionMergeSourceInfo)value).toString() : null);
        }

        private void appendMergeSourceText(JTable table, int row, int column, @Nls @Nullable String text) {
            if (StringUtil.isEmpty((String)text)) {
                this.append("", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                this.append(this.cutString(text, table.getCellRect(row, column, false).getWidth()), SimpleTextAttributes.REGULAR_ATTRIBUTES, MERGE_SOURCE_DETAILS_TAG);
            }
        }

        @Nls
        @NotNull
        private String cutString(@Nls @NotNull String text, double maxWidth) {
            if (text == null) {
                MergeSourceRenderer.$$$reportNull$$$0(1);
            }
            FontMetrics m = this.getFontMetrics(this.getFont());
            Graphics g = this.getGraphics();
            String suffix = "\u2026";
            if (m.getStringBounds(text, g).getWidth() < maxWidth) {
                String string = text;
                if (string == null) {
                    MergeSourceRenderer.$$$reportNull$$$0(2);
                }
                return string;
            }
            double suffixWidth = m.getStringBounds(suffix, g).getWidth();
            if (suffixWidth >= maxWidth) {
                String string = suffix;
                if (string == null) {
                    MergeSourceRenderer.$$$reportNull$$$0(3);
                }
                return string;
            }
            for (int i = 1; i < text.length(); ++i) {
                if (!(m.getStringBounds(text, 0, i, g).getWidth() + suffixWidth >= maxWidth)) continue;
                String string = text.substring(0, i - 1) + suffix;
                if (string == null) {
                    MergeSourceRenderer.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = text;
            if (string == null) {
                MergeSourceRenderer.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/history/SvnHistoryProvider$MergeSourceRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/history/SvnHistoryProvider$MergeSourceRenderer";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cutString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "cutString";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private final class MergeSourceDetailsLinkListener
    extends TableLinkMouseListener {
        private final VirtualFile myFile;
        private final Object myTag;

        private MergeSourceDetailsLinkListener(Object tag, VirtualFile file) {
            this.myTag = tag;
            this.myFile = file;
        }

        public boolean onClick(@NotNull MouseEvent e, int clickCount) {
            SvnFileRevision revision;
            Object tag;
            if (e == null) {
                MergeSourceDetailsLinkListener.$$$reportNull$$$0(0);
            }
            if (e.getButton() == 1 && !e.isPopupTrigger() && (tag = this.getTagAt(e)) == this.myTag && (revision = MergeSourceDetailsLinkListener.getSelectedRevision(e)) != null) {
                SvnMergeSourceDetails.showMe(SvnHistoryProvider.this.myVcs.getProject(), revision, this.myFile);
                return true;
            }
            return false;
        }

        @Nullable
        private static SvnFileRevision getSelectedRevision(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(e.getPoint());
            int column = table.columnAtPoint(e.getPoint());
            Object value = table.getModel().getValueAt(row, column);
            if (value instanceof RevisionMergeSourceInfo) {
                return ((RevisionMergeSourceInfo)value).getRevision();
            }
            return null;
        }

        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Object tag = this.getTagAt(e);
            if (tag == this.myTag) {
                table.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                table.setCursor(Cursor.getDefaultCursor());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/history/SvnHistoryProvider$MergeSourceDetailsLinkListener", "onClick"));
        }
    }

    private static final class RevisionMergeSourceInfo {
        @NotNull
        private final VcsFileRevision revision;

        private RevisionMergeSourceInfo(@NotNull VcsFileRevision revision) {
            if (revision == null) {
                RevisionMergeSourceInfo.$$$reportNull$$$0(0);
            }
            this.revision = revision;
        }

        @NotNull
        public SvnFileRevision getRevision() {
            SvnFileRevision svnFileRevision = (SvnFileRevision)this.revision;
            if (svnFileRevision == null) {
                RevisionMergeSourceInfo.$$$reportNull$$$0(1);
            }
            return svnFileRevision;
        }

        @Nls
        @NotNull
        public String toString() {
            return RevisionMergeSourceInfo.toString(this.revision);
        }

        @Nls
        @NotNull
        private static String toString(@Nullable VcsFileRevision revision) {
            if (!(revision instanceof SvnFileRevision)) {
                return "";
            }
            String string = StringUtil.join(((SvnFileRevision)revision).getMergeSources(), it -> RevisionMergeSourceInfo.getRevisionNumberWithMergeMark(it), (String)", ");
            if (string == null) {
                RevisionMergeSourceInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls
        @NotNull
        private static String getRevisionNumberWithMergeMark(@NotNull SvnFileRevision revision) {
            if (revision == null) {
                RevisionMergeSourceInfo.$$$reportNull$$$0(3);
            }
            String revisionNumber = revision.getRevisionNumber().asString();
            String mergeSuffix = !revision.getMergeSources().isEmpty() ? "*" : "";
            String string = revisionNumber + mergeSuffix;
            if (string == null) {
                RevisionMergeSourceInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/history/SvnHistoryProvider$RevisionMergeSourceInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/history/SvnHistoryProvider$RevisionMergeSourceInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumberWithMergeMark";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRevisionNumberWithMergeMark";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class RepositoryLogEntryHandler
    extends MyLogEntryHandler {
        RepositoryLogEntryHandler(SvnVcs vcs, Url url, Revision pegRevision, String lastPath, ThrowableConsumer<VcsFileRevision, SvnBindException> result, Url repoRootURL) {
            super(vcs, url, pegRevision, lastPath, result, repoRootURL);
        }

        @Override
        protected SvnFileRevision createRevision(LogEntry logEntry, String copyPath, LogEntryPath entryPath) throws SvnBindException {
            Url url = entryPath == null ? SvnUtil.append(this.myRepositoryRoot, this.myLastPathCorrector.getBefore()) : SvnUtil.append(this.myRepositoryRoot, entryPath.getPath(), true);
            return new SvnFileRevision(this.myVcs, Revision.UNDEFINED, logEntry, url, copyPath);
        }
    }

    private static class MyLogEntryHandler
    implements LogEntryConsumer {
        private final ProgressIndicator myIndicator;
        protected final SvnVcs myVcs;
        protected final SvnPathThroughHistoryCorrection myLastPathCorrector;
        protected final ThrowableConsumer<VcsFileRevision, SvnBindException> myResult;
        private final String myLastPath;
        private VcsFileRevision myPrevious;
        private final Revision myPegRevision;
        protected final Url myUrl;
        private final SvnMergeSourceTracker myTracker;
        protected Url myRepositoryRoot;
        private boolean myThrowCancelOnMeetPathCreation;

        public void setThrowCancelOnMeetPathCreation(boolean throwCancelOnMeetPathCreation) {
            this.myThrowCancelOnMeetPathCreation = throwCancelOnMeetPathCreation;
        }

        MyLogEntryHandler(SvnVcs vcs, Url url, Revision pegRevision, String lastPath, ThrowableConsumer<VcsFileRevision, SvnBindException> result, Url repoRootURL) {
            this.myVcs = vcs;
            this.myLastPathCorrector = new SvnPathThroughHistoryCorrection(lastPath);
            this.myLastPath = lastPath;
            this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            this.myResult = result;
            this.myPegRevision = pegRevision;
            this.myUrl = url;
            this.myRepositoryRoot = repoRootURL;
            this.myTracker = new SvnMergeSourceTracker((ThrowableConsumer<? super Pair<LogEntry, Integer>, ? extends SvnBindException>)((ThrowableConsumer)svnLogEntryIntegerPair -> {
                LogEntry logEntry = (LogEntry)svnLogEntryIntegerPair.getFirst();
                if (this.myIndicator != null) {
                    this.myIndicator.checkCanceled();
                    this.myIndicator.setText2(SvnBundle.message("progress.text2.revision.processed", logEntry.getRevision()));
                }
                LogEntryPath entryPath = null;
                String copyPath = null;
                int mergeLevel = (Integer)svnLogEntryIntegerPair.getSecond();
                if (!this.myLastPathCorrector.isRoot()) {
                    this.myLastPathCorrector.consume(logEntry);
                    entryPath = this.myLastPathCorrector.getDirectlyMentioned();
                    copyPath = null;
                    if (entryPath != null) {
                        copyPath = entryPath.getCopyPath();
                    }
                }
                SvnFileRevision revision = this.createRevision(logEntry, copyPath, entryPath);
                if (mergeLevel >= 0) {
                    MyLogEntryHandler.addToListByLevel((SvnFileRevision)this.myPrevious, revision, mergeLevel);
                } else {
                    this.myResult.consume((Object)revision);
                    this.myPrevious = revision;
                }
                if (this.myThrowCancelOnMeetPathCreation && this.myUrl.equals(revision.getURL()) && entryPath != null && entryPath.getType() == 'A') {
                    throw new ProcessCanceledException();
                }
            }));
        }

        private boolean checkForParentChanges(LogEntry logEntry) {
            String lastPathBefore = this.myLastPathCorrector.getBefore();
            String path = Url.removeTail(lastPathBefore);
            while (!path.isEmpty()) {
                LogEntryPath entryPath = logEntry.getChangedPaths().get(path);
                if (entryPath != null && (entryPath.getType() == 'A' || entryPath.getType() == 'D')) {
                    if (entryPath.getCopyPath() == null) break;
                    return true;
                }
                path = Url.removeTail(path);
            }
            return false;
        }

        private boolean checkForChildChanges(LogEntry logEntry) {
            String lastPathBefore = this.myLastPathCorrector.getBefore();
            for (String key : logEntry.getChangedPaths().keySet()) {
                if (!Url.isAncestor(lastPathBefore, key)) continue;
                return true;
            }
            return false;
        }

        public void consume(LogEntry logEntry) throws SvnBindException {
            this.myTracker.consume(logEntry);
        }

        private static void addToListByLevel(SvnFileRevision revision, SvnFileRevision revisionToAdd, int level) {
            if (level < 0) {
                return;
            }
            if (level == 0) {
                revision.addMergeSource(revisionToAdd);
                return;
            }
            List<SvnFileRevision> sources = revision.getMergeSources();
            if (!sources.isEmpty()) {
                MyLogEntryHandler.addToListByLevel(sources.get(sources.size() - 1), revisionToAdd, level - 1);
            }
        }

        protected SvnFileRevision createRevision(LogEntry logEntry, String copyPath, LogEntryPath entryPath) throws SvnBindException {
            Date date = logEntry.getDate();
            String author = logEntry.getAuthor();
            String message = logEntry.getMessage();
            Revision rev = Revision.of(logEntry.getRevision());
            Url url = SvnUtil.append(this.myRepositoryRoot, this.myLastPath, false);
            return new SvnFileRevision(this.myVcs, this.myPegRevision, rev, url, author, date, message, copyPath);
        }
    }
}

