/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSWithClause;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportOptimizer
extends JSModuleImportOptimizerBase {
    public final boolean supports(@NotNull PsiFile file) {
        if (file == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(0);
        }
        if (!(file instanceof JSFile)) {
            return false;
        }
        return this.checkDialect(DialectDetector.dialectOfElement((PsiElement)file));
    }

    @Override
    @NotNull
    public Collection<JSModuleImportOptimizerBase.UnusedModuleInfo> getModulesInfo(@NotNull PsiElement scope2, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        List<ES6ImportDeclaration> rawDeclarations;
        if (scope2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(1);
        }
        if (ignoredRefs == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(2);
        }
        if ((rawDeclarations = ES6ImportPsiUtil.getImportDeclarations(scope2)).isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ImportOptimizer.$$$reportNull$$$0(3);
            }
            return list;
        }
        final List declarations = ContainerUtil.filter(rawDeclarations, el -> !PsiTreeUtil.hasErrorElements((PsiElement)el));
        final ArrayList<ES6UnusedImportsHelper.UnusedInfo> infos = new ArrayList<ES6UnusedImportsHelper.UnusedInfo>();
        for (int i = 0; i < declarations.size(); ++i) {
            ES6UnusedImportsHelper.UnusedInfo info;
            ES6ImportDeclaration declaration = (ES6ImportDeclaration)declarations.get(i);
            if (PsiTreeUtil.hasErrorElements((PsiElement)declaration) || !(info = ES6UnusedImportsHelper.getInfo(declaration, i, i == 0 ? null : (ES6UnusedImportsHelper.UnusedInfo)infos.get(infos.size() - 1), ignoredRefs)).isSideEffectImport() && ES6ImportPsiUtil.getFromClauseText(declaration) == null) continue;
            infos.add(info);
        }
        final List<String> importTexts = this.buildNewImportsText(scope2, infos);
        JSModuleImportOptimizerBase.UnusedModuleInfo info = new JSModuleImportOptimizerBase.UnusedModuleInfo(){

            @Override
            @NotNull
            public List<String> getImportTexts() {
                List list = importTexts;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            public PsiElement getAnchor() {
                ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem((List)infos);
                if (item != null) {
                    return item.getDeclaration();
                }
                return (PsiElement)ContainerUtil.getFirstItem((List)declarations);
            }

            @Override
            @NotNull
            public List<PsiElement> getOldImports() {
                List list = ContainerUtil.map((Collection)infos, el -> el.getDeclaration());
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            public List<PsiElement> getImportsForScope(@NotNull PsiElement scope2) {
                if (scope2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new ArrayList<ES6ImportDeclaration>(ES6ImportPsiUtil.getImportDeclarations(scope2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getImportTexts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOldImports";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getImportsForScope";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2 -> new IllegalArgumentException(string);
                };
            }
        };
        List list = ContainerUtil.createMaybeSingletonList((Object)info);
        if (list == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private List<String> buildNewImportsText(@NotNull PsiElement module, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(5);
        }
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(6);
        }
        MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> result2 = ES6ImportOptimizer.groupByFromClause(infos);
        boolean merge = JSCodeStyleSettings.isMergeImports(module);
        ArrayList<String> importsResult = new ArrayList<String>();
        HashSet<String> visitedImports = new HashSet<String>();
        HashSet<String> visitedSideEffectImports = new HashSet<String>();
        Document document = PsiDocumentManager.getInstance((Project)module.getProject()).getDocument(module.getContainingFile());
        ArrayList<ES6UnusedImportsHelper.UnusedInfo> toProcessInfos = new ArrayList<ES6UnusedImportsHelper.UnusedInfo>(infos);
        ES6ImportOptimizer.sortByModuleName(module, toProcessInfos);
        for (ES6UnusedImportsHelper.UnusedInfo info : toProcessInfos) {
            Collection importsToMerge;
            ES6ImportDeclaration declaration = info.getDeclaration();
            if (info.isSideEffectImport()) {
                if (!visitedSideEffectImports.add(declaration.getImportModuleText())) continue;
                ArrayList<String> sideEffectImportWithComments = new ArrayList<String>();
                List<String> comments = JSOptimizeImportUtil.getPrevCommentsAsStrings(JSOptimizeImportUtil.getPrevComments(document, (PsiElement)declaration));
                ES6ImportOptimizer.addEmptyImport(module, document, sideEffectImportWithComments, info, comments, true);
                JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, ES6ImportOptimizer.getContextForWhitespaces(document, declaration), sideEffectImportWithComments);
                continue;
            }
            String fromText = ES6ImportPsiUtil.getUnquotedFromClauseText(declaration);
            if (fromText == null || !visitedImports.add(fromText) || (importsToMerge = result2.get((Object)fromText)).isEmpty()) continue;
            ArrayList<String> currentImportsAndComments = new ArrayList<String>();
            List<MergedImports> mergedImportsList = this.getMergedImports(module, importsToMerge, document, fromText, merge);
            for (MergedImports text : mergedImportsList) {
                Collection<ES6UnusedImportsHelper.UnusedInfo> currentImportInfos = text.myMergedImports;
                List<PsiElement> prevComments = text.myPrevComments;
                List<String> sortedCommentsAsString = JSOptimizeImportUtil.getPrevCommentsAsStrings(prevComments);
                List<String> currentTexts = text.myNewImportTexts;
                if (!currentTexts.isEmpty()) {
                    currentImportsAndComments.addAll(sortedCommentsAsString);
                    currentImportsAndComments.addAll(currentTexts);
                    continue;
                }
                ES6UnusedImportsHelper.UnusedInfo emptyImportInfo = ES6ImportOptimizer.getSuppressedEmptyImport(currentImportInfos);
                if (emptyImportInfo != null) {
                    ES6ImportOptimizer.addEmptyImport(module, document, currentImportsAndComments, emptyImportInfo, sortedCommentsAsString, false);
                    continue;
                }
                currentImportsAndComments.addAll(sortedCommentsAsString);
            }
            JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, ES6ImportOptimizer.getContextForWhitespaces(document, declaration), currentImportsAndComments);
        }
        ArrayList<String> arrayList = importsResult;
        if (arrayList == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static PsiElement getContextForWhitespaces(Document document, ES6ImportDeclaration declaration) {
        List<PsiElement> comments = JSOptimizeImportUtil.getPrevComments(document, (PsiElement)declaration);
        ES6ImportDeclaration eS6ImportDeclaration = comments.isEmpty() ? declaration : comments.get(0);
        if (eS6ImportDeclaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(8);
        }
        return eS6ImportDeclaration;
    }

    @NotNull
    protected List<MergedImports> getMergedImports(@NotNull PsiElement module, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, Document document, String fromText, boolean merge) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(9);
        }
        if (merge) {
            List<MergedImports> list = this.getMergedImports(module, document, fromText, mergedImports);
            if (list == null) {
                ES6ImportOptimizer.$$$reportNull$$$0(10);
            }
            return list;
        }
        HashSet<String> visitedBindings = new HashSet<String>();
        HashSet<String> visitedSpecifiers = new HashSet<String>();
        ArrayList<MergedImports> result2 = new ArrayList<MergedImports>();
        for (ES6UnusedImportsHelper.UnusedInfo info : mergedImports) {
            List<MergedImports> importBodyText = this.getImportBodyText(module, document, Collections.singleton(info), fromText, visitedBindings, visitedSpecifiers);
            result2.addAll(importBodyText);
        }
        ArrayList<MergedImports> arrayList = result2;
        if (arrayList == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static ES6UnusedImportsHelper.UnusedInfo getSuppressedEmptyImport(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(12);
        }
        return (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.find(mergedImports, el -> el.isEmpty() && ES6UnusedImportsHelper.isES6SuppressedUnused(el.getDeclaration()));
    }

    private static void sortByModuleName(@NotNull PsiElement module, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(13);
        }
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(14);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(module);
        if (!settings.IMPORT_SORT_MODULE_NAME) {
            return;
        }
        List<ES6UnusedImportsHelper.UnusedInfo> orderedImports = ES6ImportOptimizer.buildOrderedImports(infos);
        Collections.copy(infos, orderedImports);
    }

    protected List<MergedImports> getMergedImports(@NotNull PsiElement module, @Nullable Document document, @NotNull String fromText, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(15);
        }
        if (fromText == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(16);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(17);
        }
        return this.getImportBodyText(module, document, mergedImports, fromText);
    }

    private static void addEmptyImport(@NotNull PsiElement module, @Nullable Document document, @NotNull List<String> importsResult, @NotNull ES6UnusedImportsHelper.UnusedInfo info, @NotNull List<String> prevComments, boolean isSideEffect) {
        String name;
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(18);
        }
        if (importsResult == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(19);
        }
        if (info == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(20);
        }
        if (prevComments == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(21);
        }
        ES6ImportDeclaration declaration = info.getDeclaration();
        String string = name = isSideEffect ? declaration.getImportModuleText() : ES6ImportPsiUtil.getFromClauseText(declaration);
        if (!StringUtil.isEmpty((String)name)) {
            importsResult.addAll(prevComments);
            StringBuilder builder2 = new StringBuilder();
            builder2.append("import ");
            ImportStyle style = ES6ImportOptimizer.getImportStyle(module, declaration);
            String moduleName = StringUtil.unquoteString((String)name);
            if (isSideEffect) {
                ES6ImportOptimizer.addFromPartWithoutKeyword(style, moduleName, builder2);
            } else {
                builder2.append("{}");
                ES6ImportOptimizer.addFromPart(style, moduleName, builder2);
            }
            builder2.append(style.mySemicolon);
            JSOptimizeImportUtil.addSameLineComments(document, (PsiElement)declaration, builder2);
            importsResult.add(builder2.toString());
        }
    }

    @NotNull
    private static MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> groupByFromClause(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(22);
        }
        MultiMap results = MultiMap.createLinked();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            ES6ImportDeclaration declaration = info.getDeclaration();
            String text = ES6ImportPsiUtil.getUnquotedFromClauseText(declaration);
            if (text == null) continue;
            results.putValue((Object)text, (Object)info);
        }
        MultiMap multiMap = results;
        if (multiMap == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(23);
        }
        return multiMap;
    }

    @NotNull
    protected List<MergedImports> getImportBodyText(@NotNull PsiElement module, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart) {
        if (module == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(24);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(25);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(26);
        }
        HashSet<String> bindings = new HashSet<String>();
        HashSet<String> specifiers = new HashSet<String>();
        List<MergedImports> list = this.getImportBodyText(module, document, mergedImports, fromPart, bindings, specifiers);
        if (list == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    private static <PartType extends ES6ImportExportDeclarationPart> MultiMap<PartType, ES6ImportDeclaration> getUniqueImportParts(@NotNull List<PartType> parts, @NotNull Collection<String> visitedNames) {
        if (parts == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(28);
        }
        if (visitedNames == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(29);
        }
        MultiMap mergedParts = MultiMap.createLinked();
        HashMap<String, ES6ImportExportDeclarationPart> names = new HashMap<String, ES6ImportExportDeclarationPart>();
        for (ES6ImportExportDeclarationPart importPart : parts) {
            String name = importPart.getDeclaredName();
            if (name == null || visitedNames.contains(name)) continue;
            mergedParts.putValue((Object)names.computeIfAbsent(name, __ -> importPart), (Object)((ES6ImportDeclaration)importPart.getDeclaration()));
        }
        visitedNames.addAll(names.keySet());
        MultiMap multiMap = mergedParts;
        if (multiMap == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(30);
        }
        return multiMap;
    }

    protected List<MergedImports> getImportBodyText(@NotNull PsiElement context2, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart, @NotNull Collection<String> visitedBindingNames, @NotNull Collection<String> visitedSpecifierNames) {
        if (context2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(31);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(32);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(33);
        }
        if (visitedBindingNames == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(34);
        }
        if (visitedSpecifierNames == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(35);
        }
        ArrayList<ES6ImportedBinding> bindings = new ArrayList<ES6ImportedBinding>();
        ArrayList<ES6ImportSpecifier> specifiers = new ArrayList<ES6ImportSpecifier>();
        ArrayList<PsiElement> prevCommentsToProcess = new ArrayList<PsiElement>();
        HashMap<ES6ImportDeclaration, PsiElement> lineCommentsToProcess = new HashMap<ES6ImportDeclaration, PsiElement>();
        for (ES6UnusedImportsHelper.UnusedInfo importInfo : mergedImports) {
            ES6ImportDeclaration declaration = importInfo.getDeclaration();
            ES6ImportOptimizer.fillUsedBindingsAndSpecifiers(bindings, specifiers, importInfo, declaration);
            PsiElement comment = JSOptimizeImportUtil.getLineComment(document, (PsiElement)declaration);
            if (comment != null) {
                lineCommentsToProcess.put(declaration, comment);
            }
            prevCommentsToProcess.addAll(JSOptimizeImportUtil.getPrevComments(document, (PsiElement)declaration));
        }
        ES6ImportOptimizer.sortSpecifiers(context2, specifiers);
        MultiMap uniqueBindings = ES6ImportOptimizer.getUniqueImportParts(bindings, visitedBindingNames);
        MultiMap<ES6ImportSpecifier, ES6ImportDeclaration> uniqueSpecifiers = ES6ImportOptimizer.getUniqueImportParts(specifiers, visitedSpecifierNames);
        ImportStyle importStyle = ES6ImportOptimizer.getImportStyle(context2, mergedImports);
        ImportBuilder importBuilder = new ImportBuilder(importStyle, this.getImportPrefix(mergedImports), fromPart, ES6ImportOptimizer.getAssertionText(mergedImports, importStyle.myQuote));
        ArrayList<String> resultListOfImportTexts = new ArrayList<String>();
        importBuilder = ES6ImportOptimizer.appendBindings(uniqueBindings, importBuilder, lineCommentsToProcess, resultListOfImportTexts);
        ES6ImportOptimizer.appendSpecifiers(uniqueSpecifiers, importBuilder, lineCommentsToProcess);
        if (!importBuilder.isEmpty()) {
            resultListOfImportTexts.add(importBuilder.createImportString());
        }
        return Collections.singletonList(new MergedImports(mergedImports, resultListOfImportTexts, prevCommentsToProcess));
    }

    @Nullable
    private static String getAssertionText(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, String quote) {
        JSWithClause assertClause;
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(36);
        }
        if ((assertClause = (JSWithClause)mergedImports.stream().map(u -> u.getDeclaration().getWithClause()).filter(Objects::nonNull).findFirst().orElse(null)) == null) {
            return null;
        }
        return (String)SyntaxTraverser.astTraverser((ASTNode)assertClause.getNode()).traverse(TreeTraversal.LEAVES_DFS).map(astNode -> {
            String text = astNode.getText();
            if (StringUtil.isQuotedString((String)text) && !text.startsWith(quote)) {
                text = JSStringUtil.changeQuotes(text);
            }
            return text;
        }).reduce((Object)"", String::concat);
    }

    private static void sortSpecifiers(@NotNull PsiElement context2, @NotNull List<ES6ImportSpecifier> specifiers) {
        if (context2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(37);
        }
        if (specifiers == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(38);
        }
        if (JSCodeStyleSettings.getSettings((PsiElement)context2).IMPORT_SORT_MEMBERS) {
            Comparator<ES6ImportSpecifier> comparator = ES6ImportPsiUtil.getImportMemberComparator(context2);
            ContainerUtil.sort(specifiers, comparator);
        }
    }

    private static ImportBuilder appendBindings(@NotNull MultiMap<ES6ImportedBinding, ES6ImportDeclaration> uniqueBindings, @NotNull ImportBuilder importBuilder, @NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess, @NotNull List<String> listOfImports) {
        if (uniqueBindings == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(39);
        }
        if (importBuilder == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(40);
        }
        if (lineCommentsToProcess == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(41);
        }
        if (listOfImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(42);
        }
        int bindingCount = 0;
        boolean lastIsAll = false;
        for (Map.Entry bindingWithDeclarations : uniqueBindings.entrySet()) {
            ES6ImportedBinding binding = (ES6ImportedBinding)bindingWithDeclarations.getKey();
            if (bindingCount > 0) {
                if (bindingCount == 1 && !lastIsAll && binding.isNamespaceImport()) {
                    importBuilder.append(", ");
                } else {
                    listOfImports.add(importBuilder.createImportString());
                    importBuilder = importBuilder.cloneBuilder();
                    bindingCount = 0;
                }
            }
            ++bindingCount;
            ImportBuilder finalImportBuilder = importBuilder;
            ((Collection)bindingWithDeclarations.getValue()).forEach(decl -> ES6ImportOptimizer.addLineCommentsToBuilder(lineCommentsToProcess, finalImportBuilder, decl));
            importBuilder.append(binding.getText());
            lastIsAll = binding.isNamespaceImport();
        }
        if (lastIsAll) {
            listOfImports.add(importBuilder.createImportString());
            return importBuilder.cloneBuilder();
        }
        return importBuilder;
    }

    private static void appendSpecifiers(@NotNull MultiMap<ES6ImportSpecifier, ES6ImportDeclaration> uniqueSpecifiers, @NotNull ImportBuilder importBuilder, @NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess) {
        if (uniqueSpecifiers == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(43);
        }
        if (importBuilder == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(44);
        }
        if (lineCommentsToProcess == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(45);
        }
        if (uniqueSpecifiers.isEmpty()) {
            return;
        }
        if (!importBuilder.isEmpty()) {
            importBuilder.append(", ");
        }
        importBuilder.append("{");
        String specifierList = StringUtil.join((Collection)uniqueSpecifiers.entrySet(), el -> {
            ES6ImportSpecifier specifier = (ES6ImportSpecifier)el.getKey();
            ((Collection)el.getValue()).forEach(decl -> ES6ImportOptimizer.addLineCommentsToBuilder(lineCommentsToProcess, importBuilder, decl));
            return specifier.getText();
        }, (String)", ");
        importBuilder.append(specifierList);
        if (importBuilder.myStyle.myAddTrailingComma) {
            importBuilder.append(", ");
        }
        importBuilder.append("}");
    }

    private static void addLineCommentsToBuilder(@NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess, @NotNull ImportBuilder builder2, @NotNull ES6ImportDeclaration declaration) {
        PsiElement comment;
        if (lineCommentsToProcess == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(46);
        }
        if (builder2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(47);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(48);
        }
        if ((comment = lineCommentsToProcess.remove(declaration)) != null) {
            builder2.addLineComment(comment);
        }
    }

    private static void fillUsedBindingsAndSpecifiers(List<ES6ImportedBinding> bindings, List<ES6ImportSpecifier> specifiers, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration) {
        boolean isSuppressedUnused = ES6UnusedImportsHelper.isES6SuppressedUnused(declaration);
        ES6ImportOptimizer.fillUsedSpecifiers(specifiers, importInfo, declaration, isSuppressedUnused);
        ES6ImportOptimizer.fillUsedBindings(bindings, importInfo, declaration, isSuppressedUnused);
    }

    private static void fillUsedBindings(@NotNull List<ES6ImportedBinding> bindings, @NotNull ES6UnusedImportsHelper.UnusedInfo importInfo, @NotNull ES6ImportDeclaration declaration, boolean isSuppressedUnused) {
        if (bindings == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(49);
        }
        if (importInfo == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(50);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(51);
        }
        Object[] currentBindings = declaration.getImportedBindings();
        Collection<Object> unusedBindings = isSuppressedUnused ? new ArrayList() : importInfo.getUnusedBindings();
        bindings.addAll(ContainerUtil.filter((Object[])currentBindings, el -> !unusedBindings.contains(el)));
    }

    private static void fillUsedSpecifiers(@NotNull List<ES6ImportSpecifier> specifiers, @NotNull ES6UnusedImportsHelper.UnusedInfo importInfo, @NotNull ES6ImportDeclaration declaration, boolean isSuppressedUnused) {
        if (specifiers == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(52);
        }
        if (importInfo == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(53);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(54);
        }
        Object[] currentSpecifiers = declaration.getImportSpecifiers();
        Collection<Object> unusedSpecifiers = isSuppressedUnused ? new ArrayList() : importInfo.getUnusedSpecifiers();
        specifiers.addAll(ContainerUtil.filter((Object[])currentSpecifiers, el -> !unusedSpecifiers.contains(el)));
    }

    @NotNull
    protected String getImportPrefix(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        if (imports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(55);
        }
        return "import ";
    }

    private static void addFromPart(@NotNull ImportStyle style, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (style == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(56);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(57);
        }
        if (importBody == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(58);
        }
        importBody.append(" from ");
        ES6ImportOptimizer.addFromPartWithoutKeyword(style, fromPart, importBody);
    }

    @NotNull
    private static ImportStyle getImportStyle(@NotNull PsiElement context2, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        ES6UnusedImportsHelper.UnusedInfo item;
        if (context2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(59);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(60);
        }
        if ((item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem(mergedImports)) == null) {
            return ES6ImportOptimizer.getDefaultImportStyle(context2);
        }
        ES6ImportDeclaration declaration = item.getDeclaration();
        return ES6ImportOptimizer.getImportStyle(context2, declaration);
    }

    @NotNull
    private static ImportStyle getDefaultImportStyle(@NotNull PsiElement context2) {
        if (context2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(61);
        }
        return new ImportStyle(JSCodeStyleSettings.getQuote(context2), false, JSCodeStyleSettings.getSemicolon(context2));
    }

    @NotNull
    private static ImportStyle getImportStyle(@NotNull PsiElement context2, @NotNull ES6ImportDeclaration declaration) {
        if (context2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(62);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(63);
        }
        String semicolon = ES6ImportOptimizer.getSemicolon(context2, declaration);
        String quote = ES6ImportOptimizer.getQuote(context2, declaration);
        boolean shouldAddTrailingCommaToSpecifiers = ES6ImportOptimizer.shouldAddTrailingCommaToSpecifiers(context2, declaration);
        return new ImportStyle(quote, shouldAddTrailingCommaToSpecifiers, semicolon);
    }

    private static boolean shouldAddTrailingCommaToSpecifiers(@NotNull PsiElement context2, @NotNull ES6ImportDeclaration declaration) {
        ES6ImportSpecifier[] specifiers;
        if (context2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(64);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(65);
        }
        if ((specifiers = declaration.getImportSpecifiers()).length == 0) {
            return false;
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context2);
        if (settings.ENFORCE_TRAILING_COMMA == JSCodeStyleSettings.TrailingCommaOption.Remove) {
            return false;
        }
        ES6ImportSpecifier lastSpecifier = specifiers[specifiers.length - 1];
        PsiElement sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)lastSpecifier);
        return sibling != null && sibling.getNode().getElementType() == JSTokenTypes.COMMA;
    }

    @NotNull
    private static String getQuote(@NotNull PsiElement context2, @NotNull ES6ImportDeclaration declaration) {
        if (context2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(66);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(67);
        }
        ASTNode declarationNode = declaration.getNode();
        ES6FromClause clause = declaration.getFromClause();
        ASTNode parentNode = clause == null ? declarationNode : clause.getNode();
        ASTNode stringLiteral = parentNode.findChildByType(JSTokenTypes.STRING_LITERAL);
        String string = ES6ImportPsiUtil.getQuote(context2, stringLiteral);
        if (string == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(68);
        }
        return string;
    }

    private static String getSemicolon(@NotNull PsiElement context2, @NotNull ES6ImportDeclaration declaration) {
        if (context2 == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(69);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(70);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context2);
        if (settings.FORCE_SEMICOLON_STYLE) {
            return JSCodeStyleSettings.getSemicolon(context2);
        }
        ASTNode declarationNode = declaration.getNode();
        ASTNode semicolonNode = declarationNode.findChildByType(JSTokenTypes.SEMICOLON);
        return semicolonNode == null ? "" : semicolonNode.getText();
    }

    private static void addFromPartWithoutKeyword(@NotNull ImportStyle style, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (style == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(71);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(72);
        }
        if (importBody == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(73);
        }
        String quote = style.myQuote;
        importBody.append(quote);
        importBody.append(fromPart);
        importBody.append(quote);
    }

    @NotNull
    private static List<ES6UnusedImportsHelper.UnusedInfo> buildOrderedImports(@NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(74);
        }
        ArrayList<ES6UnusedImportsHelper.UnusedInfo> regularImports = new ArrayList<ES6UnusedImportsHelper.UnusedInfo>(infos.stream().filter(el -> !el.isSideEffectImport()).toList());
        HashMap<ES6UnusedImportsHelper.UnusedInfo, ES6UnusedImportsHelper.UnusedInfo> bareImportsMap = new HashMap<ES6UnusedImportsHelper.UnusedInfo, ES6UnusedImportsHelper.UnusedInfo>();
        ES6UnusedImportsHelper.UnusedInfo headBareImport = null;
        ES6UnusedImportsHelper.UnusedInfo tailBareImport = null;
        for (int i = 0; i < infos.size(); ++i) {
            ES6UnusedImportsHelper.UnusedInfo item = infos.get(i);
            if (!item.isSideEffectImport()) continue;
            if (item.getPosition() == 0) {
                headBareImport = item;
                continue;
            }
            if (item.getPosition() == infos.size() - 1) {
                tailBareImport = item;
                continue;
            }
            if (item.getPrevAnchor() == null) continue;
            bareImportsMap.put(item.getPrevAnchor(), item);
        }
        ES6ImportOptimizer.sortRegularImports(regularImports);
        ArrayList<ES6UnusedImportsHelper.UnusedInfo> orderedImports = new ArrayList<ES6UnusedImportsHelper.UnusedInfo>(infos);
        ES6ImportOptimizer.mergeImports(regularImports, bareImportsMap, headBareImport, tailBareImport, orderedImports);
        ArrayList<ES6UnusedImportsHelper.UnusedInfo> arrayList = orderedImports;
        if (arrayList == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(75);
        }
        return arrayList;
    }

    private static void mergeImports(@NotNull List<ES6UnusedImportsHelper.UnusedInfo> regularImports, @NotNull Map<ES6UnusedImportsHelper.UnusedInfo, ES6UnusedImportsHelper.UnusedInfo> bareImportsMap, @Nullable ES6UnusedImportsHelper.UnusedInfo headBareImport, @Nullable ES6UnusedImportsHelper.UnusedInfo tailBareImport, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> orderedImports) {
        if (regularImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(76);
        }
        if (bareImportsMap == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(77);
        }
        if (orderedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(78);
        }
        int regularIdx = 0;
        int len = orderedImports.size();
        int start = 0;
        int end = len;
        if (headBareImport != null) {
            orderedImports.set(0, headBareImport);
            start = 1;
        }
        if (tailBareImport != null) {
            orderedImports.set(len - 1, tailBareImport);
            end = len - 1;
        }
        for (int i = start; i < end; ++i) {
            ES6UnusedImportsHelper.UnusedInfo bareImportCandidate;
            ES6UnusedImportsHelper.UnusedInfo regularImportCandidate = regularIdx < regularImports.size() ? regularImports.get(regularIdx) : null;
            ES6UnusedImportsHelper.UnusedInfo unusedInfo = bareImportCandidate = i > 0 ? bareImportsMap.get(orderedImports.get(i - 1)) : null;
            if (regularImportCandidate != null && bareImportCandidate == null) {
                orderedImports.set(i, regularImportCandidate);
                ++regularIdx;
                continue;
            }
            if (regularImportCandidate == null && bareImportCandidate != null) {
                orderedImports.set(i, bareImportCandidate);
                continue;
            }
            if (regularImportCandidate == null) continue;
            orderedImports.set(i, bareImportCandidate);
        }
    }

    private static void sortRegularImports(@NotNull List<ES6UnusedImportsHelper.UnusedInfo> regularImports) {
        if (regularImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(79);
        }
        Comparator<String> comparator = ES6ImportPsiUtil.getStringImportFromComparator();
        ContainerUtil.sort(regularImports, (o1, o2) -> {
            ES6ImportDeclaration declaration1 = o1.getDeclaration();
            ES6ImportDeclaration declaration2 = o2.getDeclaration();
            String fromClauseText1 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText(declaration1);
            String fromClauseText2 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText(declaration2);
            return comparator.compare(fromClauseText1, fromClauseText2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 10, 11, 23, 27, 30, 68, 75 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRefs";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 23: 
            case 27: 
            case 30: 
            case 68: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 15: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 12: 
            case 17: 
            case 25: 
            case 32: 
            case 36: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedImports";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importsResult";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevComments";
                break;
            }
            case 26: 
            case 33: 
            case 57: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPart";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedNames";
                break;
            }
            case 31: 
            case 37: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedBindingNames";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedSpecifierNames";
                break;
            }
            case 38: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiers";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueBindings";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importBuilder";
                break;
            }
            case 41: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineCommentsToProcess";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOfImports";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueSpecifiers";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 48: 
            case 51: 
            case 54: 
            case 63: 
            case 65: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importInfo";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 56: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 58: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importBody";
                break;
            }
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularImports";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bareImportsMap";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderedImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewImportsText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextForWhitespaces";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedImports";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByFromClause";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportBodyText";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueImportParts";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuote";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOrderedImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModulesInfo";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 23: 
            case 27: 
            case 30: 
            case 68: 
            case 75: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildNewImportsText";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMergedImports";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedEmptyImport";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sortByModuleName";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyImport";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "groupByFromClause";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getImportBodyText";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueImportParts";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAssertionText";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sortSpecifiers";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "appendBindings";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "appendSpecifiers";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addLineCommentsToBuilder";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "fillUsedBindings";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "fillUsedSpecifiers";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getImportPrefix";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addFromPart";
                break;
            }
            case 59: 
            case 60: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getImportStyle";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultImportStyle";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddTrailingCommaToSpecifiers";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getQuote";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getSemicolon";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addFromPartWithoutKeyword";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "buildOrderedImports";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "mergeImports";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "sortRegularImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 10, 11, 23, 27, 30, 68, 75 -> new IllegalStateException(string);
        };
    }

    protected static class MergedImports {
        @NotNull
        private final Collection<ES6UnusedImportsHelper.UnusedInfo> myMergedImports;
        @NotNull
        private final List<String> myNewImportTexts;
        @NotNull
        private final List<PsiElement> myPrevComments;

        public MergedImports(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull List<String> newImportTexts, @NotNull List<PsiElement> prevComments) {
            if (mergedImports == null) {
                MergedImports.$$$reportNull$$$0(0);
            }
            if (newImportTexts == null) {
                MergedImports.$$$reportNull$$$0(1);
            }
            if (prevComments == null) {
                MergedImports.$$$reportNull$$$0(2);
            }
            this.myMergedImports = mergedImports;
            this.myNewImportTexts = newImportTexts;
            this.myPrevComments = prevComments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mergedImports";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newImportTexts";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prevComments";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$MergedImports";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ImportStyle {
        private final String mySemicolon;
        private final String myQuote;
        private final boolean myAddTrailingComma;

        ImportStyle(String quote, boolean addTrailingComma, String semicolon) {
            this.mySemicolon = semicolon;
            this.myQuote = quote;
            this.myAddTrailingComma = addTrailingComma;
        }
    }

    static class ImportBuilder {
        @NotNull
        private final ImportStyle myStyle;
        @NotNull
        private final String myImportPrefix;
        @NotNull
        private final String myFromPart;
        @Nullable
        private final String myAssertClause;
        @NotNull
        private final StringBuilder myCurrentText;
        @NotNull
        private final List<PsiElement> myLineComments;

        ImportBuilder(@NotNull ImportStyle style, @NotNull String importPrefix, @NotNull String fromPart, @Nullable String assertClause) {
            if (style == null) {
                ImportBuilder.$$$reportNull$$$0(0);
            }
            if (importPrefix == null) {
                ImportBuilder.$$$reportNull$$$0(1);
            }
            if (fromPart == null) {
                ImportBuilder.$$$reportNull$$$0(2);
            }
            this.myStyle = style;
            this.myImportPrefix = importPrefix;
            this.myFromPart = fromPart;
            this.myAssertClause = assertClause;
            this.myCurrentText = new StringBuilder();
            this.myLineComments = new ArrayList<PsiElement>();
        }

        private void append(@NotNull String text) {
            if (text == null) {
                ImportBuilder.$$$reportNull$$$0(3);
            }
            this.myCurrentText.append(text);
        }

        private boolean isEmpty() {
            return this.myCurrentText.isEmpty();
        }

        private void addLineComment(@NotNull PsiElement comment) {
            if (comment == null) {
                ImportBuilder.$$$reportNull$$$0(4);
            }
            this.myLineComments.add(comment);
        }

        @NotNull
        private String createImportString() {
            assert (!this.isEmpty());
            ES6ImportOptimizer.addFromPart(this.myStyle, this.myFromPart, this.myCurrentText);
            if (this.myAssertClause != null) {
                this.myCurrentText.append(' ').append(this.myAssertClause);
            }
            this.myCurrentText.append(this.myStyle.mySemicolon);
            JSOptimizeImportUtil.addSameLineComments(this.myCurrentText, JSOptimizeImportUtil.getPsiElementsAsStrings(this.myLineComments));
            String string = this.myImportPrefix + String.valueOf(this.myCurrentText);
            if (string == null) {
                ImportBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private ImportBuilder cloneBuilder() {
            return new ImportBuilder(this.myStyle, this.myImportPrefix, this.myFromPart, this.myAssertClause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importPrefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromPart";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createImportString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addLineComment";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

