/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptChangeConstructorAccessRightsFix
extends LocalQuickFixOnPsiElement {
    private final JSAttributeList.AccessType myAccessType;

    public TypeScriptChangeConstructorAccessRightsFix(JSFunction node, JSAttributeList.AccessType accessType) {
        super((PsiElement)node);
        this.myAccessType = accessType;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("typescript.make.constructor.protected", new Object[0]);
        if (string == null) {
            TypeScriptChangeConstructorAccessRightsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            TypeScriptChangeConstructorAccessRightsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSFunction function;
        if (project == null) {
            TypeScriptChangeConstructorAccessRightsFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TypeScriptChangeConstructorAccessRightsFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            TypeScriptChangeConstructorAccessRightsFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            TypeScriptChangeConstructorAccessRightsFix.$$$reportNull$$$0(5);
        }
        if ((function = (JSFunction)ObjectUtils.tryCast((Object)startElement, JSFunction.class)) == null) {
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(function);
        wrapper.overrideAccessType(this.myAccessType);
        wrapper.applyTo(function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptChangeConstructorAccessRightsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptChangeConstructorAccessRightsFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

