/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.languagescope;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.actionscript.ActionScriptStubElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.types.JSBlockStatementElementType;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.clones.core.CommonUtilsKt;
import com.jetbrains.clones.core.LighterAstNodeHashCache;
import com.jetbrains.clones.core.NodeHash;
import com.jetbrains.clones.languagescope.ElementType;
import com.jetbrains.clones.languagescope.common.CommonDuplicateScope;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020'H\u0016J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-H\u0014J\u0018\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u00020/H\u0002J\u001a\u00101\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u00062"}, d2={"Lcom/jetbrains/clones/languagescope/JSBaseDuplicateScope;", "Lcom/jetbrains/clones/languagescope/common/CommonDuplicateScope;", "language", "", "<init>", "(Ljava/lang/String;)V", "languageName", "getLanguageName", "()Ljava/lang/String;", "noiseTokens", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getNoiseTokens", "()Lcom/intellij/psi/tree/TokenSet;", "noiseTokens$delegate", "Lkotlin/Lazy;", "isNoise", "", "ast", "Lcom/intellij/lang/LighterAST;", "node", "Lcom/intellij/lang/LighterASTNode;", "getElementType", "Lcom/jetbrains/clones/languagescope/ElementType;", "isAnonymized", "Lcom/intellij/lang/LighterASTTokenNode;", "shouldAnalyzeChildSubsequences", "parent", "isIgnoredAsDuplicate", "weightOf", "", "hashOf", "", "cache", "Lcom/jetbrains/clones/core/LighterAstNodeHashCache;", "children", "", "Lcom/jetbrains/clones/core/NodeHash;", "processDuplicate", "Lcom/jetbrains/clones/structures/TextClone;", "project", "Lcom/intellij/openapi/project/Project;", "textClone", "isDuplicateFileAcceptable", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "alignBraces", "Lcom/jetbrains/clones/structures/TextFragment;", "fragment", "hasExportAttribute", "intellij.javascript.duplicatesDetection"})
@SourceDebugExtension(value={"SMAP\nJSDuplicateScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDuplicateScope.kt\ncom/jetbrains/clones/languagescope/JSBaseDuplicateScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,151:1\n1053#2:152\n774#2:153\n865#2,2:154\n1557#2:156\n1628#2,3:157\n183#3,2:160\n*S KotlinDebug\n*F\n+ 1 JSDuplicateScope.kt\ncom/jetbrains/clones/languagescope/JSBaseDuplicateScope\n*L\n100#1:152\n106#1:153\n106#1:154,2\n111#1:156\n111#1:157,3\n121#1:160,2\n*E\n"})
public class JSBaseDuplicateScope
extends CommonDuplicateScope {
    @NotNull
    private final String languageName;
    @NotNull
    private final Lazy noiseTokens$delegate;

    public JSBaseDuplicateScope(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.languageName = language;
        this.noiseTokens$delegate = LazyKt.lazy(JSBaseDuplicateScope::noiseTokens_delegate$lambda$0);
    }

    @NotNull
    public final String getLanguageName() {
        return this.languageName;
    }

    private final TokenSet getNoiseTokens() {
        Lazy lazy = this.noiseTokens$delegate;
        return (TokenSet)lazy.getValue();
    }

    public boolean isNoise(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getNoiseTokens().contains(node.getTokenType());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ElementType getElementType(LighterAST ast, LighterASTNode node) {
        ElementType elementType;
        LighterASTNode lighterASTNode = ast.getParent(node);
        if (lighterASTNode == null) {
            return ElementType.Other;
        }
        LighterASTNode parent = lighterASTNode;
        LighterASTNode grandparent = ast.getParent(parent);
        if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)JSTokenTypes.IDENTIFIER)) {
            if (JSElementTypes.FUNCTION_DECLARATIONS.contains(parent.getTokenType())) {
                elementType = ElementType.Function;
                return elementType;
            }
            LighterASTNode lighterASTNode2 = grandparent;
            if (Intrinsics.areEqual((Object)(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null), JSStubElementTypes.CALL_EXPRESSION)) {
                elementType = ElementType.Function;
                return elementType;
            }
            if (Intrinsics.areEqual((Object)parent.getTokenType(), (Object)ActionScriptStubElementTypes.ACTIONSCRIPT_CLASS)) {
                elementType = ElementType.Classname;
                return elementType;
            }
            if (Intrinsics.areEqual((Object)parent.getTokenType(), JSStubElementTypes.VARIABLE) && this.hasExportAttribute(ast, grandparent)) {
                elementType = ElementType.GlobalVariable;
                return elementType;
            }
            if (Intrinsics.areEqual((Object)parent.getTokenType(), (Object)JSElementTypes.REFERENCE_EXPRESSION)) {
                elementType = ElementType.Field;
                return elementType;
            }
            if (node instanceof LighterASTTokenNode) {
                CharSequence charSequence = ((LighterASTTokenNode)node).getText();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getText(...)");
                if (Character.isLowerCase(StringsKt.first((CharSequence)charSequence))) {
                    elementType = ElementType.Identifier;
                    return elementType;
                }
            }
            elementType = ElementType.Type;
            return elementType;
        }
        if (Intrinsics.areEqual((Object)parent.getTokenType(), JSStubElementTypes.LITERAL_EXPRESSION)) {
            elementType = ElementType.Literal;
            return elementType;
        }
        elementType = ElementType.Other;
        return elementType;
    }

    public boolean isAnonymized(@NotNull LighterAST ast, @NotNull LighterASTTokenNode node) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getElementType(ast, (LighterASTNode)node).ordinal()]) {
            case 1 -> this.getIndexConfiguration().getAnonymizeIdentifiers();
            case 2 -> this.getIndexConfiguration().getAnonymizeLiterals();
            case 3, 4 -> this.getIndexConfiguration().getAnonymizeFunctions();
            case 5 -> true;
            case 6 -> false;
            default -> false;
        };
    }

    public boolean shouldAnalyzeChildSubsequences(@NotNull LighterAST ast, @NotNull LighterASTNode parent) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent.getTokenType() instanceof JSBlockStatementElementType || parent.getTokenType() instanceof JSFileElementType;
    }

    public boolean isIgnoredAsDuplicate(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getTokenType() instanceof JSBlockStatementElementType;
    }

    public int weightOf(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        int n;
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LighterASTNode parent = ast.getParent(node);
        LighterASTNode lighterASTNode = parent;
        if ((lighterASTNode != null ? lighterASTNode.getTokenType() : null) instanceof JSBlockStatementElementType) {
            n = 2;
        } else {
            LighterASTNode lighterASTNode2 = parent;
            n = (lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null) instanceof JSFileElementType ? 2 : (JSElementTypes.EXPRESSIONS.contains(node.getTokenType()) ? 1 : 0);
        }
        return n;
    }

    public long hashOf(@NotNull LighterAstNodeHashCache cache, @NotNull LighterAST ast, @NotNull LighterASTNode node, @NotNull List<? extends NodeHash> children) {
        long l;
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        if (Intrinsics.areEqual((Object)node.getTokenType(), JSStubElementTypes.IMPLEMENTS_LIST)) {
            Iterable $this$sortedBy$iv = children;
            boolean $i$f$sortedBy = false;
            l = CommonUtilsKt.nodeListHash((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    NodeHash it = (NodeHash)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getHash());
                    it = (NodeHash)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getHash()));
                }
            }));
        } else {
            l = super.hashOf(cache, ast, node, children);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public TextClone processDuplicate(@NotNull Project project, @NotNull TextClone textClone) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)textClone, (String)"textClone");
        Iterable iterable = textClone.getDuplicates();
        TextFragment textFragment = textClone.getMain();
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!this.isDuplicateFileAcceptable(it.getFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        TextFragment textFragment2 = textFragment;
        List list = (List)destination$iv$iv;
        TextClone filtered = new TextClone(textFragment2, list);
        if (filtered.getDuplicates().isEmpty()) {
            return null;
        }
        TextFragment alignedMain = this.alignBraces(project, filtered.getMain());
        if (Intrinsics.areEqual((Object)filtered.getMain(), (Object)alignedMain)) {
            return filtered;
        }
        Iterable $this$map$iv = filtered.getDuplicates();
        boolean $i$f$map = false;
        Iterable $i$f$filterTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextFragment textFragment3 = (TextFragment)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(this.alignBraces(project, (TextFragment)it));
        }
        List alignedDuplicates = (List)destination$iv$iv2;
        return new TextClone(alignedMain, alignedDuplicates);
    }

    protected boolean isDuplicateFileAcceptable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    private final TextFragment alignBraces(Project project, TextFragment fragment) {
        TextFragment textFragment;
        Object v3;
        PsiElement classElement;
        PsiElement firstDuplicateElement;
        block6: {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(fragment.getFile());
            if (psiFile == null) {
                return fragment;
            }
            PsiFile file = psiFile;
            PsiElement psiElement = file.findElementAt(fragment.getRange().getStartOffset());
            if (psiElement == null) {
                return fragment;
            }
            firstDuplicateElement = psiElement;
            PsiElement psiElement2 = classElement = PsiTreeUtil.findFirstParent((PsiElement)firstDuplicateElement, arg_0 -> JSBaseDuplicateScope.alignBraces$lambda$5(JSBaseDuplicateScope::alignBraces$lambda$4, arg_0));
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)(psiElement2 != null ? psiElement2.getFirstChild() : null), JSBaseDuplicateScope::alignBraces$lambda$6);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!it.getTextRange().isEmpty())) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        PsiElement firstClassElement = v3;
        if (firstClassElement == null) {
            return fragment;
        }
        if (firstClassElement.getTextRange().contains(firstDuplicateElement.getTextRange())) {
            VirtualFile virtualFile = fragment.getFile();
            PsiElement psiElement = classElement;
            Intrinsics.checkNotNull((Object)psiElement);
            TextRange textRange = psiElement.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            textFragment = new TextFragment(virtualFile, textRange);
        } else {
            textFragment = fragment;
        }
        return textFragment;
    }

    private final boolean hasExportAttribute(LighterAST ast, LighterASTNode node) {
        LighterASTNode attributeList = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (IElementType)((IElementType)JSStubElementTypes.ATTRIBUTE_LIST));
        return LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)attributeList, (IElementType)JSTokenTypes.EXPORT_KEYWORD) != null;
    }

    private static final TokenSet noiseTokens_delegate$lambda$0() {
        TokenSet[] tokenSetArray = new TokenSet[2];
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.SEMICOLON};
        tokenSetArray[0] = TokenSet.create((IElementType[])iElementTypeArray);
        tokenSetArray[1] = JSTokenTypes.COMMENTS_AND_WHITESPACES;
        return TokenSet.orSet((TokenSet[])tokenSetArray);
    }

    private static final boolean alignBraces$lambda$4(PsiElement it) {
        PsiElement psiElement = it;
        return Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)ActionScriptStubElementTypes.ACTIONSCRIPT_CLASS);
    }

    private static final boolean alignBraces$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PsiElement alignBraces$lambda$6(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNextSibling();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ElementType.values().length];
            try {
                nArray[ElementType.Identifier.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.Literal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.Function.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.Field.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.Classname.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.GlobalVariable.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

