/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.exception;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class ContinueOrBreakFromFinallyBlockJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("continue.or.break.inside.finally.block.error.string", new Object[0]);
        if (string == null) {
            ContinueOrBreakFromFinallyBlockJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/exception/ContinueOrBreakFromFinallyBlockJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSContinueStatement(@NotNull JSContinueStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSContinueStatement(statement);
            if (!ControlFlowUtils.isInFinallyBlock(statement)) {
                return;
            }
            JSStatement continuedStatement = statement.getStatementToContinue();
            if (continuedStatement == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(continuedStatement)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        @Override
        public void visitJSBreakStatement(@NotNull JSBreakStatement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitJSBreakStatement(statement);
            if (!ControlFlowUtils.isInFinallyBlock(statement)) {
                return;
            }
            JSStatement exitedStatement = statement.getStatementToBreak();
            if (exitedStatement == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(exitedStatement)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/sixrr/inspectjs/exception/ContinueOrBreakFromFinallyBlockJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSContinueStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBreakStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

