/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConverterSupport;
import com.intellij.database.data.types.PointSet;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataConverter<V, T> {
    private final PointSet<V> myStart;
    private final PointSet<T> myEnd;

    protected DataConverter(@NotNull PointSet<V> start, @NotNull PointSet<T> end) {
        if (start == null) {
            DataConverter.$$$reportNull$$$0(0);
        }
        if (end == null) {
            DataConverter.$$$reportNull$$$0(1);
        }
        this.myStart = start;
        this.myEnd = end;
    }

    @Nullable
    public final T convert(@Nullable V value) {
        return value == null ? null : (T)this.notNull(value);
    }

    @Nullable
    public final V convertReverse(@Nullable T value) {
        return value == null ? null : (V)this.reverseNotNull(value);
    }

    @Nullable
    protected abstract V reverseNotNull(@NotNull T var1);

    @Nullable
    protected abstract T notNull(@NotNull V var1);

    @NotNull
    public PointSet<V> getStart() {
        PointSet<V> pointSet = this.myStart;
        if (pointSet == null) {
            DataConverter.$$$reportNull$$$0(2);
        }
        return pointSet;
    }

    @NotNull
    public PointSet<T> getEnd() {
        PointSet<T> pointSet = this.myEnd;
        if (pointSet == null) {
            DataConverter.$$$reportNull$$$0(3);
        }
        return pointSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/DataConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/DataConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStart";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class UuidToText
    extends DataConverter<UUID, String> {
        protected UuidToText() {
            super(PointSet.UUID, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected UUID reverseNotNull(@NotNull String value) {
            if (value == null) {
                UuidToText.$$$reportNull$$$0(0);
            }
            try {
                return UUID.fromString(value);
            }
            catch (Exception exception) {
                return UUID.randomUUID();
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull UUID value) {
            if (value == null) {
                UuidToText.$$$reportNull$$$0(1);
            }
            return value.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$UuidToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class StringUuidToText
    extends DataConverter<String, String> {
        protected StringUuidToText() {
            super(PointSet.UUID_TEXT, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                StringUuidToText.$$$reportNull$$$0(0);
            }
            try {
                return UUID.fromString(value).toString();
            }
            catch (Exception exception) {
                return UUID.randomUUID().toString();
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                StringUuidToText.$$$reportNull$$$0(1);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$StringUuidToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ObjectToText
    extends DataConverter<Object, String> {
        @NotNull
        private final Supplier<ObjectFormatter> myObjectFormatter;

        protected ObjectToText(@NotNull Supplier<ObjectFormatter> objectFormatter) {
            if (objectFormatter == null) {
                ObjectToText.$$$reportNull$$$0(0);
            }
            super(PointSet.UNKNOWN, PointSet.TEXT);
            this.myObjectFormatter = objectFormatter;
        }

        @Override
        @Nullable
        protected Object reverseNotNull(@NotNull String value) {
            if (value == null) {
                ObjectToText.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Object value) {
            if (value == null) {
                ObjectToText.$$$reportNull$$$0(2);
            }
            return value instanceof ContextDescriptor ? ObjectToText.convertToString((ContextDescriptor)value, this.myObjectFormatter.get()) : (value instanceof String ? (String)value : null);
        }

        @Nullable
        private static String convertToString(@NotNull ContextDescriptor cd, @NotNull ObjectFormatter objectFormatter) {
            if (cd == null) {
                ObjectToText.$$$reportNull$$$0(3);
            }
            if (objectFormatter == null) {
                ObjectToText.$$$reportNull$$$0(4);
            }
            GridColumn column = ObjectToText.getColumn(cd.myDescriptor);
            return objectFormatter.objectToString(cd.myValue, column, new DatabaseObjectFormatterConfig(ObjectFormatterMode.DEFAULT));
        }

        @NotNull
        public static Function<Object, Object> tweak(@NotNull Function<Object, Object> function, @NotNull ColumnDescriptor descriptor) {
            if (function == null) {
                ObjectToText.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                ObjectToText.$$$reportNull$$$0(6);
            }
            Function function2 = o -> function.fun((Object)new ContextDescriptor(descriptor, o));
            if (function2 == null) {
                ObjectToText.$$$reportNull$$$0(7);
            }
            return function2;
        }

        @Nullable
        private static GridColumn getColumn(@NotNull ColumnDescriptor cd) {
            GridColumn gridColumn;
            if (cd == null) {
                ObjectToText.$$$reportNull$$$0(8);
            }
            if (cd instanceof DataConsumer.Column) {
                DataConsumer.Column c;
                gridColumn = c = (DataConsumer.Column)cd;
            } else if (cd instanceof AutoValueDescriptor.DelegateDescriptor) {
                AutoValueDescriptor.DelegateDescriptor dd = (AutoValueDescriptor.DelegateDescriptor)cd;
                gridColumn = ObjectToText.getColumn(dd.getDelegate());
            } else if (cd instanceof GridColumn) {
                GridColumn gc = (GridColumn)cd;
                gridColumn = gc;
            } else {
                gridColumn = null;
            }
            return gridColumn;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectFormatter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cd";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DataConverter$ObjectToText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DataConverter$ObjectToText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tweak";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reverseNotNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "notNull";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToString";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "tweak";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }

        private static class ContextDescriptor {
            private final ColumnDescriptor myDescriptor;
            private final Object myValue;

            ContextDescriptor(@NotNull ColumnDescriptor descriptor, Object value) {
                if (descriptor == null) {
                    ContextDescriptor.$$$reportNull$$$0(0);
                }
                this.myDescriptor = descriptor;
                this.myValue = value;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/DataConverter$ObjectToText$ContextDescriptor", "<init>"));
            }
        }
    }

    public static class MapToText
    extends DataConverter<Map, String> {
        @NotNull
        private final Supplier<ObjectFormatter> myObjectFormatter;

        protected MapToText(@NotNull Supplier<ObjectFormatter> objectFormatter) {
            if (objectFormatter == null) {
                MapToText.$$$reportNull$$$0(0);
            }
            super(PointSet.MAP, PointSet.TEXT);
            this.myObjectFormatter = objectFormatter;
        }

        @Override
        @Nullable
        protected Map reverseNotNull(@NotNull String value) {
            if (value == null) {
                MapToText.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Map value) {
            if (value == null) {
                MapToText.$$$reportNull$$$0(2);
            }
            return JsonUtilKt.toJson(value, this.myObjectFormatter.get(), ObjectFormatterMode.JSON, false, false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectFormatter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$MapToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TemporalTimeToTemporalTimestamp
    extends DataConverter<TemporalAccessor, TemporalAccessor> {
        public TemporalTimeToTemporalTimestamp() {
            super(PointSet.TEMPORAL_TIME, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TemporalTimeToTemporalTimestamp.$$$reportNull$$$0(0);
            }
            return data instanceof OffsetTime ? ((OffsetTime)data).atDate(DataGridFormattersUtilCore.START_DATE) : ((LocalTime)data).atOffset(DataGridFormattersUtilCore.getLocalTimeOffset()).atDate(DataGridFormattersUtilCore.START_DATE).atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TemporalTimeToTemporalTimestamp.$$$reportNull$$$0(1);
            }
            return data instanceof OffsetDateTime ? ((OffsetDateTime)data).toOffsetTime() : ((LocalDateTime)data).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(DataGridFormattersUtilCore.getLocalTimeOffset()).toLocalTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TemporalTimeToTemporalTimestamp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeToText
    extends DataConverter<TemporalAccessor, String> {
        private final Formatter myFormatter;

        public TimeToText(@NotNull FormatterCreator formatterCreator) {
            if (formatterCreator == null) {
                TimeToText.$$$reportNull$$$0(0);
            }
            super(PointSet.TEMPORAL_TIME, PointSet.TEXT);
            this.myFormatter = ConverterSupport.getTimeFormatter(formatterCreator);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TimeToText.$$$reportNull$$$0(1);
            }
            return this.myFormatter.format(data);
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull String data) {
            if (data == null) {
                TimeToText.$$$reportNull$$$0(2);
            }
            try {
                return (TemporalAccessor)this.myFormatter.parse(data);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimeToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeToNumber
    extends DataConverter<TemporalAccessor, Number> {
        public TimeToNumber() {
            super(PointSet.TEMPORAL_TIME, PointSet.NUMBER);
        }

        @Override
        @Nullable
        protected Number notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TimeToNumber.$$$reportNull$$$0(0);
            }
            LocalTime from = LocalTime.from(data);
            return Time.valueOf(from).getTime();
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull Number data) {
            if (data == null) {
                TimeToNumber.$$$reportNull$$$0(1);
            }
            return new Time(data.longValue()).toLocalTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimeToNumber";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimestampToText
    extends DataConverter<TemporalAccessor, String> {
        private final Formatter myFormatter;

        public TimestampToText(@NotNull FormatterCreator formatterCreator) {
            if (formatterCreator == null) {
                TimestampToText.$$$reportNull$$$0(0);
            }
            super(PointSet.TEMPORAL_TIMESTAMP, PointSet.TEXT);
            this.myFormatter = ConverterSupport.createTimestampFormatter(formatterCreator);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TimestampToText.$$$reportNull$$$0(1);
            }
            return this.myFormatter.format(data);
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull String data) {
            if (data == null) {
                TimestampToText.$$$reportNull$$$0(2);
            }
            try {
                return (TemporalAccessor)this.myFormatter.parse(data);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimestampToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimestampToTemporal
    extends DataConverter<Timestamp, TemporalAccessor> {
        private final FormatsCache myFormatsCache;
        private final FormatterCreator myFormatterCreator;

        public TimestampToTemporal(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
            if (formatsCache == null) {
                TimestampToTemporal.$$$reportNull$$$0(0);
            }
            if (formatterCreator == null) {
                TimestampToTemporal.$$$reportNull$$$0(1);
            }
            super(PointSet.TIMESTAMP, PointSet.TEMPORAL_TIMESTAMP);
            this.myFormatsCache = formatsCache;
            this.myFormatterCreator = formatterCreator;
        }

        @Override
        @Nullable
        protected Timestamp reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimestampToTemporal.$$$reportNull$$$0(2);
            }
            return value instanceof OffsetDateTime ? DataGridFormattersUtilCore.fromOffsetDateTime((OffsetDateTime)value, this.myFormatsCache, this.myFormatterCreator, null) : Timestamp.valueOf((LocalDateTime)value);
        }

        @Override
        @Nullable
        public TemporalAccessor notNull(@NotNull Timestamp value) {
            if (value == null) {
                TimestampToTemporal.$$$reportNull$$$0(3);
            }
            return value.toLocalDateTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatsCache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimestampToTemporal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeToTemporal
    extends DataConverter<Time, TemporalAccessor> {
        public TimeToTemporal() {
            super(PointSet.TIME, PointSet.TEMPORAL_TIME);
        }

        @Override
        @Nullable
        protected Time reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimeToTemporal.$$$reportNull$$$0(0);
            }
            return Time.valueOf(value instanceof OffsetTime ? ((OffsetTime)value).withOffsetSameInstant(DataGridFormattersUtilCore.getLocalTimeOffset()).toLocalTime() : (LocalTime)value);
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull Time value) {
            if (value == null) {
                TimeToTemporal.$$$reportNull$$$0(1);
            }
            return value.toLocalTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimeToTemporal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NumberToTimestamp
    extends DataConverter<Number, TemporalAccessor> {
        public NumberToTimestamp() {
            super(PointSet.NUMBER, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull Number data) {
            if (data == null) {
                NumberToTimestamp.$$$reportNull$$$0(0);
            }
            long l = data.longValue();
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneId.systemDefault());
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                NumberToTimestamp.$$$reportNull$$$0(1);
            }
            return data instanceof LocalDateTime ? Timestamp.valueOf((LocalDateTime)data).getTime() : Timestamp.valueOf(((OffsetDateTime)data).toLocalDateTime()).getTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$NumberToTimestamp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MoneyToText
    extends DataConverter<Number, String> {
        private static final NumberFormat FORMAT = NumberFormat.getNumberInstance(Locale.US);

        public MoneyToText() {
            super(PointSet.MONEY, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull String value) {
            if (value == null) {
                MoneyToText.$$$reportNull$$$0(0);
            }
            if (value.isEmpty()) {
                return null;
            }
            try {
                return FORMAT.parse(value);
            }
            catch (Exception exception) {
                return MoneyToText.parseCurrency(value);
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Number value) {
            if (value == null) {
                MoneyToText.$$$reportNull$$$0(1);
            }
            return value.toString();
        }

        @Nullable
        private static Number parseCurrency(@NotNull String value) {
            if (value == null) {
                MoneyToText.$$$reportNull$$$0(2);
            }
            try {
                return FORMAT.parse(value.substring(1));
            }
            catch (Exception exception) {
                return null;
            }
        }

        static {
            if (FORMAT instanceof DecimalFormat) {
                ((DecimalFormat)FORMAT).setParseBigDecimal(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$MoneyToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseCurrency";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NumberToText
    extends DataConverter<Number, String> {
        public NumberToText() {
            super(PointSet.NUMBER, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Number data) {
            if (data == null) {
                NumberToText.$$$reportNull$$$0(0);
            }
            return data.toString();
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull String data) {
            if (data == null) {
                NumberToText.$$$reportNull$$$0(1);
            }
            try {
                return StringUtil.equalsIgnoreCase((CharSequence)"true", (CharSequence)data) ? 1L : (StringUtil.equalsIgnoreCase((CharSequence)"false", (CharSequence)data) ? 0L : Long.parseLong(data));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(data);
                }
                catch (NumberFormatException numberFormatException2) {
                    return null;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$NumberToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DateToTimestamp
    extends DataConverter<java.util.Date, TemporalAccessor> {
        public DateToTimestamp() {
            super(PointSet.DATE, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected java.util.Date reverseNotNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                DateToTimestamp.$$$reportNull$$$0(0);
            }
            return Date.valueOf(LocalDate.from(data));
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull java.util.Date data) {
            if (data == null) {
                DateToTimestamp.$$$reportNull$$$0(1);
            }
            return data instanceof Date ? ((Date)data).toLocalDate().atStartOfDay().atOffset(ZoneOffset.UTC).atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime() : LocalDateTime.ofInstant(Instant.ofEpochMilli(data.getTime()), ZoneId.systemDefault());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$DateToTimestamp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DateToText
    extends DataConverter<java.util.Date, String> {
        private final Formatter myFormatter;

        public DateToText(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
            if (formatsCache == null) {
                DateToText.$$$reportNull$$$0(0);
            }
            if (formatterCreator == null) {
                DateToText.$$$reportNull$$$0(1);
            }
            super(PointSet.DATE, PointSet.TEXT);
            this.myFormatter = ConverterSupport.getDateFormatter(formatsCache, formatterCreator);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull java.util.Date data) {
            if (data == null) {
                DateToText.$$$reportNull$$$0(2);
            }
            return this.myFormatter.format(data);
        }

        @Override
        @Nullable
        protected java.util.Date reverseNotNull(@NotNull String data) {
            if (data == null) {
                DateToText.$$$reportNull$$$0(3);
            }
            try {
                return (java.util.Date)this.myFormatter.parse(data);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatsCache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$DateToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DateToNumber
    extends DataConverter<java.util.Date, Number> {
        public DateToNumber() {
            super(PointSet.DATE, PointSet.NUMBER);
        }

        @Override
        @Nullable
        protected Number notNull(@NotNull java.util.Date data) {
            if (data == null) {
                DateToNumber.$$$reportNull$$$0(0);
            }
            return data.getTime();
        }

        @Override
        @Nullable
        protected java.util.Date reverseNotNull(@NotNull Number data) {
            if (data == null) {
                DateToNumber.$$$reportNull$$$0(1);
            }
            return new java.util.Date(data.longValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$DateToNumber";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BooleanNumberToText
    extends DataConverter<Number, String> {
        public BooleanNumberToText() {
            super(PointSet.BOOLEAN_NUMBER, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Number data) {
            if (data == null) {
                BooleanNumberToText.$$$reportNull$$$0(0);
            }
            return data instanceof Integer ? ((Integer)data == 0 ? "false" : "true") : (data instanceof Double ? (Double.compare((Double)data, 0.0) == 0 ? "false" : "true") : "false");
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull String data) {
            if (data == null) {
                BooleanNumberToText.$$$reportNull$$$0(1);
            }
            return StringUtil.equalsIgnoreCase((CharSequence)data, (CharSequence)"false") || StringUtil.equalsIgnoreCase((CharSequence)data, (CharSequence)"0") || StringUtil.isEmptyOrSpaces((String)data) ? 0 : 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BooleanNumberToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BooleanToText
    extends DataConverter<Boolean, String> {
        public BooleanToText() {
            super(PointSet.BOOLEAN, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Boolean data) {
            if (data == null) {
                BooleanToText.$$$reportNull$$$0(0);
            }
            return String.valueOf(data);
        }

        @Override
        @Nullable
        protected Boolean reverseNotNull(@NotNull String data) {
            if (data == null) {
                BooleanToText.$$$reportNull$$$0(1);
            }
            return StringUtil.findIgnoreCase((String)StringUtil.trim((String)data), (String[])new String[]{"yes", "true", "1"});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BooleanToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BooleanToNumber
    extends DataConverter<Boolean, Number> {
        public BooleanToNumber() {
            super(PointSet.BOOLEAN, PointSet.NUMBER);
        }

        @Override
        @Nullable
        protected Number notNull(@NotNull Boolean data) {
            if (data == null) {
                BooleanToNumber.$$$reportNull$$$0(0);
            }
            return data != false ? 1 : 0;
        }

        @Override
        @Nullable
        protected Boolean reverseNotNull(@NotNull Number data) {
            if (data == null) {
                BooleanToNumber.$$$reportNull$$$0(1);
            }
            return Double.compare(data.doubleValue(), 1.0) >= 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BooleanToNumber";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BooleanToBinary
    extends DataConverter<Boolean, byte[]> {
        public BooleanToBinary() {
            super(PointSet.BOOLEAN, PointSet.BINARY);
        }

        @Override
        protected byte @Nullable [] notNull(@NotNull Boolean data) {
            if (data == null) {
                BooleanToBinary.$$$reportNull$$$0(0);
            }
            return new byte[]{data != false ? (byte)1 : 0};
        }

        @Override
        @Nullable
        protected Boolean reverseNotNull(byte @NotNull [] bytes) {
            if (bytes == null) {
                BooleanToBinary.$$$reportNull$$$0(1);
            }
            return bytes[0] == 0 ? Boolean.FALSE : Boolean.TRUE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BooleanToBinary";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BinaryToText
    extends DataConverter<byte[], String> {
        public BinaryToText() {
            super(PointSet.BINARY, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(byte @NotNull [] data) {
            TextInfo info;
            if (data == null) {
                BinaryToText.$$$reportNull$$$0(0);
            }
            return (info = TextInfo.tryDetectString(data)) == null ? StringUtil.toHexString((byte[])data) : info.text;
        }

        @Override
        protected byte @Nullable [] reverseNotNull(@NotNull String data) {
            if (data == null) {
                BinaryToText.$$$reportNull$$$0(1);
            }
            return data.getBytes(StandardCharsets.UTF_8);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BinaryToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BinaryTextToText
    extends DataConverter<String, String> {
        public BinaryTextToText() {
            super(PointSet.BINARY_STRING, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String text) {
            if (text == null) {
                BinaryTextToText.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            char[] cArray = text.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                int aChar;
                int intValue = aChar = cArray[i];
                for (int i2 = 0; i2 < 8; ++i2) {
                    sb.append((intValue & 0x80) == 0 ? 0 : 1);
                    intValue <<= 1;
                }
            }
            return sb.toString();
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            List<String> strings;
            if (value == null) {
                BinaryTextToText.$$$reportNull$$$0(1);
            }
            if ((strings = BinaryTextToText.split(value)).isEmpty()) {
                return value;
            }
            try {
                StringBuilder sb = new StringBuilder();
                for (String string : strings) {
                    sb.append((char)Integer.parseInt(string, 2));
                }
                return sb.toString();
            }
            catch (Exception exception) {
                return value;
            }
        }

        @NotNull
        private static List<String> split(@NotNull String s) {
            if (s == null) {
                BinaryTextToText.$$$reportNull$$$0(2);
            }
            ArrayList<String> strings = new ArrayList<String>();
            for (int currentIdx = 0; currentIdx < s.length(); currentIdx += 8) {
                String substring = s.substring(currentIdx, Math.min(s.length(), currentIdx + 8));
                strings.add(substring);
            }
            ArrayList<String> arrayList = strings;
            if (arrayList == null) {
                BinaryTextToText.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DataConverter$BinaryTextToText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DataConverter$BinaryTextToText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "split";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "notNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "split";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class BitStringToText
    extends DataConverter<String, String> {
        public BitStringToText() {
            super(PointSet.BIT_STRING, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                BitStringToText.$$$reportNull$$$0(0);
            }
            return value;
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                BitStringToText.$$$reportNull$$$0(1);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BitStringToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

