/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/StatusDiffRequestProducer;", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "message", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;)V", "getName", "getFilePath", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "process", "Lcom/intellij/diff/requests/DiffRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.vcs.impl"})
final class StatusDiffRequestProducer
implements ChangeDiffRequestChain.Producer {
    @NotNull
    private final FilePath filePath;
    @NotNull
    private final String message;

    public StatusDiffRequestProducer(@NotNull FilePath filePath, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.filePath = filePath;
        this.message = message;
    }

    @NotNull
    public String getName() {
        String string = this.filePath.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        return this.filePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = FileStatus.MERGED_WITH_CONFLICTS;
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"MERGED_WITH_CONFLICTS");
        return fileStatus;
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return (DiffRequest)new MessageDiffRequest(this.message);
    }
}

