/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.merge.MergeConflictsTreeTable;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vcs.merge.MergeSessionEx;
import com.intellij.openapi.vcs.merge.MergeUtils;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.treeStructure.treetable.DefaultTreeTableExpander;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00bb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t*\u0001'\b\u0016\u0018\u0000 V2\u00020\u0001:\u0007UVWXYZ[B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010)\u001a\u00020*H\u0014J\u001b\u0010+\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-0,H\u0002\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020 H\u0002J\u001c\u00102\u001a\u000200\"\u0004\b\u0000\u001032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H305H\u0002J\b\u00106\u001a\u000200H\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0013\u00108\u001a\b\u0012\u0004\u0012\u0002090,H\u0014\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u000200H\u0014J\b\u0010<\u001a\u00020=H\u0015J\u0016\u0010>\u001a\u00020 2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060?H\u0015J\u0010\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020BH\u0002J \u0010C\u001a\u0002002\u0006\u0010D\u001a\u00020\u00062\u0006\u0010A\u001a\u00020B2\u0006\u0010E\u001a\u00020FH\u0003J\u001e\u0010G\u001a\u0002002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010H\u001a\u0002002\u0006\u0010D\u001a\u00020\u00062\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010I\u001a\u000200H\u0002J\b\u0010J\u001a\u000200H\u0002J\u0010\u0010K\u001a\u00020B2\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u0002002\u0006\u0010D\u001a\u00020\u0006H\u0002J\n\u0010O\u001a\u0004\u0018\u00010*H\u0016J#\u0010P\u001a\u0004\u0018\u0001HQ\"\u0004\b\u0000\u0010Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HQ0SH\u0002\u00a2\u0006\u0002\u0010TR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(\u00a8\u0006\\"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "mergeProvider", "Lcom/intellij/openapi/vcs/merge/MergeProvider;", "mergeDialogCustomizer", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vcs/merge/MergeProvider;Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;)V", "unresolvedFiles", "", "mergeSession", "Lcom/intellij/openapi/vcs/merge/MergeSession;", "Lorg/jetbrains/annotations/NotNull;", "processedFiles", "getProcessedFiles", "()Ljava/util/List;", "table", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "acceptYoursButton", "Ljavax/swing/JButton;", "acceptTheirsButton", "mergeButton", "tableModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "descriptionLabel", "Ljavax/swing/JLabel;", "value", "", "groupByDirectory", "getGroupByDirectory", "()Z", "setGroupByDirectory", "(Z)V", "virtualFileRenderer", "com/intellij/openapi/vcs/merge/MultipleFileMergeDialog$virtualFileRenderer$1", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$virtualFileRenderer$1;", "createCenterPanel", "Ljavax/swing/JComponent;", "createColumns", "", "Lcom/intellij/util/ui/ColumnInfo;", "()[Lcom/intellij/util/ui/ColumnInfo;", "toggleGroupByDirectory", "", "state", "updateTree", "State", "treeStateStrategy", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$TreeTableStateStrategy;", "updateButtonState", "getSelectedFiles", "createActions", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "dispose", "getDimensionServiceKey", "", "beforeResolve", "", "acceptRevision", "resolution", "Lcom/intellij/openapi/vcs/merge/MergeSession$Resolution;", "resolveFileViaContent", "file", "data", "Lcom/intellij/openapi/vcs/merge/MergeData;", "markFilesProcessed", "markFileProcessed", "updateModelFromFiles", "showMergeDialog", "getSessionResolution", "result", "Lcom/intellij/diff/merge/MergeResult;", "checkMarkModifiedProject", "getPreferredFocusedComponent", "tryCompute", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ColumnInfoAdapter", "Companion", "ConflictData", "TreeTableStateStrategy", "SetDefaultTreeStateStrategy", "OnGroupingChangeTreeStateStrategy", "OnModelChangeTreeStateStrategy", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nMultipleFileMergeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipleFileMergeDialog.kt\ncom/intellij/openapi/vcs/merge/MultipleFileMergeDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,568:1\n1#2:569\n11359#3,4:570\n37#4:574\n36#4,3:575\n1755#5,3:578\n1755#5,3:581\n1863#5,2:584\n1863#5,2:586\n*S KotlinDebug\n*F\n+ 1 MultipleFileMergeDialog.kt\ncom/intellij/openapi/vcs/merge/MultipleFileMergeDialog\n*L\n210#1:570,4\n214#1:574\n214#1:575,3\n250#1:578,3\n251#1:581,3\n356#1:584,2\n361#1:586,2\n*E\n"})
public class MultipleFileMergeDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final MergeProvider mergeProvider;
    @NotNull
    private final MergeDialogCustomizer mergeDialogCustomizer;
    @NotNull
    private List<VirtualFile> unresolvedFiles;
    @Nullable
    private final MergeSession mergeSession;
    @NotNull
    private final List<VirtualFile> processedFiles;
    @NotNull
    private final TreeTable table;
    private JButton acceptYoursButton;
    private JButton acceptTheirsButton;
    private JButton mergeButton;
    @NotNull
    private final ListTreeTableModelOnColumns tableModel;
    private JLabel descriptionLabel;
    private boolean groupByDirectory;
    @NotNull
    private final virtualFileRenderer.1 virtualFileRenderer;
    @NotNull
    private static final Logger LOG;

    public MultipleFileMergeDialog(@Nullable Project project, @NotNull List<? extends VirtualFile> files, @NotNull MergeProvider mergeProvider, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)mergeProvider, (String)"mergeProvider");
        Intrinsics.checkNotNullParameter((Object)mergeDialogCustomizer, (String)"mergeDialogCustomizer");
        super(project);
        this.project = project;
        this.mergeProvider = mergeProvider;
        this.mergeDialogCustomizer = mergeDialogCustomizer;
        this.unresolvedFiles = CollectionsKt.toMutableList((Collection)files);
        MergeProvider mergeProvider2 = this.mergeProvider;
        MergeProvider2 mergeProvider22 = mergeProvider2 instanceof MergeProvider2 ? (MergeProvider2)mergeProvider2 : null;
        this.mergeSession = mergeProvider22 != null ? mergeProvider22.createMergeSession(files) : null;
        this.processedFiles = new ArrayList();
        this.tableModel = new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode(), this.createColumns());
        Project project2 = this.project;
        mergeProvider2 = () -> MultipleFileMergeDialog.virtualFileRenderer$lambda$0(this);
        this.virtualFileRenderer = new ChangesBrowserNodeRenderer(this, project2, (BooleanGetter)mergeProvider2){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, false);
            }

            protected boolean calcFocusedState() {
                return UIUtil.isAncestor((Component)this.this$0.getPeer().getWindow(), (Component)IdeFocusManager.getInstance((Project)this.getProject()).getFocusOwner());
            }
        };
        Project project3 = this.project;
        if (project3 != null) {
            Project it = project3;
            boolean bl = false;
            StoreReloadManager.Companion.getInstance(this.project).blockReloadingProjectOnExternalChanges();
        }
        this.setTitle(this.mergeDialogCustomizer.getMultipleFileDialogTitle());
        this.virtualFileRenderer.setFont(UIUtil.getListFont());
        this.table = new MergeConflictsTreeTable(this.tableModel);
        this.table.setTreeCellRenderer((TreeCellRenderer)((Object)this.virtualFileRenderer));
        ((MergeConflictsTreeTable)this.table).setRowHeight(this.virtualFileRenderer.getPreferredSize().height);
        ((MergeConflictsTreeTable)this.table).setPreferredScrollableViewportSize((Dimension)JBUI.size((int)600, (int)300));
        DataManager.registerDataProvider((JComponent)((JComponent)this.table), arg_0 -> MultipleFileMergeDialog._init_$lambda$2(this, arg_0));
        this.init();
        this.updateTree(new SetDefaultTreeStateStrategy());
        ((MergeConflictsTreeTable)this.table).getTree().getSelectionModel().addTreeSelectionListener(arg_0 -> MultipleFileMergeDialog._init_$lambda$3(this, arg_0));
        this.updateButtonState();
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreeTableTree treeTableTree = ((MergeConflictsTreeTable)table).getTree();
                Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)treeTableTree), (MouseEvent)event)) {
                    return false;
                }
                this.showMergeDialog();
                return true;
            }
        }.installOn((Component)((MergeConflictsTreeTable)this.table).getTree());
        TableSpeedSearch.installOn((JTable)((JTable)this.table), MultipleFileMergeDialog::_init_$lambda$4);
        JLabel jLabel = this.descriptionLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"descriptionLabel");
            jLabel = null;
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)jLabel);
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        ModalityState modalityState2 = modalityState;
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.getDisposable(), () -> MultipleFileMergeDialog._init_$lambda$6(this, modalityState2));
    }

    @NotNull
    public final List<VirtualFile> getProcessedFiles() {
        return this.processedFiles;
    }

    private final boolean getGroupByDirectory() {
        return this.project != null ? VcsConfiguration.getInstance((Project)this.project).GROUP_MULTIFILE_MERGE_BY_DIRECTORY : this.groupByDirectory;
    }

    private final void setGroupByDirectory(boolean value) {
        if (this.project != null) {
            VcsConfiguration.getInstance((Project)this.project).GROUP_MULTIFILE_MERGE_BY_DIRECTORY = value;
        } else {
            this.groupByDirectory = value;
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel it = dialogPanel = BuilderKt.panel(arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18(this, arg_0));
        boolean bl = false;
        it.setMinimumSize((Dimension)JBUI.size((int)200, (int)150));
        return (JComponent)dialogPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final ColumnInfo<?, ?>[] createColumns() {
        ColumnInfo[] mergeInfoColumns;
        ArrayList<createColumns.1> columns = new ArrayList<createColumns.1>();
        String string = VcsBundle.message((String)"multiple.file.merge.column.name", (Object[])new Object[0]);
        columns.add(new ColumnInfo<DefaultMutableTreeNode, Object>(string){

            public Object valueOf(DefaultMutableTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return node.getUserObject();
            }

            public Class<?> getColumnClass() {
                return TreeTableModel.class;
            }
        });
        MergeSession mergeSession = this.mergeSession;
        Object object = mergeInfoColumns = mergeSession != null ? mergeSession.getMergeInfoColumns() : null;
        if (mergeInfoColumns != null) {
            List customColumnNames = null;
            customColumnNames = this.mergeDialogCustomizer.getColumnNames();
            if (customColumnNames != null && customColumnNames.size() != mergeInfoColumns.length) {
                LOG.error("Custom column names (" + customColumnNames + ") don't match default columns (" + mergeInfoColumns + ")");
                customColumnNames = null;
            }
            ColumnInfo[] $this$mapIndexedTo$iv = mergeInfoColumns;
            boolean $i$f$mapIndexedTo = false;
            int index$iv = 0;
            for (ColumnInfo item$iv : $this$mapIndexedTo$iv) {
                void index;
                void columnInfo;
                int n = index$iv++;
                ColumnInfo columnInfo2 = item$iv;
                int n2 = n;
                Collection collection = columns;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)columnInfo);
                Object object2 = customColumnNames;
                if (object2 == null || (object2 = (String)object2.get((int)index)) == null) {
                    object2 = columnInfo.getName();
                }
                Object object3 = object2;
                Intrinsics.checkNotNull((Object)object3);
                collection.add(new ColumnInfoAdapter((ColumnInfo<Object, Object>)columnInfo, (String)object3));
            }
        }
        Collection $this$toTypedArray$iv = columns;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ColumnInfo[0]);
    }

    private final void toggleGroupByDirectory(boolean state) {
        if (this.getGroupByDirectory() == state) {
            return;
        }
        this.setGroupByDirectory(state);
        this.updateTree(new OnGroupingChangeTreeStateStrategy());
    }

    private final <State> void updateTree(TreeTableStateStrategy<State> treeStateStrategy) {
        ChangesGroupingPolicyFactory factory = this.project != null && this.getGroupByDirectory() ? ChangesGroupingSupport.Companion.getFactory("directory") : (ChangesGroupingPolicyFactory)NoneChangesGroupingFactory.INSTANCE;
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromVirtualFiles(this.project, factory, (Collection<? extends VirtualFile>)this.unresolvedFiles);
        Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"buildFromVirtualFiles(...)");
        DefaultTreeModel model = defaultTreeModel;
        State savedState = treeStateStrategy.saveState(this.table);
        Object object = model.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.TreeNode");
        this.tableModel.setRoot((TreeNode)object);
        treeStateStrategy.restoreState(this.table, savedState);
        TableModel tableModel = this.table.getModel();
        AbstractTableModel abstractTableModel = tableModel instanceof AbstractTableModel ? (AbstractTableModel)tableModel : null;
        if (abstractTableModel != null) {
            abstractTableModel.fireTableDataChanged();
        }
        TableUtil.scrollSelectionToVisible((JTable)((JTable)this.table));
    }

    private final void updateButtonState() {
        JButton jButton;
        boolean haveUnacceptableFiles;
        boolean haveUnmergeableFiles;
        boolean haveSelection;
        block10: {
            boolean bl;
            List<VirtualFile> selectedFiles;
            block9: {
                selectedFiles = this.getSelectedFiles();
                haveSelection = CollectionsKt.any((Iterable)selectedFiles);
                Iterable $this$any$iv = selectedFiles;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        MergeSession mergeSession = this.mergeSession;
                        boolean bl3 = mergeSession != null ? !mergeSession.canMerge(it) : false;
                        if (!bl3) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            haveUnmergeableFiles = bl;
            Iterable $this$any$iv = selectedFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v3 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl4 = false;
                    if (!(this.mergeSession != null && !(this.mergeSession instanceof MergeSessionEx) && !this.mergeSession.canMerge(it))) continue;
                    v3 = true;
                    break block10;
                }
                v3 = haveUnacceptableFiles = false;
            }
        }
        if ((jButton = this.acceptYoursButton) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"acceptYoursButton");
            jButton = null;
        }
        jButton.setEnabled(haveSelection && !haveUnacceptableFiles);
        JButton jButton2 = this.acceptTheirsButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"acceptTheirsButton");
            jButton2 = null;
        }
        jButton2.setEnabled(haveSelection && !haveUnacceptableFiles);
        JButton jButton3 = this.mergeButton;
        if (jButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mergeButton");
            jButton3 = null;
        }
        jButton3.setEnabled(haveSelection && !haveUnmergeableFiles);
    }

    private final List<VirtualFile> getSelectedFiles() {
        List<VirtualFile> list = VcsTreeModelData.selected((JTree)this.table.getTree()).userObjects(VirtualFile.class);
        Intrinsics.checkNotNullExpressionValue(list, (String)"userObjects(...)");
        return list;
    }

    @NotNull
    protected Action[] createActions() {
        this.getCancelAction().putValue("Name", CommonBundle.getCloseButtonText());
        Action[] actionArray = new Action[]{this.getCancelAction()};
        return actionArray;
    }

    protected void dispose() {
        Project project = this.project;
        if (project != null) {
            Project it = project;
            boolean bl = false;
            StoreReloadManager.Companion.getInstance(this.project).unblockReloadingProjectOnExternalChanges();
        }
        super.dispose();
    }

    @NonNls
    @NotNull
    protected String getDimensionServiceKey() {
        return "MultipleFileMergeDialog";
    }

    @JvmSuppressWildcards
    protected boolean beforeResolve(@NotNull Collection<VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return true;
    }

    private final void acceptRevision(MergeSession.Resolution resolution) {
        boolean bl;
        boolean bl2 = bl = resolution == MergeSession.Resolution.AcceptedYours || resolution == MergeSession.Resolution.AcceptedTheirs;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VirtualFile> files = this.getSelectedFiles();
        Project project = this.project;
        String string = VcsBundle.message((String)"multiple.file.merge.dialog.progress.title.resolving.conflicts", (Object[])new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Modal(this, files, resolution, project, string){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            final /* synthetic */ List<VirtualFile> $files;
            final /* synthetic */ MergeSession.Resolution $resolution;
            {
                this.this$0 = $receiver;
                this.$files = $files;
                this.$resolution = $resolution;
                super($super_call_param$1, $super_call_param$2, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!this.this$0.beforeResolve((Collection<VirtualFile>)this.$files)) {
                    return;
                }
                try {
                    if (MultipleFileMergeDialog.access$getMergeSession$p(this.this$0) instanceof MergeSessionEx) {
                        ((MergeSessionEx)MultipleFileMergeDialog.access$getMergeSession$p(this.this$0)).acceptFilesRevisions(this.$files, this.$resolution);
                        for (VirtualFile file : this.$files) {
                            MultipleFileMergeDialog.access$checkMarkModifiedProject(this.this$0, file);
                        }
                        MultipleFileMergeDialog.access$markFilesProcessed(this.this$0, this.$files, this.$resolution);
                    } else {
                        for (VirtualFile file : this.$files) {
                            MergeData data;
                            Intrinsics.checkNotNullExpressionValue((Object)MultipleFileMergeDialog.access$getMergeProvider$p(this.this$0).loadRevisions(file), (String)"loadRevisions(...)");
                            ApplicationManager.getApplication().invokeAndWait(() -> acceptRevision.1.run$lambda$0(this.this$0, file, this.$resolution, data), indicator.getModalityState());
                            MultipleFileMergeDialog.access$checkMarkModifiedProject(this.this$0, file);
                            MultipleFileMergeDialog.access$markFileProcessed(this.this$0, file, this.$resolution);
                        }
                    }
                }
                catch (Exception e) {
                    MultipleFileMergeDialog.access$getLOG$cp().warn((Throwable)e);
                    ApplicationManager.getApplication().invokeAndWait(() -> acceptRevision.1.run$lambda$1(this.this$0, e), indicator.getModalityState());
                }
            }

            private static final void run$lambda$0(MultipleFileMergeDialog this$0, VirtualFile $file, MergeSession.Resolution $resolution, MergeData $data) {
                MultipleFileMergeDialog.access$resolveFileViaContent(this$0, $file, $resolution, $data);
            }

            private static final void run$lambda$1(MultipleFileMergeDialog this$0, Exception $e) {
                Object[] objectArray = new Object[]{$e.getMessage()};
                Messages.showErrorDialog((Component)this$0.getContentPanel(), (String)VcsBundle.message((String)"multiple.file.merge.dialog.message.error.saving.merged.data", (Object[])objectArray));
            }
        });
        this.updateModelFromFiles();
    }

    @RequiresEdt
    private final void resolveFileViaContent(VirtualFile file, MergeSession.Resolution resolution, MergeData data) {
        if (!DiffUtil.makeWritable((Project)this.project, (VirtualFile)file)) {
            Object[] objectArray = new Object[]{file.getPresentableUrl()};
            throw new IOException(UIBundle.message((String)"file.is.read.only.message.text", (Object[])objectArray));
        }
        boolean isCurrent = resolution == MergeSession.Resolution.AcceptedYours;
        String string = isCurrent ? VcsBundle.message((String)"multiple.file.merge.dialog.command.name.accept.yours", (Object[])new Object[0]) : VcsBundle.message((String)"multiple.file.merge.dialog.command.name.accept.theirs", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        String message = string;
        WriteCommandAction.writeCommandAction((Project)this.project).withName(message).run(() -> MultipleFileMergeDialog.resolveFileViaContent$lambda$24(isCurrent, file, data));
    }

    private final void markFilesProcessed(List<? extends VirtualFile> files, MergeSession.Resolution resolution) {
        this.unresolvedFiles.removeAll((Collection)files);
        if (this.mergeSession instanceof MergeSessionEx) {
            ((MergeSessionEx)this.mergeSession).conflictResolvedForFiles(files, resolution);
        } else if (this.mergeSession != null) {
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                this.mergeSession.conflictResolvedForFile(it, resolution);
            }
        } else {
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                this.mergeProvider.conflictResolvedForFile(it);
            }
        }
        this.processedFiles.addAll((Collection<VirtualFile>)files);
        if (this.project != null) {
            VcsDirtyScopeManager.getInstance((Project)this.project).filesDirty((Collection)files, (Collection)CollectionsKt.emptyList());
        }
    }

    private final void markFileProcessed(VirtualFile file, MergeSession.Resolution resolution) {
        this.markFilesProcessed(CollectionsKt.listOf((Object)file), resolution);
    }

    private final void updateModelFromFiles() {
        if (this.unresolvedFiles.isEmpty()) {
            this.doCancelAction();
        } else {
            this.updateTree(new OnModelChangeTreeStateStrategy());
            this.table.requestFocusInWindow();
        }
    }

    private final void showMergeDialog() {
        DiffRequestFactory diffRequestFactory = DiffRequestFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)diffRequestFactory, (String)"getInstance(...)");
        DiffRequestFactory requestFactory = diffRequestFactory;
        List<VirtualFile> files = this.getSelectedFiles();
        if (files.isEmpty()) {
            return;
        }
        if (!this.beforeResolve((Collection<VirtualFile>)files)) {
            return;
        }
        for (VirtualFile file : files) {
            Intrinsics.checkNotNullExpressionValue((Object)VcsUtil.getFilePath((VirtualFile)file), (String)"getFilePath(...)");
            ConflictData conflictData = null;
            try {
                FilePath filePath;
                conflictData = (ConflictData)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> MultipleFileMergeDialog.showMergeDialog$lambda$32(this, file, filePath), VcsBundle.message((String)"multiple.file.merge.dialog.progress.title.loading.revisions", (Object[])new Object[0]), true, this.project);
            }
            catch (VcsException ex) {
                Object[] objectArray = new Object[]{ex.getMessage()};
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)VcsBundle.message((String)"multiple.file.merge.dialog.error.loading.revisions.to.merge", (Object[])objectArray));
                break;
            }
            MergeData mergeData = conflictData.getMergeData();
            byte[][] byArrayArray = new byte[][]{mergeData.CURRENT, mergeData.ORIGINAL, mergeData.LAST};
            List byteContents = CollectionsKt.listOf((Object[])((Object[])byArrayArray));
            List<String> contentTitles = conflictData.getContentTitles();
            String title = conflictData.getTitle();
            Function1 callback = arg_0 -> MultipleFileMergeDialog.showMergeDialog$lambda$34(file, this, arg_0);
            MergeRequest request = null;
            try {
                request = this.mergeProvider.isBinary(file) ? requestFactory.createBinaryMergeRequest(this.project, file, byteContents, title, contentTitles, arg_0 -> MultipleFileMergeDialog.showMergeDialog$lambda$35(callback, arg_0)) : requestFactory.createMergeRequest(this.project, file, byteContents, mergeData.CONFLICT_TYPE, title, contentTitles, arg_0 -> MultipleFileMergeDialog.showMergeDialog$lambda$36(callback, arg_0));
                MergeUtils.putRevisionInfos(request, mergeData);
            }
            catch (InvalidDiffRequestException e) {
                if (e.getCause() instanceof FileTooBigException) {
                    Messages.showErrorDialog((Component)this.getContentPanel(), (String)VcsBundle.message((String)"multiple.file.merge.dialog.message.file.too.big.to.be.loaded", (Object[])new Object[0]), (String)VcsBundle.message((String)"multiple.file.merge.dialog.title.can.t.show.merge.dialog", (Object[])new Object[0]));
                    break;
                }
                LOG.error((Throwable)e);
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)e.getMessage(), (String)VcsBundle.message((String)"multiple.file.merge.dialog.title.can.t.show.merge.dialog", (Object[])new Object[0]));
                break;
            }
            MergeDialogCustomizer.DiffEditorTitleCustomizerList $this$showMergeDialog_u24lambda_u2437 = conflictData.getContentTitleCustomizers();
            boolean bl = false;
            Object[] objectArray = new DiffEditorTitleCustomizer[]{$this$showMergeDialog_u24lambda_u2437.getLeftTitleCustomizer(), $this$showMergeDialog_u24lambda_u2437.getCenterTitleCustomizer(), $this$showMergeDialog_u24lambda_u2437.getRightTitleCustomizer()};
            DiffUtil.addTitleCustomizers((MergeRequest)request, (List)CollectionsKt.listOf((Object[])objectArray));
            DiffManager.getInstance().showMerge(this.project, request);
        }
        this.updateModelFromFiles();
    }

    private final MergeSession.Resolution getSessionResolution(MergeResult result2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1 -> MergeSession.Resolution.AcceptedYours;
            case 2 -> MergeSession.Resolution.AcceptedTheirs;
            case 3 -> MergeSession.Resolution.Merged;
            default -> throw new IllegalArgumentException(result2.name());
        };
    }

    private final void checkMarkModifiedProject(VirtualFile file) {
        MergeUtil.reportProjectFileChangeIfNeeded((Project)this.project, (VirtualFile)file);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.table;
    }

    private final <T> T tryCompute(Function0<? extends T> task2) {
        try {
            return (T)task2.invoke();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private static final boolean virtualFileRenderer$lambda$0(MultipleFileMergeDialog this$0) {
        return !this$0.getGroupByDirectory();
    }

    private static final Object _init_$lambda$2(MultipleFileMergeDialog this$0, String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return PlatformDataKeys.TREE_EXPANDER.is(dataId) ? new DefaultTreeTableExpander(this$0.table) : null;
    }

    private static final void _init_$lambda$3(MultipleFileMergeDialog this$0, TreeSelectionEvent it) {
        this$0.updateButtonState();
    }

    private static final String _init_$lambda$4(Object it) {
        VirtualFile virtualFile = it instanceof VirtualFile ? (VirtualFile)it : null;
        return virtualFile != null ? virtualFile.getName() : null;
    }

    private static final Unit lambda$6$lambda$5(MultipleFileMergeDialog this$0, String $description) {
        JLabel jLabel = this$0.descriptionLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"descriptionLabel");
            jLabel = null;
        }
        jLabel.setText($description);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$6(MultipleFileMergeDialog this$0, ModalityState $modalityState) {
        String description = this$0.mergeDialogCustomizer.getMultipleFileMergeDescription((Collection)this$0.unresolvedFiles);
        ActionsKt.runInEdt((ModalityState)$modalityState, () -> MultipleFileMergeDialog.lambda$6$lambda$5(this$0, description));
    }

    private static final Unit createCenterPanel$lambda$18$lambda$7(MultipleFileMergeDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"merge.loading.merge.details", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.descriptionLabel = (JLabel)$this$row.label(string).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$9$lambda$8(MultipleFileMergeDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.acceptRevision(MergeSession.Resolution.AcceptedYours);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$9(MultipleFileMergeDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"multiple.file.merge.accept.yours", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.acceptYoursButton = (JButton)$this$row.button(string, arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$9$lambda$8(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$11$lambda$10(MultipleFileMergeDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.acceptRevision(MergeSession.Resolution.AcceptedTheirs);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$11(MultipleFileMergeDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"multiple.file.merge.accept.theirs", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.acceptTheirsButton = (JButton)$this$row.button(string, arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$11$lambda$10(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$12(MultipleFileMergeDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"multiple.file.merge.merge", (Object[])new Object[0]);
        AbstractAction mergeAction2 = new AbstractAction(this$0, string){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MultipleFileMergeDialog.access$showMergeDialog(this.this$0);
            }
        };
        mergeAction2.putValue("DefaultAction", true);
        this$0.mergeButton = this$0.createJButtonForAction(mergeAction2);
        JButton jButton = this$0.mergeButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mergeButton");
            jButton = null;
        }
        $this$row.cell((JComponent)jButton).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$18$lambda$14$lambda$13(MultipleFileMergeDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$9(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$11(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$14$lambda$13$lambda$12(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$18$lambda$14(MultipleFileMergeDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.scrollCell((JComponent)this$0.table).align(Align.FILL).resizableColumn();
        $this$row.panel(arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$14$lambda$13(this$0, arg_0)).align((Align)AlignY.TOP.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$18$lambda$17$lambda$16$lambda$15(MultipleFileMergeDialog this$0, JBCheckBox $this_applyToComponent, ChangeEvent it) {
        this$0.toggleGroupByDirectory($this_applyToComponent.isSelected());
    }

    private static final Unit createCenterPanel$lambda$18$lambda$17$lambda$16(MultipleFileMergeDialog this$0, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addChangeListener(arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$17$lambda$16$lambda$15(this$0, $this$applyToComponent, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$18$lambda$17(MultipleFileMergeDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"multiple.file.merge.group.by.directory.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.selected((Cell)$this$row.checkBox(string), (boolean)this$0.getGroupByDirectory()).applyToComponent(arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$17$lambda$16(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$18(MultipleFileMergeDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$7(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$14(this$0, arg_0), (int)1, null).resizableRow();
        if (this$0.project != null) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> MultipleFileMergeDialog.createCenterPanel$lambda$18$lambda$17(this$0, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final void resolveFileViaContent$lambda$24(boolean $isCurrent, VirtualFile $file, MergeData $data) {
        if ($isCurrent) {
            $file.setBinaryContent($data.CURRENT);
        } else {
            $file.setBinaryContent($data.LAST);
        }
    }

    private static final String showMergeDialog$lambda$32$lambda$27(MultipleFileMergeDialog this$0, VirtualFile $file) {
        return this$0.mergeDialogCustomizer.getMergeWindowTitle($file);
    }

    private static final String showMergeDialog$lambda$32$lambda$28(MultipleFileMergeDialog this$0, VirtualFile $file) {
        return this$0.mergeDialogCustomizer.getLeftPanelTitle($file);
    }

    private static final String showMergeDialog$lambda$32$lambda$29(MultipleFileMergeDialog this$0, VirtualFile $file) {
        return this$0.mergeDialogCustomizer.getCenterPanelTitle($file);
    }

    private static final String showMergeDialog$lambda$32$lambda$30(MultipleFileMergeDialog this$0, VirtualFile $file, MergeData $mergeData) {
        return this$0.mergeDialogCustomizer.getRightPanelTitle($file, $mergeData.LAST_REVISION_NUMBER);
    }

    private static final MergeDialogCustomizer.DiffEditorTitleCustomizerList showMergeDialog$lambda$32$lambda$31(MultipleFileMergeDialog this$0, FilePath $filePath) {
        return this$0.mergeDialogCustomizer.getTitleCustomizerList($filePath);
    }

    private static final ConflictData showMergeDialog$lambda$32(MultipleFileMergeDialog this$0, VirtualFile $file, FilePath $filePath) {
        MergeData mergeData = this$0.mergeProvider.loadRevisions($file);
        Intrinsics.checkNotNullExpressionValue((Object)mergeData, (String)"loadRevisions(...)");
        MergeData mergeData2 = mergeData;
        String title = (String)this$0.tryCompute(() -> MultipleFileMergeDialog.showMergeDialog$lambda$32$lambda$27(this$0, $file));
        Object[] objectArray = new String[]{this$0.tryCompute(() -> MultipleFileMergeDialog.showMergeDialog$lambda$32$lambda$28(this$0, $file)), this$0.tryCompute(() -> MultipleFileMergeDialog.showMergeDialog$lambda$32$lambda$29(this$0, $file)), this$0.tryCompute(() -> MultipleFileMergeDialog.showMergeDialog$lambda$32$lambda$30(this$0, $file, mergeData2))};
        List conflictTitles = CollectionsKt.listOf((Object[])objectArray);
        MergeDialogCustomizer.DiffEditorTitleCustomizerList diffEditorTitleCustomizerList = (MergeDialogCustomizer.DiffEditorTitleCustomizerList)this$0.tryCompute(() -> MultipleFileMergeDialog.showMergeDialog$lambda$32$lambda$31(this$0, $filePath));
        if (diffEditorTitleCustomizerList == null) {
            diffEditorTitleCustomizerList = MergeDialogCustomizer.Companion.getDEFAULT_CUSTOMIZER_LIST();
        }
        MergeDialogCustomizer.DiffEditorTitleCustomizerList titleCustomizer = diffEditorTitleCustomizerList;
        return new ConflictData(mergeData2, title, conflictTitles, titleCustomizer);
    }

    private static final void showMergeDialog$lambda$34$lambda$33(MultipleFileMergeDialog this$0, VirtualFile $file, MergeResult $result) {
        this$0.markFileProcessed($file, this$0.getSessionResolution($result));
    }

    private static final Unit showMergeDialog$lambda$34(VirtualFile $file, MultipleFileMergeDialog this$0, MergeResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Document document = FileDocumentManager.getInstance().getCachedDocument($file);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
        this$0.checkMarkModifiedProject($file);
        if (result2 != MergeResult.CANCEL) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> MultipleFileMergeDialog.showMergeDialog$lambda$34$lambda$33(this$0, $file, result2), VcsBundle.message((String)"multiple.file.merge.dialog.progress.title.resolving.conflicts", (Object[])new Object[0]), true, this$0.project, this$0.getContentPanel());
        }
        return Unit.INSTANCE;
    }

    private static final void showMergeDialog$lambda$35(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void showMergeDialog$lambda$36(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ MergeSession access$getMergeSession$p(MultipleFileMergeDialog $this) {
        return $this.mergeSession;
    }

    public static final /* synthetic */ void access$checkMarkModifiedProject(MultipleFileMergeDialog $this, VirtualFile file) {
        $this.checkMarkModifiedProject(file);
    }

    public static final /* synthetic */ void access$markFilesProcessed(MultipleFileMergeDialog $this, List files, MergeSession.Resolution resolution) {
        $this.markFilesProcessed(files, resolution);
    }

    public static final /* synthetic */ MergeProvider access$getMergeProvider$p(MultipleFileMergeDialog $this) {
        return $this.mergeProvider;
    }

    public static final /* synthetic */ void access$markFileProcessed(MultipleFileMergeDialog $this, VirtualFile file, MergeSession.Resolution resolution) {
        $this.markFileProcessed(file, resolution);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$resolveFileViaContent(MultipleFileMergeDialog $this, VirtualFile file, MergeSession.Resolution resolution, MergeData data) {
        $this.resolveFileViaContent(file, resolution, data);
    }

    static {
        Logger logger = Logger.getInstance(MultipleFileMergeDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B(\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u000f\u0010\r\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\f0\u0006\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u000bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$ColumnInfoAdapter;", "Lcom/intellij/util/ui/ColumnInfo;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "", "base", "columnName", "", "Lcom/intellij/openapi/util/NlsContexts$ColumnName;", "<init>", "(Lcom/intellij/util/ui/ColumnInfo;Ljava/lang/String;)V", "valueOf", "Lorg/jetbrains/annotations/Nullable;", "node", "getMaxStringValue", "getAdditionalWidth", "", "getTooltipText", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nMultipleFileMergeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipleFileMergeDialog.kt\ncom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$ColumnInfoAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,568:1\n1#2:569\n*E\n"})
    private static final class ColumnInfoAdapter
    extends ColumnInfo<DefaultMutableTreeNode, Object> {
        @NotNull
        private final ColumnInfo<Object, Object> base;
        @NotNull
        private final String columnName;

        public ColumnInfoAdapter(@NotNull ColumnInfo<Object, Object> base, @NotNull String columnName) {
            Intrinsics.checkNotNullParameter(base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            super(columnName);
            this.base = base;
            this.columnName = columnName;
        }

        @Nullable
        public Object valueOf(@NotNull DefaultMutableTreeNode node) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object2 = node.getUserObject();
            VirtualFile virtualFile = object2 instanceof VirtualFile ? (VirtualFile)object2 : null;
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                object = this.base.valueOf((Object)it);
            } else {
                object = null;
            }
            return object;
        }

        @Nullable
        public String getMaxStringValue() {
            return this.base.getMaxStringValue();
        }

        public int getAdditionalWidth() {
            return this.base.getAdditionalWidth();
        }

        @NotNull
        public String getTooltipText() {
            String string = this.base.getTooltipText();
            if (string == null) {
                string = this.columnName;
            }
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0013\u0010\u0007\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0017\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u0016\u0010\u0018\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u000bH\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000f\b\u0002\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0015\b\u0002\u0010\u0007\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0007\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$ConflictData;", "", "mergeData", "Lcom/intellij/openapi/vcs/merge/MergeData;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "contentTitles", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "contentTitleCustomizers", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "<init>", "(Lcom/intellij/openapi/vcs/merge/MergeData;Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;)V", "getMergeData", "()Lcom/intellij/openapi/vcs/merge/MergeData;", "getTitle", "()Ljava/lang/String;", "getContentTitles", "()Ljava/util/List;", "getContentTitleCustomizers", "()Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer$DiffEditorTitleCustomizerList;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.vcs.impl"})
    private static final class ConflictData {
        @NotNull
        private final MergeData mergeData;
        @Nullable
        private final String title;
        @NotNull
        private final List<String> contentTitles;
        @NotNull
        private final MergeDialogCustomizer.DiffEditorTitleCustomizerList contentTitleCustomizers;

        public ConflictData(@NotNull MergeData mergeData, @Nullable String title, @NotNull List<String> contentTitles, @NotNull MergeDialogCustomizer.DiffEditorTitleCustomizerList contentTitleCustomizers) {
            Intrinsics.checkNotNullParameter((Object)mergeData, (String)"mergeData");
            Intrinsics.checkNotNullParameter(contentTitles, (String)"contentTitles");
            Intrinsics.checkNotNullParameter((Object)contentTitleCustomizers, (String)"contentTitleCustomizers");
            this.mergeData = mergeData;
            this.title = title;
            this.contentTitles = contentTitles;
            this.contentTitleCustomizers = contentTitleCustomizers;
        }

        @NotNull
        public final MergeData getMergeData() {
            return this.mergeData;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final List<String> getContentTitles() {
            return this.contentTitles;
        }

        @NotNull
        public final MergeDialogCustomizer.DiffEditorTitleCustomizerList getContentTitleCustomizers() {
            return this.contentTitleCustomizers;
        }

        @NotNull
        public final MergeData component1() {
            return this.mergeData;
        }

        @Nullable
        public final String component2() {
            return this.title;
        }

        @NotNull
        public final List<String> component3() {
            return this.contentTitles;
        }

        @NotNull
        public final MergeDialogCustomizer.DiffEditorTitleCustomizerList component4() {
            return this.contentTitleCustomizers;
        }

        @NotNull
        public final ConflictData copy(@NotNull MergeData mergeData, @Nullable String title, @NotNull List<String> contentTitles, @NotNull MergeDialogCustomizer.DiffEditorTitleCustomizerList contentTitleCustomizers) {
            Intrinsics.checkNotNullParameter((Object)mergeData, (String)"mergeData");
            Intrinsics.checkNotNullParameter(contentTitles, (String)"contentTitles");
            Intrinsics.checkNotNullParameter((Object)contentTitleCustomizers, (String)"contentTitleCustomizers");
            return new ConflictData(mergeData, title, contentTitles, contentTitleCustomizers);
        }

        public static /* synthetic */ ConflictData copy$default(ConflictData conflictData, MergeData mergeData, String string, List list, MergeDialogCustomizer.DiffEditorTitleCustomizerList diffEditorTitleCustomizerList, int n, Object object) {
            if ((n & 1) != 0) {
                mergeData = conflictData.mergeData;
            }
            if ((n & 2) != 0) {
                string = conflictData.title;
            }
            if ((n & 4) != 0) {
                list = conflictData.contentTitles;
            }
            if ((n & 8) != 0) {
                diffEditorTitleCustomizerList = conflictData.contentTitleCustomizers;
            }
            return conflictData.copy(mergeData, string, list, diffEditorTitleCustomizerList);
        }

        @NotNull
        public String toString() {
            return "ConflictData(mergeData=" + this.mergeData + ", title=" + this.title + ", contentTitles=" + this.contentTitles + ", contentTitleCustomizers=" + this.contentTitleCustomizers + ")";
        }

        public int hashCode() {
            int result2 = this.mergeData.hashCode();
            result2 = result2 * 31 + (this.title == null ? 0 : this.title.hashCode());
            result2 = result2 * 31 + ((Object)this.contentTitles).hashCode();
            result2 = result2 * 31 + this.contentTitleCustomizers.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConflictData)) {
                return false;
            }
            ConflictData conflictData = (ConflictData)other;
            if (!Intrinsics.areEqual((Object)this.mergeData, (Object)conflictData.mergeData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)conflictData.title)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.contentTitles, conflictData.contentTitles)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.contentTitleCustomizers, (Object)conflictData.contentTitleCustomizers);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$OnGroupingChangeTreeStateStrategy;", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$TreeTableStateStrategy;", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$OnGroupingChangeTreeStateStrategy$SelectionState;", "<init>", "()V", "saveState", "table", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "restoreState", "", "state", "SelectionState", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nMultipleFileMergeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipleFileMergeDialog.kt\ncom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$OnGroupingChangeTreeStateStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,568:1\n1611#2,9:569\n1863#2:578\n1864#2:580\n1620#2:581\n1557#2:582\n1628#2,3:583\n1#3:579\n*S KotlinDebug\n*F\n+ 1 MultipleFileMergeDialog.kt\ncom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$OnGroupingChangeTreeStateStrategy\n*L\n537#1:569,9\n537#1:578\n537#1:580\n537#1:581\n538#1:582\n538#1:583,3\n537#1:579\n*E\n"})
    private static final class OnGroupingChangeTreeStateStrategy
    implements TreeTableStateStrategy<SelectionState> {
        @Override
        @NotNull
        public SelectionState saveState(@NotNull TreeTable table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            List<VirtualFile> list = VcsTreeModelData.selected((JTree)table.getTree()).userObjects(VirtualFile.class);
            Intrinsics.checkNotNullExpressionValue(list, (String)"userObjects(...)");
            List<VirtualFile> selectedFiles = list;
            return new SelectionState(selectedFiles);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void restoreState(@NotNull TreeTable table, @NotNull SelectionState state) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            TreeUtil.expandAll((JTree)((JTree)table.getTree()));
            Object object = table.getTree().getModel().getRoot();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode newRoot = (DefaultMutableTreeNode)object;
            Iterable iterable = state.getSelectedFiles();
            boolean $i$f$mapNotNull = false;
            void var7_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                DefaultMutableTreeNode it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object2.next();
                boolean bl = false;
                VirtualFile file = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (TreeUtil.findNodeWithObject((DefaultMutableTreeNode)newRoot, (Object)file) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void node;
                object2 = (DefaultMutableTreeNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TreeUtil.getPath((TreeNode)newRoot, (TreeNode)((TreeNode)node)));
            }
            List treePaths = (List)destination$iv$iv;
            TreeUtil.selectPaths((JTree)((JTree)table.getTree()), (Collection)treePaths);
            if (table.getTree().getSelectionCount() == 0) {
                TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)table.getTree()));
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$OnGroupingChangeTreeStateStrategy$SelectionState;", "", "selectedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/util/List;)V", "getSelectedFiles", "()Ljava/util/List;", "intellij.platform.vcs.impl"})
        private static final class SelectionState {
            @NotNull
            private final List<VirtualFile> selectedFiles;

            public SelectionState(@NotNull List<? extends VirtualFile> selectedFiles) {
                Intrinsics.checkNotNullParameter(selectedFiles, (String)"selectedFiles");
                this.selectedFiles = selectedFiles;
            }

            @NotNull
            public final List<VirtualFile> getSelectedFiles() {
                return this.selectedFiles;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$OnModelChangeTreeStateStrategy;", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$TreeTableStateStrategy;", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$OnModelChangeTreeStateStrategy$SelectionState;", "<init>", "()V", "saveState", "table", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "restoreState", "", "state", "SelectionState", "intellij.platform.vcs.impl"})
    private static final class OnModelChangeTreeStateStrategy
    implements TreeTableStateStrategy<SelectionState> {
        @Override
        @NotNull
        public SelectionState saveState(@NotNull TreeTable table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            TreeState treeState = TreeState.createOn((JTree)((JTree)table.getTree()), (boolean)true, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)treeState, (String)"createOn(...)");
            TreeState treeState2 = treeState;
            int firstSelectedIndex = table.getSelectionModel().getMinSelectionIndex();
            return new SelectionState(treeState2, firstSelectedIndex);
        }

        @Override
        public void restoreState(@NotNull TreeTable table, @NotNull SelectionState state) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            state.getTreeState().applyTo((JTree)table.getTree());
            if (table.getTree().getSelectionCount() == 0) {
                int toSelect = RangesKt.coerceAtMost((int)state.getFirstSelectedIndex(), (int)(table.getRowCount() - 1));
                table.getSelectionModel().setSelectionInterval(toSelect, toSelect);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$OnModelChangeTreeStateStrategy$SelectionState;", "", "treeState", "Lcom/intellij/ide/util/treeView/TreeState;", "firstSelectedIndex", "", "<init>", "(Lcom/intellij/ide/util/treeView/TreeState;I)V", "getTreeState", "()Lcom/intellij/ide/util/treeView/TreeState;", "getFirstSelectedIndex", "()I", "intellij.platform.vcs.impl"})
        private static final class SelectionState {
            @NotNull
            private final TreeState treeState;
            private final int firstSelectedIndex;

            public SelectionState(@NotNull TreeState treeState, int firstSelectedIndex) {
                Intrinsics.checkNotNullParameter((Object)treeState, (String)"treeState");
                this.treeState = treeState;
                this.firstSelectedIndex = firstSelectedIndex;
            }

            @NotNull
            public final TreeState getTreeState() {
                return this.treeState;
            }

            public final int getFirstSelectedIndex() {
                return this.firstSelectedIndex;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$SetDefaultTreeStateStrategy;", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$TreeTableStateStrategy;", "", "<init>", "()V", "saveState", "table", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "restoreState", "", "state", "intellij.platform.vcs.impl"})
    private static final class SetDefaultTreeStateStrategy
    implements TreeTableStateStrategy<Object> {
        @Override
        @Nullable
        public Object saveState(@NotNull TreeTable table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            return null;
        }

        @Override
        public void restoreState(@NotNull TreeTable table, @Nullable Object state) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            TreeUtil.expandAll((JTree)((JTree)table.getTree()));
            TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)table.getTree()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\bb\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$TreeTableStateStrategy;", "T", "", "saveState", "table", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "(Lcom/intellij/ui/treeStructure/treetable/TreeTable;)Ljava/lang/Object;", "restoreState", "", "state", "(Lcom/intellij/ui/treeStructure/treetable/TreeTable;Ljava/lang/Object;)V", "intellij.platform.vcs.impl"})
    private static interface TreeTableStateStrategy<T> {
        public T saveState(@NotNull TreeTable var1);

        public void restoreState(@NotNull TreeTable var1, T var2);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MergeResult.values().length];
            try {
                nArray[MergeResult.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MergeResult.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MergeResult.RESOLVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

