/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.ide.startup.importSettings.chooser.ui.SettingsImportOrigin;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.jb.IDEData;
import com.intellij.ide.startup.importSettings.jb.JbImportServiceImpl;
import com.intellij.ide.startup.importSettings.jb.JbImportServiceImplKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b0J\u0010\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u00102\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020\u001fH\u0002J\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dJ\t\u0010=\u001a\u00020\u0003H\u00c6\u0003J\t\u0010>\u001a\u00020\u0005H\u00c6\u0003J\t\u0010?\u001a\u00020\u0003H\u00c6\u0003J\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010A\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\bBJ\t\u0010C\u001a\u00020\nH\u00c6\u0003J\t\u0010D\u001a\u00020\nH\u00c6\u0003JO\u0010E\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010F\u001a\u00020'2\b\u0010G\u001a\u0004\u0018\u00010HH\u00d6\u0003J\t\u0010I\u001a\u00020JH\u00d6\u0001J\t\u0010K\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010$\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000fR\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0018\u00106\u001a\n 8*\u0004\u0018\u00010707X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00109R\u0014\u0010:\u001a\u000207X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006L"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbProductInfo;", "Lcom/intellij/ide/startup/importSettings/data/Product;", "version", "", "lastUsageTime", "Ljava/nio/file/attribute/FileTime;", "id", "name", "codeName", "configDir", "Ljava/nio/file/Path;", "pluginDir", "<init>", "(Ljava/lang/String;Ljava/nio/file/attribute/FileTime;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getVersion", "()Ljava/lang/String;", "getLastUsageTime", "()Ljava/nio/file/attribute/FileTime;", "getId", "getName", "getCodeName$intellij_ide_startup_importSettings", "getConfigDir", "()Ljava/nio/file/Path;", "getPluginDir", "origin", "Lcom/intellij/ide/startup/importSettings/chooser/ui/SettingsImportOrigin;", "getOrigin", "()Lcom/intellij/ide/startup/importSettings/chooser/ui/SettingsImportOrigin;", "descriptorsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "descriptors2ProcessCnt", "Ljava/util/concurrent/atomic/AtomicInteger;", "keymapRef", "Ljava/util/concurrent/atomic/AtomicReference;", "activeKeymap", "getActiveKeymap", "nonDefaultName", "", "getNonDefaultName", "()Z", "prefetchData", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "context", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "prefetchData$intellij_ide_startup_importSettings", "prefetchKeymap", "prefetchPluginDescriptors", "isCompatible", "descriptor", "getPluginsDescriptors", "_lastUsage", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "Ljava/time/LocalDate;", "lastUsage", "getLastUsage", "()Ljava/time/LocalDate;", "component1", "component2", "component3", "component4", "component5", "component5$intellij_ide_startup_importSettings", "component6", "component7", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nJbImportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbProductInfo\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,711:1\n62#2,5:712\n*S KotlinDebug\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbProductInfo\n*L\n98#1:712,5\n*E\n"})
public final class JbProductInfo
implements Product {
    @NotNull
    private final String version;
    @NotNull
    private final FileTime lastUsageTime;
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String codeName;
    @NotNull
    private final Path configDir;
    @NotNull
    private final Path pluginDir;
    @NotNull
    private final SettingsImportOrigin origin;
    @NotNull
    private final ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl> descriptorsMap;
    @NotNull
    private final AtomicInteger descriptors2ProcessCnt;
    @NotNull
    private AtomicReference<String> keymapRef;
    private final boolean nonDefaultName;
    private final LocalDate _lastUsage;
    @NotNull
    private final LocalDate lastUsage;

    public JbProductInfo(@NotNull String version, @NotNull FileTime lastUsageTime, @NotNull String id, @NotNull String name, @NotNull String codeName, @NotNull Path configDir, @NotNull Path pluginDir) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)lastUsageTime, (String)"lastUsageTime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)codeName, (String)"codeName");
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        Intrinsics.checkNotNullParameter((Object)pluginDir, (String)"pluginDir");
        this.version = version;
        this.lastUsageTime = lastUsageTime;
        this.id = id;
        this.name = name;
        this.codeName = codeName;
        this.configDir = configDir;
        this.pluginDir = pluginDir;
        this.origin = SettingsImportOrigin.JetBrainsProduct;
        this.descriptorsMap = new ConcurrentHashMap();
        this.descriptors2ProcessCnt = new AtomicInteger();
        this.keymapRef = new AtomicReference();
        this.nonDefaultName = !JbImportServiceImpl.Companion.getIDE_NAME_PATTERN$intellij_ide_startup_importSettings().matcher(PathsKt.getName((Path)this.configDir)).matches();
        LocalDate localDate = this._lastUsage = LocalDate.ofInstant(this.lastUsageTime.toInstant(), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"_lastUsage");
        this.lastUsage = localDate;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public final FileTime getLastUsageTime() {
        return this.lastUsageTime;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final String getCodeName$intellij_ide_startup_importSettings() {
        return this.codeName;
    }

    @NotNull
    public final Path getConfigDir() {
        return this.configDir;
    }

    @NotNull
    public final Path getPluginDir() {
        return this.pluginDir;
    }

    @Override
    @NotNull
    public SettingsImportOrigin getOrigin() {
        return this.origin;
    }

    @Nullable
    public final String getActiveKeymap() {
        return this.keymapRef.get();
    }

    public final boolean getNonDefaultName() {
        return this.nonDefaultName;
    }

    public final void prefetchData$intellij_ide_startup_importSettings(@NotNull CoroutineScope coroutineScope, @NotNull DescriptorListLoadingContext context) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.prefetchPluginDescriptors(coroutineScope, context);
        this.prefetchKeymap(coroutineScope);
    }

    private final void prefetchKeymap(CoroutineScope coroutineScope) {
        BuildersKt.async$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JbProductInfo this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Path keymapFilePath = this.this$0.getConfigDir().resolve("options/" + StoreUtilKt.getPerOsSettingsStorageFolderName() + "/keymap.xml");
                        Intrinsics.checkNotNull((Object)keymapFilePath);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.exists(keymapFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            Element element = JDOMUtil.load((Path)keymapFilePath);
                            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
                            Element element2 = element;
                            List children = element2.getChildren("component");
                            for (Element child : children) {
                                String keymapName;
                                Element activeKeymap;
                                if (!Intrinsics.areEqual((Object)child.getAttributeValue("name"), (Object)"KeymapManager")) continue;
                                if (child.getChild("active_keymap") == null) {
                                    return Unit.INSTANCE;
                                }
                                if (activeKeymap.getAttributeValue("name") == null) {
                                    return Unit.INSTANCE;
                                }
                                JbProductInfo.access$getKeymapRef$p(this.this$0).set(keymapName);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void prefetchPluginDescriptors(CoroutineScope coroutineScope, DescriptorListLoadingContext context) {
        JbImportServiceImplKt.access$getLogger$p().debug("Prefetching plugin descriptors from " + this.pluginDir);
        List descriptorDeferreds = PluginDescriptorLoader.loadCustomDescriptorsFromDirForImportSettings((CoroutineScope)coroutineScope, (Path)this.pluginDir, (DescriptorListLoadingContext)context);
        this.descriptors2ProcessCnt.set(descriptorDeferreds.size());
        Logger $this$debug_u24default$iv = JbImportServiceImplKt.access$getLogger$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("There are " + descriptorDeferreds.size() + " plugins in " + this.pluginDir, e$iv);
        }
        Path path = this.configDir.resolve("disabled_plugins.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path disabledPluginsFile = path;
        Set disabledPlugins = Files.exists(disabledPluginsFile, new LinkOption[0]) ? PluginManagerCoreKt.tryReadPluginIdsFromFile((Path)disabledPluginsFile, (Logger)JbImportServiceImplKt.access$getLogger$p()) : SetsKt.emptySet();
        for (Deferred def : descriptorDeferreds) {
            def.invokeOnCompletion(arg_0 -> JbProductInfo.prefetchPluginDescriptors$lambda$1(def, disabledPlugins, this, arg_0));
        }
    }

    private final boolean isCompatible(IdeaPluginDescriptorImpl descriptor) {
        if (PluginManagerCore.INSTANCE.getPluginSet().isPluginEnabled(descriptor.getPluginId())) {
            IDEData iDEData = IDEData.Companion.getSelf();
            JbImportServiceImplKt.access$getLogger$p().info("Plugin \"" + descriptor.getName() + "\" from \"" + this.getName() + "\" is already present in \"" + (iDEData != null ? iDEData.getFullName() : null) + "\"");
            return false;
        }
        for (PluginId ic : descriptor.incompatibilities) {
            if (!PluginManagerCore.INSTANCE.getPluginSet().isPluginEnabled(ic)) continue;
            IDEData iDEData = IDEData.Companion.getSelf();
            JbImportServiceImplKt.access$getLogger$p().info("Plugin \"" + descriptor.getName() + "\" from \"" + this.getName() + "\" could not be migrated to \"" + (iDEData != null ? iDEData.getFullName() : null) + "\", because it is incompatible with " + ic);
            return false;
        }
        for (PluginDependency dependency : descriptor.pluginDependencies) {
            if (dependency.isOptional() || PluginManagerCore.INSTANCE.getPluginSet().isPluginEnabled(dependency.getPluginId()) || this.descriptorsMap.containsKey(dependency.getPluginId())) continue;
            IDEData iDEData = IDEData.Companion.getSelf();
            JbImportServiceImplKt.access$getLogger$p().info("Plugin \"" + descriptor.getName() + "\" from \"" + this.getName() + "\" could not be migrated to \"" + (iDEData != null ? iDEData.getFullName() : null) + "\", because of the missing required dependency: " + dependency.getPluginId());
            return false;
        }
        return true;
    }

    @NotNull
    public final ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl> getPluginsDescriptors() {
        if (this.descriptors2ProcessCnt.get() != 0) {
            JbImportServiceImplKt.access$getLogger$p().warn("There are " + this.descriptors2ProcessCnt + " custom plugins that are not yet processed!");
        }
        return this.descriptorsMap;
    }

    @Override
    @NotNull
    public LocalDate getLastUsage() {
        return this.lastUsage;
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    @NotNull
    public final FileTime component2() {
        return this.lastUsageTime;
    }

    @NotNull
    public final String component3() {
        return this.id;
    }

    @NotNull
    public final String component4() {
        return this.name;
    }

    @NotNull
    public final String component5$intellij_ide_startup_importSettings() {
        return this.codeName;
    }

    @NotNull
    public final Path component6() {
        return this.configDir;
    }

    @NotNull
    public final Path component7() {
        return this.pluginDir;
    }

    @NotNull
    public final JbProductInfo copy(@NotNull String version, @NotNull FileTime lastUsageTime, @NotNull String id, @NotNull String name, @NotNull String codeName, @NotNull Path configDir, @NotNull Path pluginDir) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)lastUsageTime, (String)"lastUsageTime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)codeName, (String)"codeName");
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        Intrinsics.checkNotNullParameter((Object)pluginDir, (String)"pluginDir");
        return new JbProductInfo(version, lastUsageTime, id, name, codeName, configDir, pluginDir);
    }

    public static /* synthetic */ JbProductInfo copy$default(JbProductInfo jbProductInfo, String string, FileTime fileTime, String string2, String string3, String string4, Path path, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            string = jbProductInfo.version;
        }
        if ((n & 2) != 0) {
            fileTime = jbProductInfo.lastUsageTime;
        }
        if ((n & 4) != 0) {
            string2 = jbProductInfo.id;
        }
        if ((n & 8) != 0) {
            string3 = jbProductInfo.name;
        }
        if ((n & 0x10) != 0) {
            string4 = jbProductInfo.codeName;
        }
        if ((n & 0x20) != 0) {
            path = jbProductInfo.configDir;
        }
        if ((n & 0x40) != 0) {
            path2 = jbProductInfo.pluginDir;
        }
        return jbProductInfo.copy(string, fileTime, string2, string3, string4, path, path2);
    }

    @NotNull
    public String toString() {
        return "JbProductInfo(version=" + this.version + ", lastUsageTime=" + this.lastUsageTime + ", id=" + this.id + ", name=" + this.name + ", codeName=" + this.codeName + ", configDir=" + this.configDir + ", pluginDir=" + this.pluginDir + ")";
    }

    public int hashCode() {
        int result2 = this.version.hashCode();
        result2 = result2 * 31 + this.lastUsageTime.hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.codeName.hashCode();
        result2 = result2 * 31 + ((Object)this.configDir).hashCode();
        result2 = result2 * 31 + ((Object)this.pluginDir).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JbProductInfo)) {
            return false;
        }
        JbProductInfo jbProductInfo = (JbProductInfo)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)jbProductInfo.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUsageTime, (Object)jbProductInfo.lastUsageTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)jbProductInfo.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)jbProductInfo.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.codeName, (Object)jbProductInfo.codeName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configDir, (Object)jbProductInfo.configDir)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pluginDir, (Object)jbProductInfo.pluginDir);
    }

    private static final Unit prefetchPluginDescriptors$lambda$1(Deferred $def, Set $disabledPlugins, JbProductInfo this$0, Throwable it) {
        IdeaPluginDescriptorImpl descr = (IdeaPluginDescriptorImpl)$def.getCompleted();
        if (descr != null) {
            if ($disabledPlugins.contains(descr.getPluginId())) {
                JbImportServiceImplKt.access$getLogger$p().info("Plugin " + descr.getPluginId() + " is disabled in " + this$0.getName() + ". Won't try to import it");
            } else {
                ((Map)this$0.descriptorsMap).put(descr.getPluginId(), descr);
            }
        }
        if (this$0.descriptors2ProcessCnt.decrementAndGet() == 0) {
            for (Map.Entry entry : ((Map)this$0.descriptorsMap).entrySet()) {
                if (this$0.isCompatible((IdeaPluginDescriptorImpl)entry.getValue())) continue;
                this$0.descriptorsMap.remove(entry.getKey());
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AtomicReference access$getKeymapRef$p(JbProductInfo $this) {
        return $this.keymapRef;
    }
}

