/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 78160223285902L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(408414120 + 31698, 408414120 + (char)-26942, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(408414120 + 31699, -408414120 + -((char)-30469), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 778957437974L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.l();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 != 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1568383620 - 13476, 1568383620 - 17925, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1568383620 - 13475, 1568383620 - 26748, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1568383620 - 13470, 1568383620 - 14092, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 99742547319471L;
                Object object = this.lock;
                n2 = SshAgentIpcService.t();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(521789670 + 27256, 521789670 + 25974, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(521789670 + 27255, 521789670 + 25185, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (n2 == 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(521789670 + 27254, -521789670 + -22790, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(521789670 + 27245, 521789670 + 25297, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(521789670 + 27244, 521789670 + (char)-25592, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(521789670 + 27254, -521789670 + -22790, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(521789670 + 27243, -521789670 + -18149, (int)l2));
            if (ActionTimestamp.t()) {
                SshAgentIpcService.l(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 99287413084214L;
                    n3 = SshAgentIpcService.l();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 != 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 != 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    int n2;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 80921531896975L;
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        n2 = SshAgentIpcService.t();
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (n2 == 0) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(53083350 - 30566, 53083350 - 4755, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(53083350 - 30554, -53083350 - -1290, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(53083350 - 30559, -53083350 - -27925, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(53083350 - 30554, -53083350 - -1290, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(53083350 - 30560, 53083350 - 2560, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(53083350 - 30566, 53083350 - 4755, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(53083350 - 30554, -53083350 - -1290, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(53083350 - 30561, -53083350 - -2511, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (n2 == 0) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n3 = Kernel32.INSTANCE.GetLastError();
                            if (n3 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(53083350 - 30566, 53083350 - 4755, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(53083350 - 30554, -53083350 - -1290, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(53083350 - 30562, -53083350 - -17377, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(53083350 - 30554, -53083350 - -1290, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(53083350 - 30571, 53083350 - 29805, (int)l2) + ErrorToolsKt.prettyHRESULT(n3)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(53083350 - 30554, -53083350 - -1290, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(53083350 - 30560, 53083350 - 2560, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(53083350 - 30566, 53083350 - 4755, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(53083350 - 30554, -53083350 - -1290, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(53083350 - 30572, 53083350 - 4645, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 16887612644502L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-198702120 + -((char)-8840), 198702120 + (char)-26748, (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 4943211601198L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-295693920 + -((char)-7737), -295693920 + -((char)-1715), (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "9\u00d0\u00e2U'\u00a2j\u0007\u00ff\u007f{\u00fc*cy\u00b8=\u001d\u00e9\u0014\u00fe*\u001a\f#K\u0097\u00bf\u00c2n\u0019\n\u00a4Di\u00d7\u00d26\u0013\u001c";
                                        var4_3 = "9\u00d0\u00e2U'\u00a2j\u0007\u00ff\u007f{\u00fc*cy\u00b8=\u001d\u00e9\u0014\u00fe*\u001a\f#K\u0097\u00bf\u00c2n\u0019\n\u00a4Di\u00d7\u00d26\u0013\u001c".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 41;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 82;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 21;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 87;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 97;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 106;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 56;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 25;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0x32F6) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 29;
                                            case 1 -> 143;
                                            case 2 -> 62;
                                            case 3 -> 60;
                                            case 4 -> 240;
                                            case 5 -> 126;
                                            case 6 -> 246;
                                            case 7 -> 93;
                                            case 8 -> 11;
                                            case 9 -> 166;
                                            case 10 -> 58;
                                            case 11 -> 112;
                                            case 12 -> 88;
                                            case 13 -> 49;
                                            case 14 -> 173;
                                            case 15 -> 91;
                                            case 16 -> 32;
                                            case 17 -> 25;
                                            case 18 -> 195;
                                            case 19 -> 90;
                                            case 20 -> 76;
                                            case 21 -> 68;
                                            case 22 -> 72;
                                            case 23 -> 17;
                                            case 24 -> 51;
                                            case 25 -> 125;
                                            case 26 -> 79;
                                            case 27 -> 239;
                                            case 28 -> 181;
                                            case 29 -> 197;
                                            case 30 -> 229;
                                            case 31 -> 252;
                                            case 32 -> 154;
                                            case 33 -> 59;
                                            case 34 -> 226;
                                            case 35 -> 162;
                                            case 36 -> 113;
                                            case 37 -> 140;
                                            case 38 -> 209;
                                            case 39 -> 198;
                                            case 40 -> 237;
                                            case 41 -> 66;
                                            case 42 -> 105;
                                            case 43 -> 230;
                                            case 44 -> 177;
                                            case 45 -> 165;
                                            case 46 -> 36;
                                            case 47 -> 5;
                                            case 48 -> 214;
                                            case 49 -> 9;
                                            case 50 -> 248;
                                            case 51 -> 204;
                                            case 52 -> 109;
                                            case 53 -> 43;
                                            case 54 -> 238;
                                            case 55 -> 183;
                                            case 56 -> 35;
                                            case 57 -> 92;
                                            case 58 -> 77;
                                            case 59 -> 199;
                                            case 60 -> 186;
                                            case 61 -> 97;
                                            case 62 -> 103;
                                            case 63 -> 114;
                                            case 64 -> 21;
                                            case 65 -> 170;
                                            case 66 -> 14;
                                            case 67 -> 116;
                                            case 68 -> 64;
                                            case 69 -> 1;
                                            case 70 -> 53;
                                            case 71 -> 208;
                                            case 72 -> 39;
                                            case 73 -> 164;
                                            case 74 -> 149;
                                            case 75 -> 67;
                                            case 76 -> 8;
                                            case 77 -> 222;
                                            case 78 -> 147;
                                            case 79 -> 136;
                                            case 80 -> 141;
                                            case 81 -> 84;
                                            case 82 -> 213;
                                            case 83 -> 227;
                                            case 84 -> 242;
                                            case 85 -> 178;
                                            case 86 -> 158;
                                            case 87 -> 45;
                                            case 88 -> 151;
                                            case 89 -> 94;
                                            case 90 -> 241;
                                            case 91 -> 130;
                                            case 92 -> 190;
                                            case 93 -> 115;
                                            case 94 -> 243;
                                            case 95 -> 102;
                                            case 96 -> 168;
                                            case 97 -> 175;
                                            case 98 -> 153;
                                            case 99 -> 133;
                                            case 100 -> 63;
                                            case 101 -> 50;
                                            case 102 -> 122;
                                            case 103 -> 3;
                                            case 104 -> 54;
                                            case 105 -> 4;
                                            case 106 -> 152;
                                            case 107 -> 24;
                                            case 108 -> 144;
                                            case 109 -> 254;
                                            case 110 -> 203;
                                            case 111 -> 163;
                                            case 112 -> 156;
                                            case 113 -> 119;
                                            case 114 -> 187;
                                            case 115 -> 73;
                                            case 116 -> 160;
                                            case 117 -> 106;
                                            case 118 -> 228;
                                            case 119 -> 218;
                                            case 120 -> 118;
                                            case 121 -> 124;
                                            case 122 -> 134;
                                            case 123 -> 48;
                                            case 124 -> 211;
                                            case 125 -> 225;
                                            case 126 -> 70;
                                            case 127 -> 99;
                                            case 128 -> 101;
                                            case 129 -> 189;
                                            case 130 -> 159;
                                            case 131 -> 55;
                                            case 132 -> 69;
                                            case 133 -> 146;
                                            case 134 -> 231;
                                            case 135 -> 111;
                                            case 136 -> 137;
                                            case 137 -> 132;
                                            case 138 -> 247;
                                            case 139 -> 210;
                                            case 140 -> 131;
                                            case 141 -> 82;
                                            case 142 -> 71;
                                            case 143 -> 250;
                                            case 144 -> 244;
                                            case 145 -> 85;
                                            case 146 -> 89;
                                            case 147 -> 86;
                                            case 148 -> 0;
                                            case 149 -> 87;
                                            case 150 -> 148;
                                            case 151 -> 65;
                                            case 152 -> 6;
                                            case 153 -> 253;
                                            case 154 -> 19;
                                            case 155 -> 236;
                                            case 156 -> 26;
                                            case 157 -> 95;
                                            case 158 -> 30;
                                            case 159 -> 185;
                                            case 160 -> 96;
                                            case 161 -> 138;
                                            case 162 -> 47;
                                            case 163 -> 83;
                                            case 164 -> 215;
                                            case 165 -> 196;
                                            case 166 -> 34;
                                            case 167 -> 174;
                                            case 168 -> 80;
                                            case 169 -> 13;
                                            case 170 -> 23;
                                            case 171 -> 42;
                                            case 172 -> 56;
                                            case 173 -> 221;
                                            case 174 -> 15;
                                            case 175 -> 108;
                                            case 176 -> 18;
                                            case 177 -> 206;
                                            case 178 -> 61;
                                            case 179 -> 172;
                                            case 180 -> 205;
                                            case 181 -> 192;
                                            case 182 -> 22;
                                            case 183 -> 224;
                                            case 184 -> 37;
                                            case 185 -> 179;
                                            case 186 -> 100;
                                            case 187 -> 155;
                                            case 188 -> 2;
                                            case 189 -> 233;
                                            case 190 -> 161;
                                            case 191 -> 180;
                                            case 192 -> 135;
                                            case 193 -> 235;
                                            case 194 -> 249;
                                            case 195 -> 150;
                                            case 196 -> 182;
                                            case 197 -> 128;
                                            case 198 -> 200;
                                            case 199 -> 7;
                                            case 200 -> 98;
                                            case 201 -> 120;
                                            case 202 -> 40;
                                            case 203 -> 107;
                                            case 204 -> 121;
                                            case 205 -> 142;
                                            case 206 -> 44;
                                            case 207 -> 251;
                                            case 208 -> 46;
                                            case 209 -> 220;
                                            case 210 -> 212;
                                            case 211 -> 27;
                                            case 212 -> 188;
                                            case 213 -> 38;
                                            case 214 -> 33;
                                            case 215 -> 52;
                                            case 216 -> 78;
                                            case 217 -> 176;
                                            case 218 -> 12;
                                            case 219 -> 117;
                                            case 220 -> 219;
                                            case 221 -> 184;
                                            case 222 -> 129;
                                            case 223 -> 232;
                                            case 224 -> 234;
                                            case 225 -> 201;
                                            case 226 -> 41;
                                            case 227 -> 245;
                                            case 228 -> 167;
                                            case 229 -> 81;
                                            case 230 -> 16;
                                            case 231 -> 75;
                                            case 232 -> 57;
                                            case 233 -> 217;
                                            case 234 -> 202;
                                            case 235 -> 194;
                                            case 236 -> 20;
                                            case 237 -> 216;
                                            case 238 -> 127;
                                            case 239 -> 193;
                                            case 240 -> 104;
                                            case 241 -> 74;
                                            case 242 -> 123;
                                            case 243 -> 169;
                                            case 244 -> 139;
                                            case 245 -> 191;
                                            case 246 -> 110;
                                            case 247 -> 171;
                                            case 248 -> 255;
                                            case 249 -> 145;
                                            case 250 -> 28;
                                            case 251 -> 31;
                                            case 252 -> 10;
                                            case 253 -> 157;
                                            case 254 -> 223;
                                            default -> 207;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c2 ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c2 ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (n2 != 0) break block32;
                            if (ActionTimestamp.t()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.l(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 117980227402066L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.t();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 == 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1770755700 - 28103, 1770755700 - 20182, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1770755700 - 28115, -1770755700 - -15453, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1770755700 - 28096, 1770755700 - 11916, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1770755700 - 28103, 1770755700 - 20182, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1770755700 - 28115, -1770755700 - -15453, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1770755700 - 28095, 1770755700 - (char)-30332, (int)l3) + ErrorToolsKt.prettyHRESULT(n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 110146135526184L;
                        int n3 = SshAgentIpcService.t();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1699191480 + (char)-16368, 1699191480 + (char)-15603, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 == 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 == 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1699191480 + (char)-16367, 1699191480 + 30215, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 == 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 26167587490659L;
                int n3 = SshAgentIpcService.l();
                this.assertConnectionThread();
                n2 = n3;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 != 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 != 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14430), -1648205250 + -27791, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14418), 1648205250 + 31254, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14403), -1648205250 + -31701, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14418), 1648205250 + 31254, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14428), -1648205250 + -29956, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14430), -1648205250 + -27791, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14418), 1648205250 + 31254, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14402), -1648205250 + -((char)-8555), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 != 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14430), -1648205250 + -27791, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14418), 1648205250 + 31254, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14417), -1648205250 + -((char)-23452), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 != 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14430), -1648205250 + -27791, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14418), 1648205250 + 31254, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1648205250 + -((char)-14416), -1648205250 + -((char)-22113), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 59215611276053L;
                    Object object = this.lock;
                    n3 = SshAgentIpcService.t();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(897174150 + 12388, 897174150 - 13485, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(897174150 + 12384, -897174150 - -16948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(897174150 + 12405, 897174150 - 1367, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(897174150 + 12404, 897174150 - 16995, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(897174150 + 12388, 897174150 - 13485, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(897174150 + 12384, -897174150 - -16948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(897174150 + 12407, 897174150 - 6079, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(897174150 + 12388, 897174150 - 13485, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(897174150 + 12384, -897174150 - -16948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(897174150 + 12406, -897174150 - -4456, (int)l2) + ErrorToolsKt.prettyHRESULT(n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(897174150 + 12388, 897174150 - 13485, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(897174150 + 12384, -897174150 - -16948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(897174150 + 12409, -897174150 - -11774, (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(897174150 + 12388, 897174150 - 13485, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(897174150 + 12384, -897174150 - -16948, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(897174150 + 12408, -897174150 - -4017, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u00f0eukNE\u00bc\u001b\u00144\u0011\u00d5\u0002\u00a4\u00e0N\u00b5\u0000&\u00e9'v6\u00c20\u00c80\u00eb\u0006\u0006\u00c3\u00c7\u0013?\u00e8\u008e\u0018\u00af\u0004\u00c6\u0090DwP\u0087\u000b\u001d\u00870\u00dd+\u00e5\u0011\u0085}l2k\u00ba\u00be\u00c6\t4\u00c5+\u0019\u0092\u00d9\u0092\u001ao\u0005\u0089+Z\u00a2\u00db\bj\u0095&\u0004v\u008e\u00bd\u0080\u0005D(\u00e3\u00c2\u00ec\u001e\u00e3*\u0002\u00e6M}\u00d3\u00bc\u00denv\u00d9\u00af6\t\u00d6\u00f9\u00141\u00ebl\u00aeR\u0089\u00f4w\u0081\u00e6\u00e8.\u0010\u00bb\u0080\u00edv\u00e7]pA\u00d7c\u00da\u0085<\u00e8\u00d4\u0092\t\u00de\b\u00a0\u00b1\u00b0\u00eb\u00f0\u00c3\u00cd\u0010\u009a2\u00c9 c\u0097\u00e0\u0018\u00c5H\u0098\u00e0tD\u00dd\u0007?\u0019\u0003U\u00c3\u00aa\u00d0\u00aae\u0080\u0084\u00f8\u007f\u00c1\u0014\u00f9\u00ab\"\u00de7w\"o\u00e0\u00d7\u00b2TD6gb\u000e\u00fc\u00ad@\u00a6\u00fe\u000bQ\u00f4\u00c7\u0091\bn\t\u00c9\u00e4;\u00cb\u009et\u00d9\u00c5\u00b7\t\u00cb*5\u0090\u0093\u00882\u00b9\u00da\b\u00bcG\u00fc^-\u00c5\u00d6\u00e9\fQ\u00fdQ\u0012\u0085.-\u0093Uq\u00d8\u00c3F,5\u00fe\u000bp\r\u0093\u00f7\u0082\u00f1(\u0017M\u0011w-\u000fi\u0092.\u0084\u00167\u00ca~\u00dc.,\u0095\bj\u008d\u001d\u00d8r\u00ccKZWbv\u00a9\u0019\u00c6\u00f9\u0098i93\u00d2\n\u00bb\"Po\u001a>\u00e2dz\u00ff\u008e?\u00ad\u0082t/\u00c1OB\u001f\u00ean#nilW\u009eN*dQ\u00ed:J\u00e6\u00ea\u00fa.\u00fcD\u00cc\u0080n\u00cf[\u00f1\u00af\u00fb\u00f6\u00a5\u000b\u00bf\u00b1\u008c\u009b>\u001fZ\u00b5\u00bb\u00b9\u000f\u0015p\u009au\u00fd\u0006\u00bb\u00b1\\\u00f8d\u00afS*\u00d6\u00af-\u00ad\u0017\u001b8\u00d4)b;2\u00c4K9\u00134\u00c6\u007fu\u00fb\u00cbe\u0010\b\u00fe\u00afw\u00f1\u009f\u0015=M\u0017v=rM\u00b9\u00f1\u0085\u0090|\u00a5\u00d5\u00afd@\f7\u0007\u00fc\u0083\u00eb\u00c9T\u00c5k\u0007N\u00d6\u00d9\u000f\u00f5\u00f2I(\u000e0\u00f3\u0084\u00c3[\u00f4_J\u00c5\u00ce\u009a\u009f\u00c8\u00d8>\u00e0\u00c4\u001a\u00dfS\u00ee\u00cb\u00f9Y\\BL\u0095\u001e1hs\u00aaG\u00a2I\u00f7\u000f\u008d\u000f\u00c2N$b\u00d1\u00eb\u0013\u008a\u00c3\u00f2^--j\u0010\"Y\u0018U\u00a0\u00a7\u00b5\u008e\u00a5uM\u0003\u00bd\u0006\u00a1\u00cd^\u00aeL\u00f7\u00cfe\u00d2\u00c2\u00e5{7}\u0084aU\u00d6\u001fZ\u00dc\u000e[\u00dc\u00170\u00b7\u00a1\u00df\u00c3Z\u00dbm\bG\u00c4\u001b~\u00bc\u00b4985\u00bb\r\u0081\u0085\u009b\u00c2\u00c9\u00ab\u0012\t\u00fd\f [\u00a4t\u0089\u0097Y\u0014l\n=\u00d6\u0018s\u00b9\u0098X\u0092V\u0014\u0018*\u007f>Lh'\u0090\u0011\u00fa\u00cf6\u0014\u00c5\"o\u0019%\u000f\u00ecBE\u001c\u00ee\u00c9)ue\u00d0\u000f\u0017@\u0098\u001b\u00b7\u009a[G\n\u00fb\u00b7\u00a0t\u00cf\u00f98t<\td\u00e4\u00c1\u00dehb\u00a6\u00af\u00f7~\u00ec\u00adSp\u0090\u00bb\u0092H";
                var4_3 = "\u00f0eukNE\u00bc\u001b\u00144\u0011\u00d5\u0002\u00a4\u00e0N\u00b5\u0000&\u00e9'v6\u00c20\u00c80\u00eb\u0006\u0006\u00c3\u00c7\u0013?\u00e8\u008e\u0018\u00af\u0004\u00c6\u0090DwP\u0087\u000b\u001d\u00870\u00dd+\u00e5\u0011\u0085}l2k\u00ba\u00be\u00c6\t4\u00c5+\u0019\u0092\u00d9\u0092\u001ao\u0005\u0089+Z\u00a2\u00db\bj\u0095&\u0004v\u008e\u00bd\u0080\u0005D(\u00e3\u00c2\u00ec\u001e\u00e3*\u0002\u00e6M}\u00d3\u00bc\u00denv\u00d9\u00af6\t\u00d6\u00f9\u00141\u00ebl\u00aeR\u0089\u00f4w\u0081\u00e6\u00e8.\u0010\u00bb\u0080\u00edv\u00e7]pA\u00d7c\u00da\u0085<\u00e8\u00d4\u0092\t\u00de\b\u00a0\u00b1\u00b0\u00eb\u00f0\u00c3\u00cd\u0010\u009a2\u00c9 c\u0097\u00e0\u0018\u00c5H\u0098\u00e0tD\u00dd\u0007?\u0019\u0003U\u00c3\u00aa\u00d0\u00aae\u0080\u0084\u00f8\u007f\u00c1\u0014\u00f9\u00ab\"\u00de7w\"o\u00e0\u00d7\u00b2TD6gb\u000e\u00fc\u00ad@\u00a6\u00fe\u000bQ\u00f4\u00c7\u0091\bn\t\u00c9\u00e4;\u00cb\u009et\u00d9\u00c5\u00b7\t\u00cb*5\u0090\u0093\u00882\u00b9\u00da\b\u00bcG\u00fc^-\u00c5\u00d6\u00e9\fQ\u00fdQ\u0012\u0085.-\u0093Uq\u00d8\u00c3F,5\u00fe\u000bp\r\u0093\u00f7\u0082\u00f1(\u0017M\u0011w-\u000fi\u0092.\u0084\u00167\u00ca~\u00dc.,\u0095\bj\u008d\u001d\u00d8r\u00ccKZWbv\u00a9\u0019\u00c6\u00f9\u0098i93\u00d2\n\u00bb\"Po\u001a>\u00e2dz\u00ff\u008e?\u00ad\u0082t/\u00c1OB\u001f\u00ean#nilW\u009eN*dQ\u00ed:J\u00e6\u00ea\u00fa.\u00fcD\u00cc\u0080n\u00cf[\u00f1\u00af\u00fb\u00f6\u00a5\u000b\u00bf\u00b1\u008c\u009b>\u001fZ\u00b5\u00bb\u00b9\u000f\u0015p\u009au\u00fd\u0006\u00bb\u00b1\\\u00f8d\u00afS*\u00d6\u00af-\u00ad\u0017\u001b8\u00d4)b;2\u00c4K9\u00134\u00c6\u007fu\u00fb\u00cbe\u0010\b\u00fe\u00afw\u00f1\u009f\u0015=M\u0017v=rM\u00b9\u00f1\u0085\u0090|\u00a5\u00d5\u00afd@\f7\u0007\u00fc\u0083\u00eb\u00c9T\u00c5k\u0007N\u00d6\u00d9\u000f\u00f5\u00f2I(\u000e0\u00f3\u0084\u00c3[\u00f4_J\u00c5\u00ce\u009a\u009f\u00c8\u00d8>\u00e0\u00c4\u001a\u00dfS\u00ee\u00cb\u00f9Y\\BL\u0095\u001e1hs\u00aaG\u00a2I\u00f7\u000f\u008d\u000f\u00c2N$b\u00d1\u00eb\u0013\u008a\u00c3\u00f2^--j\u0010\"Y\u0018U\u00a0\u00a7\u00b5\u008e\u00a5uM\u0003\u00bd\u0006\u00a1\u00cd^\u00aeL\u00f7\u00cfe\u00d2\u00c2\u00e5{7}\u0084aU\u00d6\u001fZ\u00dc\u000e[\u00dc\u00170\u00b7\u00a1\u00df\u00c3Z\u00dbm\bG\u00c4\u001b~\u00bc\u00b4985\u00bb\r\u0081\u0085\u009b\u00c2\u00c9\u00ab\u0012\t\u00fd\f [\u00a4t\u0089\u0097Y\u0014l\n=\u00d6\u0018s\u00b9\u0098X\u0092V\u0014\u0018*\u007f>Lh'\u0090\u0011\u00fa\u00cf6\u0014\u00c5\"o\u0019%\u000f\u00ecBE\u001c\u00ee\u00c9)ue\u00d0\u000f\u0017@\u0098\u001b\u00b7\u009a[G\n\u00fb\u00b7\u00a0t\u00cf\u00f98t<\td\u00e4\u00c1\u00dehb\u00a6\u00af\u00f7~\u00ec\u00adSp\u0090\u00bb\u0092H".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 55;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "W\u00fc\u008a*\u00e4L7w\u0093\u001d\u00bd\u0003\u00d2\u00d8L\u00a1\u00e8<\u00a2e\u00e2\u00a3&|)K\u00bc\u00a5\u00ab\u00eapBanY\u0087\u00e3\u00feN";
                    var4_3 = "W\u00fc\u008a*\u00e4L7w\u0093\u001d\u00bd\u0003\u00d2\u00d8L\u00a1\u00e8<\u00a2e\u00e2\u00a3&|)K\u00bc\u00a5\u00ab\u00eapBanY\u0087\u00e3\u00feN".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 47;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 45;
                            break;
                        }
                        case 1: {
                            v15 = 57;
                            break;
                        }
                        case 2: {
                            v15 = 17;
                            break;
                        }
                        case 3: {
                            v15 = 16;
                            break;
                        }
                        case 4: {
                            v15 = 61;
                            break;
                        }
                        case 5: {
                            v15 = 83;
                            break;
                        }
                        default: {
                            v15 = 45;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x51F4) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 154;
                case 1 -> 118;
                case 2 -> 20;
                case 3 -> 119;
                case 4 -> 72;
                case 5 -> 170;
                case 6 -> 188;
                case 7 -> 66;
                case 8 -> 97;
                case 9 -> 19;
                case 10 -> 122;
                case 11 -> 205;
                case 12 -> 160;
                case 13 -> 73;
                case 14 -> 210;
                case 15 -> 203;
                case 16 -> 180;
                case 17 -> 9;
                case 18 -> 144;
                case 19 -> 67;
                case 20 -> 214;
                case 21 -> 172;
                case 22 -> 236;
                case 23 -> 177;
                case 24 -> 212;
                case 25 -> 101;
                case 26 -> 49;
                case 27 -> 209;
                case 28 -> 76;
                case 29 -> 126;
                case 30 -> 103;
                case 31 -> 150;
                case 32 -> 165;
                case 33 -> 253;
                case 34 -> 190;
                case 35 -> 105;
                case 36 -> 14;
                case 37 -> 138;
                case 38 -> 63;
                case 39 -> 43;
                case 40 -> 77;
                case 41 -> 247;
                case 42 -> 132;
                case 43 -> 116;
                case 44 -> 84;
                case 45 -> 241;
                case 46 -> 108;
                case 47 -> 40;
                case 48 -> 200;
                case 49 -> 59;
                case 50 -> 104;
                case 51 -> 211;
                case 52 -> 191;
                case 53 -> 219;
                case 54 -> 120;
                case 55 -> 197;
                case 56 -> 69;
                case 57 -> 216;
                case 58 -> 91;
                case 59 -> 86;
                case 60 -> 146;
                case 61 -> 48;
                case 62 -> 235;
                case 63 -> 124;
                case 64 -> 1;
                case 65 -> 129;
                case 66 -> 231;
                case 67 -> 64;
                case 68 -> 111;
                case 69 -> 13;
                case 70 -> 249;
                case 71 -> 80;
                case 72 -> 83;
                case 73 -> 17;
                case 74 -> 133;
                case 75 -> 5;
                case 76 -> 223;
                case 77 -> 30;
                case 78 -> 222;
                case 79 -> 143;
                case 80 -> 100;
                case 81 -> 217;
                case 82 -> 206;
                case 83 -> 139;
                case 84 -> 112;
                case 85 -> 254;
                case 86 -> 65;
                case 87 -> 251;
                case 88 -> 175;
                case 89 -> 11;
                case 90 -> 78;
                case 91 -> 204;
                case 92 -> 81;
                case 93 -> 12;
                case 94 -> 141;
                case 95 -> 164;
                case 96 -> 10;
                case 97 -> 147;
                case 98 -> 202;
                case 99 -> 41;
                case 100 -> 220;
                case 101 -> 115;
                case 102 -> 168;
                case 103 -> 15;
                case 104 -> 125;
                case 105 -> 24;
                case 106 -> 106;
                case 107 -> 181;
                case 108 -> 88;
                case 109 -> 23;
                case 110 -> 113;
                case 111 -> 162;
                case 112 -> 158;
                case 113 -> 176;
                case 114 -> 226;
                case 115 -> 31;
                case 116 -> 169;
                case 117 -> 186;
                case 118 -> 54;
                case 119 -> 167;
                case 120 -> 96;
                case 121 -> 184;
                case 122 -> 171;
                case 123 -> 233;
                case 124 -> 218;
                case 125 -> 36;
                case 126 -> 62;
                case 127 -> 245;
                case 128 -> 229;
                case 129 -> 60;
                case 130 -> 25;
                case 131 -> 237;
                case 132 -> 145;
                case 133 -> 53;
                case 134 -> 248;
                case 135 -> 42;
                case 136 -> 128;
                case 137 -> 196;
                case 138 -> 4;
                case 139 -> 221;
                case 140 -> 46;
                case 141 -> 47;
                case 142 -> 89;
                case 143 -> 99;
                case 144 -> 21;
                case 145 -> 201;
                case 146 -> 18;
                case 147 -> 16;
                case 148 -> 234;
                case 149 -> 179;
                case 150 -> 173;
                case 151 -> 224;
                case 152 -> 182;
                case 153 -> 35;
                case 154 -> 174;
                case 155 -> 250;
                case 156 -> 61;
                case 157 -> 7;
                case 158 -> 56;
                case 159 -> 22;
                case 160 -> 243;
                case 161 -> 123;
                case 162 -> 52;
                case 163 -> 102;
                case 164 -> 82;
                case 165 -> 159;
                case 166 -> 189;
                case 167 -> 39;
                case 168 -> 208;
                case 169 -> 244;
                case 170 -> 107;
                case 171 -> 136;
                case 172 -> 8;
                case 173 -> 2;
                case 174 -> 130;
                case 175 -> 114;
                case 176 -> 240;
                case 177 -> 215;
                case 178 -> 57;
                case 179 -> 187;
                case 180 -> 44;
                case 181 -> 137;
                case 182 -> 79;
                case 183 -> 228;
                case 184 -> 242;
                case 185 -> 238;
                case 186 -> 0;
                case 187 -> 37;
                case 188 -> 27;
                case 189 -> 255;
                case 190 -> 227;
                case 191 -> 185;
                case 192 -> 94;
                case 193 -> 151;
                case 194 -> 50;
                case 195 -> 109;
                case 196 -> 156;
                case 197 -> 131;
                case 198 -> 3;
                case 199 -> 225;
                case 200 -> 134;
                case 201 -> 149;
                case 202 -> 98;
                case 203 -> 32;
                case 204 -> 58;
                case 205 -> 166;
                case 206 -> 199;
                case 207 -> 142;
                case 208 -> 157;
                case 209 -> 135;
                case 210 -> 121;
                case 211 -> 26;
                case 212 -> 163;
                case 213 -> 90;
                case 214 -> 239;
                case 215 -> 71;
                case 216 -> 232;
                case 217 -> 192;
                case 218 -> 38;
                case 219 -> 193;
                case 220 -> 127;
                case 221 -> 194;
                case 222 -> 198;
                case 223 -> 117;
                case 224 -> 92;
                case 225 -> 153;
                case 226 -> 68;
                case 227 -> 51;
                case 228 -> 230;
                case 229 -> 6;
                case 230 -> 87;
                case 231 -> 213;
                case 232 -> 148;
                case 233 -> 93;
                case 234 -> 74;
                case 235 -> 152;
                case 236 -> 70;
                case 237 -> 29;
                case 238 -> 252;
                case 239 -> 34;
                case 240 -> 28;
                case 241 -> 161;
                case 242 -> 246;
                case 243 -> 207;
                case 244 -> 55;
                case 245 -> 178;
                case 246 -> 33;
                case 247 -> 110;
                case 248 -> 155;
                case 249 -> 85;
                case 250 -> 183;
                case 251 -> 140;
                case 252 -> 75;
                case 253 -> 195;
                case 254 -> 45;
                default -> 95;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 85738642446711L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1789629780 + -((char)-27029), 1789629780 + 31194, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 7680368568804L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.l();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 != 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 != 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(967034460 - 8585, 967034460 + 6708, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(967034460 - 8588, 967034460 - 14601, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(967034460 - 8587, -967034460 + -6732, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00ce\u0090\u000e\u00b0\u00ff\u00e6\u0089\u00fc\u0010\u00f8G9\u00eb\u00a36\u00fb\u00bf \u0000A7\u0097\u00bd2\u00be";
                    var4_3 = "\u00ce\u0090\u000e\u00b0\u00ff\u00e6\u0089\u00fc\u0010\u00f8G9\u00eb\u00a36\u00fb\u00bf \u0000A7\u0097\u00bd2\u00be".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 96;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "t\u00d2\u00d7v:5\u0086\\\u009e\u00cb\u00c1\u0085!\u00ec\u0082_\t\u0092\u00e7m\u00b7\u00a0\u00c7\u009dL\u00d8\u00dc\u0002\u009b\u001cW\u00d2\u00b1AT\u00b4\u008b\u008a\u00b1d\u00ac&\u0087R\u00ca\u009c\u00b0\u00c1\u00c0\u00d0{\u00df\u00cfh9\u00eb6!\u00e4";
                        var4_3 = "t\u00d2\u00d7v:5\u0086\\\u009e\u00cb\u00c1\u0085!\u00ec\u0082_\t\u0092\u00e7m\u00b7\u00a0\u00c7\u009dL\u00d8\u00dc\u0002\u009b\u001cW\u00d2\u00b1AT\u00b4\u008b\u008a\u00b1d\u00ac&\u0087R\u00ca\u009c\u00b0\u00c1\u00c0\u00d0{\u00df\u00cfh9\u00eb6!\u00e4".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 38;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 102;
                                break;
                            }
                            case 1: {
                                v15 = 108;
                                break;
                            }
                            case 2: {
                                v15 = 121;
                                break;
                            }
                            case 3: {
                                v15 = 98;
                                break;
                            }
                            case 4: {
                                v15 = 83;
                                break;
                            }
                            case 5: {
                                v15 = 120;
                                break;
                            }
                            default: {
                                v15 = 94;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4D36) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 0;
                    case 1 -> 38;
                    case 2 -> 243;
                    case 3 -> 157;
                    case 4 -> 20;
                    case 5 -> 64;
                    case 6 -> 159;
                    case 7 -> 15;
                    case 8 -> 105;
                    case 9 -> 116;
                    case 10 -> 123;
                    case 11 -> 49;
                    case 12 -> 246;
                    case 13 -> 92;
                    case 14 -> 94;
                    case 15 -> 231;
                    case 16 -> 58;
                    case 17 -> 47;
                    case 18 -> 201;
                    case 19 -> 84;
                    case 20 -> 4;
                    case 21 -> 144;
                    case 22 -> 254;
                    case 23 -> 220;
                    case 24 -> 216;
                    case 25 -> 86;
                    case 26 -> 228;
                    case 27 -> 248;
                    case 28 -> 224;
                    case 29 -> 230;
                    case 30 -> 107;
                    case 31 -> 131;
                    case 32 -> 44;
                    case 33 -> 202;
                    case 34 -> 129;
                    case 35 -> 149;
                    case 36 -> 56;
                    case 37 -> 48;
                    case 38 -> 158;
                    case 39 -> 182;
                    case 40 -> 211;
                    case 41 -> 120;
                    case 42 -> 5;
                    case 43 -> 32;
                    case 44 -> 118;
                    case 45 -> 198;
                    case 46 -> 78;
                    case 47 -> 53;
                    case 48 -> 102;
                    case 49 -> 29;
                    case 50 -> 43;
                    case 51 -> 255;
                    case 52 -> 115;
                    case 53 -> 163;
                    case 54 -> 233;
                    case 55 -> 111;
                    case 56 -> 36;
                    case 57 -> 189;
                    case 58 -> 151;
                    case 59 -> 203;
                    case 60 -> 173;
                    case 61 -> 34;
                    case 62 -> 214;
                    case 63 -> 65;
                    case 64 -> 82;
                    case 65 -> 184;
                    case 66 -> 170;
                    case 67 -> 83;
                    case 68 -> 89;
                    case 69 -> 200;
                    case 70 -> 242;
                    case 71 -> 145;
                    case 72 -> 241;
                    case 73 -> 79;
                    case 74 -> 95;
                    case 75 -> 35;
                    case 76 -> 100;
                    case 77 -> 61;
                    case 78 -> 22;
                    case 79 -> 168;
                    case 80 -> 240;
                    case 81 -> 140;
                    case 82 -> 126;
                    case 83 -> 99;
                    case 84 -> 69;
                    case 85 -> 23;
                    case 86 -> 244;
                    case 87 -> 121;
                    case 88 -> 63;
                    case 89 -> 76;
                    case 90 -> 74;
                    case 91 -> 222;
                    case 92 -> 183;
                    case 93 -> 60;
                    case 94 -> 21;
                    case 95 -> 252;
                    case 96 -> 199;
                    case 97 -> 171;
                    case 98 -> 52;
                    case 99 -> 134;
                    case 100 -> 51;
                    case 101 -> 128;
                    case 102 -> 147;
                    case 103 -> 142;
                    case 104 -> 12;
                    case 105 -> 8;
                    case 106 -> 204;
                    case 107 -> 223;
                    case 108 -> 205;
                    case 109 -> 17;
                    case 110 -> 249;
                    case 111 -> 81;
                    case 112 -> 73;
                    case 113 -> 28;
                    case 114 -> 187;
                    case 115 -> 167;
                    case 116 -> 185;
                    case 117 -> 124;
                    case 118 -> 181;
                    case 119 -> 177;
                    case 120 -> 16;
                    case 121 -> 195;
                    case 122 -> 68;
                    case 123 -> 225;
                    case 124 -> 96;
                    case 125 -> 133;
                    case 126 -> 113;
                    case 127 -> 179;
                    case 128 -> 135;
                    case 129 -> 80;
                    case 130 -> 174;
                    case 131 -> 141;
                    case 132 -> 227;
                    case 133 -> 178;
                    case 134 -> 169;
                    case 135 -> 238;
                    case 136 -> 196;
                    case 137 -> 138;
                    case 138 -> 165;
                    case 139 -> 11;
                    case 140 -> 71;
                    case 141 -> 206;
                    case 142 -> 132;
                    case 143 -> 24;
                    case 144 -> 221;
                    case 145 -> 14;
                    case 146 -> 218;
                    case 147 -> 66;
                    case 148 -> 1;
                    case 149 -> 148;
                    case 150 -> 150;
                    case 151 -> 176;
                    case 152 -> 114;
                    case 153 -> 39;
                    case 154 -> 154;
                    case 155 -> 67;
                    case 156 -> 50;
                    case 157 -> 143;
                    case 158 -> 90;
                    case 159 -> 155;
                    case 160 -> 164;
                    case 161 -> 41;
                    case 162 -> 215;
                    case 163 -> 72;
                    case 164 -> 209;
                    case 165 -> 186;
                    case 166 -> 188;
                    case 167 -> 59;
                    case 168 -> 42;
                    case 169 -> 31;
                    case 170 -> 253;
                    case 171 -> 160;
                    case 172 -> 57;
                    case 173 -> 232;
                    case 174 -> 77;
                    case 175 -> 247;
                    case 176 -> 130;
                    case 177 -> 235;
                    case 178 -> 156;
                    case 179 -> 9;
                    case 180 -> 251;
                    case 181 -> 26;
                    case 182 -> 85;
                    case 183 -> 10;
                    case 184 -> 217;
                    case 185 -> 13;
                    case 186 -> 46;
                    case 187 -> 175;
                    case 188 -> 103;
                    case 189 -> 18;
                    case 190 -> 25;
                    case 191 -> 3;
                    case 192 -> 30;
                    case 193 -> 125;
                    case 194 -> 70;
                    case 195 -> 110;
                    case 196 -> 55;
                    case 197 -> 112;
                    case 198 -> 192;
                    case 199 -> 191;
                    case 200 -> 161;
                    case 201 -> 45;
                    case 202 -> 37;
                    case 203 -> 162;
                    case 204 -> 7;
                    case 205 -> 212;
                    case 206 -> 109;
                    case 207 -> 88;
                    case 208 -> 146;
                    case 209 -> 54;
                    case 210 -> 139;
                    case 211 -> 19;
                    case 212 -> 208;
                    case 213 -> 153;
                    case 214 -> 87;
                    case 215 -> 237;
                    case 216 -> 229;
                    case 217 -> 97;
                    case 218 -> 27;
                    case 219 -> 98;
                    case 220 -> 190;
                    case 221 -> 2;
                    case 222 -> 152;
                    case 223 -> 194;
                    case 224 -> 236;
                    case 225 -> 172;
                    case 226 -> 33;
                    case 227 -> 193;
                    case 228 -> 250;
                    case 229 -> 91;
                    case 230 -> 234;
                    case 231 -> 137;
                    case 232 -> 127;
                    case 233 -> 197;
                    case 234 -> 75;
                    case 235 -> 101;
                    case 236 -> 106;
                    case 237 -> 210;
                    case 238 -> 180;
                    case 239 -> 40;
                    case 240 -> 117;
                    case 241 -> 213;
                    case 242 -> 136;
                    case 243 -> 226;
                    case 244 -> 122;
                    case 245 -> 207;
                    case 246 -> 245;
                    case 247 -> 108;
                    case 248 -> 6;
                    case 249 -> 119;
                    case 250 -> 166;
                    case 251 -> 239;
                    case 252 -> 93;
                    case 253 -> 104;
                    case 254 -> 219;
                    default -> 62;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 45406028338320L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "@2E8C\b/\u0019\tG8V2\u000eJ2\u0005~";
                    var5_4 = "@2E8C\b/\u0019\tG8V2\u000eJ2\u0005~".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 123;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 80;
                                    break;
                                }
                                case 1: {
                                    v11 = 44;
                                    break;
                                }
                                case 2: {
                                    v11 = 76;
                                    break;
                                }
                                case 3: {
                                    v11 = 45;
                                    break;
                                }
                                case 4: {
                                    v11 = 93;
                                    break;
                                }
                                case 5: {
                                    v11 = 31;
                                    break;
                                }
                                default: {
                                    v11 = 103;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 82273006604317L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "iC52h\u0002m\u0004o]9(\ncB2(d\u0000uIC;\tcB2(d\u0000uEI\rdD/%n\roEN(/o\u0004";
                    var5_4 = "iC52h\u0002m\u0004o]9(\ncB2(d\u0000uIC;\tcB2(d\u0000uEI\rdD/%n\roEN(/o\u0004".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 58;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "Jh\u001a\u001cA$O\u0006Jh\u001a\u001cM.";
                        var5_4 = "Jh\u001a\u001cA$O\u0006Jh\u001a\u001cM.".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 19;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 26;
                                break;
                            }
                            case 1: {
                                v15 = 23;
                                break;
                            }
                            case 2: {
                                v15 = 102;
                                break;
                            }
                            case 3: {
                                v15 = 124;
                                break;
                            }
                            case 4: {
                                v15 = 59;
                                break;
                            }
                            case 5: {
                                v15 = 89;
                                break;
                            }
                            default: {
                                v15 = 59;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 6438441769463L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-285732600 + -((char)-8470), 285732600 + (char)-5320, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 31143039862935L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "S\u0000o\u00b2\u00c1\u0003\u001c\u00862\u0005\u00b1p\u0015xm\r@\u0089\u001d\r\u0099A\u00a2\u00f6\u007fY\u009d\u00d0\u00d4\u0010\u001b\u0086\u00b1\u00073\u0095\u00dcQy)\u00be\u0093V\u001c\u00907\u0005\u0016\u00f3\u00e1\b\u00f33\u00d0\u00cf(\u00f8\u00d5.02\u0099\u00b8)\u0088b.:n<\u0005K{ dQ\"\u009f\u0085\u00f1F\u00f6\u00d3\u009aa]\u000fj4\u0096(\u0002\u00d6\u0084iC\u00c4\u0000u\u00c1\u00a7\u00ca6\u008b";
                    var4_3 = "S\u0000o\u00b2\u00c1\u0003\u001c\u00862\u0005\u00b1p\u0015xm\r@\u0089\u001d\r\u0099A\u00a2\u00f6\u007fY\u009d\u00d0\u00d4\u0010\u001b\u0086\u00b1\u00073\u0095\u00dcQy)\u00be\u0093V\u001c\u00907\u0005\u0016\u00f3\u00e1\b\u00f33\u00d0\u00cf(\u00f8\u00d5.02\u0099\u00b8)\u0088b.:n<\u0005K{ dQ\"\u009f\u0085\u00f1F\u00f6\u00d3\u009aa]\u000fj4\u0096(\u0002\u00d6\u0084iC\u00c4\u0000u\u00c1\u00a7\u00ca6\u008b".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 20;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00c7\u0090&\u00c9\u00cd@\u000f\u00e7\u000f\u00f3|\u00c4\u0002\u00fa\u0016\u00e7Lur\u0087_\u00d3Z\u00a2\u00ca3\u00c5W\u00bbi\u009b\u00e8\u00b2oC\u00d2IwJ\u009dI)\u000f\u000e\u00dd\u00ff\u00e5X\u00c4\u0019Y\u009f\u00ee\u0016\u00a1$\u008dz\u00f3_\u00e6\u009a\u00e3UA\u00a6\u00d2\u00e2\u00e4B\u00a7`7A\u00d0\u0096\u0004\u00f5\u00ba\u00b0[1\u00ee\u001e\u00a0*\u0003\u00d6qG\u0004\u00da6";
                        var4_3 = "\u00c7\u0090&\u00c9\u00cd@\u000f\u00e7\u000f\u00f3|\u00c4\u0002\u00fa\u0016\u00e7Lur\u0087_\u00d3Z\u00a2\u00ca3\u00c5W\u00bbi\u009b\u00e8\u00b2oC\u00d2IwJ\u009dI)\u000f\u000e\u00dd\u00ff\u00e5X\u00c4\u0019Y\u009f\u00ee\u0016\u00a1$\u008dz\u00f3_\u00e6\u009a\u00e3UA\u00a6\u00d2\u00e2\u00e4B\u00a7`7A\u00d0\u0096\u0004\u00f5\u00ba\u00b0[1\u00ee\u001e\u00a0*\u0003\u00d6qG\u0004\u00da6".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 61;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 7;
                                break;
                            }
                            case 1: {
                                v15 = 46;
                                break;
                            }
                            case 2: {
                                v15 = 91;
                                break;
                            }
                            case 3: {
                                v15 = 4;
                                break;
                            }
                            case 4: {
                                v15 = 108;
                                break;
                            }
                            case 5: {
                                v15 = 112;
                                break;
                            }
                            default: {
                                v15 = 118;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFEBE9) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 124;
                    case 1 -> 150;
                    case 2 -> 27;
                    case 3 -> 241;
                    case 4 -> 222;
                    case 5 -> 133;
                    case 6 -> 64;
                    case 7 -> 147;
                    case 8 -> 15;
                    case 9 -> 143;
                    case 10 -> 26;
                    case 11 -> 47;
                    case 12 -> 215;
                    case 13 -> 73;
                    case 14 -> 246;
                    case 15 -> 4;
                    case 16 -> 119;
                    case 17 -> 2;
                    case 18 -> 204;
                    case 19 -> 108;
                    case 20 -> 170;
                    case 21 -> 237;
                    case 22 -> 14;
                    case 23 -> 189;
                    case 24 -> 164;
                    case 25 -> 239;
                    case 26 -> 146;
                    case 27 -> 253;
                    case 28 -> 144;
                    case 29 -> 123;
                    case 30 -> 131;
                    case 31 -> 5;
                    case 32 -> 223;
                    case 33 -> 217;
                    case 34 -> 76;
                    case 35 -> 227;
                    case 36 -> 200;
                    case 37 -> 94;
                    case 38 -> 53;
                    case 39 -> 158;
                    case 40 -> 86;
                    case 41 -> 233;
                    case 42 -> 218;
                    case 43 -> 85;
                    case 44 -> 110;
                    case 45 -> 216;
                    case 46 -> 59;
                    case 47 -> 140;
                    case 48 -> 93;
                    case 49 -> 255;
                    case 50 -> 127;
                    case 51 -> 40;
                    case 52 -> 175;
                    case 53 -> 68;
                    case 54 -> 230;
                    case 55 -> 25;
                    case 56 -> 240;
                    case 57 -> 130;
                    case 58 -> 186;
                    case 59 -> 1;
                    case 60 -> 38;
                    case 61 -> 20;
                    case 62 -> 244;
                    case 63 -> 54;
                    case 64 -> 166;
                    case 65 -> 63;
                    case 66 -> 248;
                    case 67 -> 65;
                    case 68 -> 43;
                    case 69 -> 78;
                    case 70 -> 141;
                    case 71 -> 180;
                    case 72 -> 101;
                    case 73 -> 142;
                    case 74 -> 208;
                    case 75 -> 17;
                    case 76 -> 199;
                    case 77 -> 187;
                    case 78 -> 10;
                    case 79 -> 6;
                    case 80 -> 30;
                    case 81 -> 56;
                    case 82 -> 245;
                    case 83 -> 116;
                    case 84 -> 52;
                    case 85 -> 28;
                    case 86 -> 225;
                    case 87 -> 35;
                    case 88 -> 212;
                    case 89 -> 145;
                    case 90 -> 155;
                    case 91 -> 61;
                    case 92 -> 67;
                    case 93 -> 188;
                    case 94 -> 48;
                    case 95 -> 132;
                    case 96 -> 238;
                    case 97 -> 209;
                    case 98 -> 8;
                    case 99 -> 201;
                    case 100 -> 205;
                    case 101 -> 91;
                    case 102 -> 79;
                    case 103 -> 121;
                    case 104 -> 168;
                    case 105 -> 139;
                    case 106 -> 252;
                    case 107 -> 75;
                    case 108 -> 77;
                    case 109 -> 195;
                    case 110 -> 203;
                    case 111 -> 89;
                    case 112 -> 169;
                    case 113 -> 197;
                    case 114 -> 9;
                    case 115 -> 3;
                    case 116 -> 219;
                    case 117 -> 34;
                    case 118 -> 229;
                    case 119 -> 182;
                    case 120 -> 71;
                    case 121 -> 184;
                    case 122 -> 185;
                    case 123 -> 0;
                    case 124 -> 190;
                    case 125 -> 16;
                    case 126 -> 11;
                    case 127 -> 74;
                    case 128 -> 106;
                    case 129 -> 60;
                    case 130 -> 118;
                    case 131 -> 202;
                    case 132 -> 24;
                    case 133 -> 62;
                    case 134 -> 211;
                    case 135 -> 42;
                    case 136 -> 176;
                    case 137 -> 115;
                    case 138 -> 113;
                    case 139 -> 242;
                    case 140 -> 152;
                    case 141 -> 138;
                    case 142 -> 120;
                    case 143 -> 36;
                    case 144 -> 137;
                    case 145 -> 156;
                    case 146 -> 221;
                    case 147 -> 165;
                    case 148 -> 72;
                    case 149 -> 231;
                    case 150 -> 207;
                    case 151 -> 135;
                    case 152 -> 247;
                    case 153 -> 111;
                    case 154 -> 167;
                    case 155 -> 46;
                    case 156 -> 31;
                    case 157 -> 243;
                    case 158 -> 206;
                    case 159 -> 210;
                    case 160 -> 128;
                    case 161 -> 49;
                    case 162 -> 173;
                    case 163 -> 161;
                    case 164 -> 226;
                    case 165 -> 39;
                    case 166 -> 109;
                    case 167 -> 18;
                    case 168 -> 57;
                    case 169 -> 90;
                    case 170 -> 251;
                    case 171 -> 122;
                    case 172 -> 192;
                    case 173 -> 153;
                    case 174 -> 84;
                    case 175 -> 51;
                    case 176 -> 102;
                    case 177 -> 162;
                    case 178 -> 80;
                    case 179 -> 254;
                    case 180 -> 235;
                    case 181 -> 249;
                    case 182 -> 250;
                    case 183 -> 136;
                    case 184 -> 32;
                    case 185 -> 87;
                    case 186 -> 98;
                    case 187 -> 50;
                    case 188 -> 159;
                    case 189 -> 97;
                    case 190 -> 214;
                    case 191 -> 33;
                    case 192 -> 45;
                    case 193 -> 112;
                    case 194 -> 23;
                    case 195 -> 13;
                    case 196 -> 163;
                    case 197 -> 104;
                    case 198 -> 37;
                    case 199 -> 234;
                    case 200 -> 129;
                    case 201 -> 19;
                    case 202 -> 95;
                    case 203 -> 151;
                    case 204 -> 213;
                    case 205 -> 126;
                    case 206 -> 12;
                    case 207 -> 83;
                    case 208 -> 193;
                    case 209 -> 22;
                    case 210 -> 117;
                    case 211 -> 194;
                    case 212 -> 160;
                    case 213 -> 183;
                    case 214 -> 134;
                    case 215 -> 228;
                    case 216 -> 220;
                    case 217 -> 99;
                    case 218 -> 41;
                    case 219 -> 174;
                    case 220 -> 178;
                    case 221 -> 198;
                    case 222 -> 148;
                    case 223 -> 92;
                    case 224 -> 44;
                    case 225 -> 100;
                    case 226 -> 103;
                    case 227 -> 191;
                    case 228 -> 96;
                    case 229 -> 58;
                    case 230 -> 69;
                    case 231 -> 82;
                    case 232 -> 171;
                    case 233 -> 7;
                    case 234 -> 107;
                    case 235 -> 177;
                    case 236 -> 125;
                    case 237 -> 88;
                    case 238 -> 196;
                    case 239 -> 224;
                    case 240 -> 157;
                    case 241 -> 21;
                    case 242 -> 179;
                    case 243 -> 149;
                    case 244 -> 181;
                    case 245 -> 232;
                    case 246 -> 172;
                    case 247 -> 236;
                    case 248 -> 114;
                    case 249 -> 55;
                    case 250 -> 105;
                    case 251 -> 29;
                    case 252 -> 81;
                    case 253 -> 70;
                    case 254 -> 66;
                    default -> 154;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 136739520922281L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(647092590 + 31028, 647092590 + 9964, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 36025606998112L;
                    int n3 = SshAgentIpcService.t();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-578674050 + -2580, 578674050 - 9404, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 == 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 33792628929252L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00b5aH\u0003\u00d9\u0003\u0081\u00eb\u0098";
                var4_3 = "\u00b5aH\u0003\u00d9\u0003\u0081\u00eb\u0098".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 26;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 60;
                                break;
                            }
                            case 1: {
                                v11 = 93;
                                break;
                            }
                            case 2: {
                                v11 = 8;
                                break;
                            }
                            case 3: {
                                v11 = 56;
                                break;
                            }
                            case 4: {
                                v11 = 53;
                                break;
                            }
                            case 5: {
                                v11 = 99;
                                break;
                            }
                            default: {
                                v11 = 65;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x100B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 5;
                    case 1 -> 233;
                    case 2 -> 220;
                    case 3 -> 18;
                    case 4 -> 151;
                    case 5 -> 203;
                    case 6 -> 122;
                    case 7 -> 193;
                    case 8 -> 202;
                    case 9 -> 198;
                    case 10 -> 115;
                    case 11 -> 131;
                    case 12 -> 70;
                    case 13 -> 109;
                    case 14 -> 6;
                    case 15 -> 51;
                    case 16 -> 222;
                    case 17 -> 28;
                    case 18 -> 170;
                    case 19 -> 252;
                    case 20 -> 157;
                    case 21 -> 166;
                    case 22 -> 93;
                    case 23 -> 152;
                    case 24 -> 24;
                    case 25 -> 40;
                    case 26 -> 4;
                    case 27 -> 190;
                    case 28 -> 156;
                    case 29 -> 121;
                    case 30 -> 12;
                    case 31 -> 230;
                    case 32 -> 188;
                    case 33 -> 57;
                    case 34 -> 227;
                    case 35 -> 66;
                    case 36 -> 85;
                    case 37 -> 69;
                    case 38 -> 244;
                    case 39 -> 103;
                    case 40 -> 74;
                    case 41 -> 9;
                    case 42 -> 181;
                    case 43 -> 139;
                    case 44 -> 41;
                    case 45 -> 105;
                    case 46 -> 83;
                    case 47 -> 59;
                    case 48 -> 221;
                    case 49 -> 53;
                    case 50 -> 182;
                    case 51 -> 94;
                    case 52 -> 178;
                    case 53 -> 195;
                    case 54 -> 239;
                    case 55 -> 215;
                    case 56 -> 186;
                    case 57 -> 255;
                    case 58 -> 219;
                    case 59 -> 95;
                    case 60 -> 134;
                    case 61 -> 31;
                    case 62 -> 7;
                    case 63 -> 165;
                    case 64 -> 116;
                    case 65 -> 236;
                    case 66 -> 129;
                    case 67 -> 174;
                    case 68 -> 140;
                    case 69 -> 130;
                    case 70 -> 42;
                    case 71 -> 206;
                    case 72 -> 185;
                    case 73 -> 63;
                    case 74 -> 224;
                    case 75 -> 163;
                    case 76 -> 110;
                    case 77 -> 175;
                    case 78 -> 155;
                    case 79 -> 78;
                    case 80 -> 232;
                    case 81 -> 214;
                    case 82 -> 153;
                    case 83 -> 225;
                    case 84 -> 114;
                    case 85 -> 27;
                    case 86 -> 180;
                    case 87 -> 20;
                    case 88 -> 81;
                    case 89 -> 44;
                    case 90 -> 29;
                    case 91 -> 37;
                    case 92 -> 23;
                    case 93 -> 241;
                    case 94 -> 213;
                    case 95 -> 3;
                    case 96 -> 92;
                    case 97 -> 19;
                    case 98 -> 196;
                    case 99 -> 104;
                    case 100 -> 146;
                    case 101 -> 48;
                    case 102 -> 254;
                    case 103 -> 133;
                    case 104 -> 250;
                    case 105 -> 154;
                    case 106 -> 189;
                    case 107 -> 176;
                    case 108 -> 238;
                    case 109 -> 237;
                    case 110 -> 200;
                    case 111 -> 173;
                    case 112 -> 108;
                    case 113 -> 46;
                    case 114 -> 228;
                    case 115 -> 231;
                    case 116 -> 35;
                    case 117 -> 128;
                    case 118 -> 145;
                    case 119 -> 171;
                    case 120 -> 73;
                    case 121 -> 192;
                    case 122 -> 100;
                    case 123 -> 34;
                    case 124 -> 82;
                    case 125 -> 113;
                    case 126 -> 101;
                    case 127 -> 13;
                    case 128 -> 177;
                    case 129 -> 127;
                    case 130 -> 243;
                    case 131 -> 205;
                    case 132 -> 68;
                    case 133 -> 8;
                    case 134 -> 144;
                    case 135 -> 208;
                    case 136 -> 179;
                    case 137 -> 87;
                    case 138 -> 89;
                    case 139 -> 247;
                    case 140 -> 11;
                    case 141 -> 187;
                    case 142 -> 207;
                    case 143 -> 56;
                    case 144 -> 253;
                    case 145 -> 39;
                    case 146 -> 2;
                    case 147 -> 1;
                    case 148 -> 0;
                    case 149 -> 251;
                    case 150 -> 150;
                    case 151 -> 102;
                    case 152 -> 25;
                    case 153 -> 194;
                    case 154 -> 64;
                    case 155 -> 33;
                    case 156 -> 169;
                    case 157 -> 15;
                    case 158 -> 226;
                    case 159 -> 136;
                    case 160 -> 216;
                    case 161 -> 43;
                    case 162 -> 242;
                    case 163 -> 36;
                    case 164 -> 107;
                    case 165 -> 223;
                    case 166 -> 124;
                    case 167 -> 210;
                    case 168 -> 117;
                    case 169 -> 26;
                    case 170 -> 135;
                    case 171 -> 111;
                    case 172 -> 55;
                    case 173 -> 49;
                    case 174 -> 54;
                    case 175 -> 112;
                    case 176 -> 191;
                    case 177 -> 234;
                    case 178 -> 90;
                    case 179 -> 162;
                    case 180 -> 229;
                    case 181 -> 60;
                    case 182 -> 61;
                    case 183 -> 248;
                    case 184 -> 52;
                    case 185 -> 10;
                    case 186 -> 147;
                    case 187 -> 86;
                    case 188 -> 218;
                    case 189 -> 14;
                    case 190 -> 148;
                    case 191 -> 58;
                    case 192 -> 126;
                    case 193 -> 161;
                    case 194 -> 17;
                    case 195 -> 119;
                    case 196 -> 209;
                    case 197 -> 249;
                    case 198 -> 88;
                    case 199 -> 168;
                    case 200 -> 199;
                    case 201 -> 118;
                    case 202 -> 197;
                    case 203 -> 158;
                    case 204 -> 71;
                    case 205 -> 62;
                    case 206 -> 47;
                    case 207 -> 99;
                    case 208 -> 45;
                    case 209 -> 172;
                    case 210 -> 76;
                    case 211 -> 91;
                    case 212 -> 72;
                    case 213 -> 125;
                    case 214 -> 96;
                    case 215 -> 204;
                    case 216 -> 141;
                    case 217 -> 137;
                    case 218 -> 79;
                    case 219 -> 30;
                    case 220 -> 120;
                    case 221 -> 184;
                    case 222 -> 212;
                    case 223 -> 38;
                    case 224 -> 80;
                    case 225 -> 65;
                    case 226 -> 50;
                    case 227 -> 160;
                    case 228 -> 21;
                    case 229 -> 235;
                    case 230 -> 67;
                    case 231 -> 164;
                    case 232 -> 106;
                    case 233 -> 183;
                    case 234 -> 143;
                    case 235 -> 98;
                    case 236 -> 201;
                    case 237 -> 77;
                    case 238 -> 246;
                    case 239 -> 142;
                    case 240 -> 167;
                    case 241 -> 240;
                    case 242 -> 75;
                    case 243 -> 245;
                    case 244 -> 159;
                    case 245 -> 123;
                    case 246 -> 32;
                    case 247 -> 132;
                    case 248 -> 211;
                    case 249 -> 97;
                    case 250 -> 138;
                    case 251 -> 217;
                    case 252 -> 149;
                    case 253 -> 16;
                    case 254 -> 84;
                    default -> 22;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

