/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.selector;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.auth.AccountManager;
import git4idea.remote.hosting.HostedGitRepositoriesManager;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorViewModelBase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BK\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012(\u0010\n\u001a$\b\u0001\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u001aJ+\u0010\u001d\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u001aR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/selector/GHRepositoryAndAccountSelectorViewModel;", "Lgit4idea/remote/hosting/ui/RepositoryAndAccountSelectorViewModelBase;", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "repositoriesManager", "Lorg/jetbrains/plugins/github/util/GHHostedRepositoriesManager;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "onSelected", "Lkotlin/Function3;", "Lkotlin/coroutines/Continuation;", "", "", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/github/util/GHHostedRepositoriesManager;Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;Lkotlin/jvm/functions/Function3;)V", "githubLoginAvailableState", "Lkotlinx/coroutines/flow/StateFlow;", "", "getGithubLoginAvailableState", "()Lkotlinx/coroutines/flow/StateFlow;", "isGithubLoginAvailable", "repo", "account", "credsMissing", "(Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Ljava/lang/Boolean;)Z", "gheLoginAvailableState", "getGheLoginAvailableState", "isGheLoginVisible", "intellij.vcs.github"})
@ApiStatus.Experimental
public final class GHRepositoryAndAccountSelectorViewModel
extends RepositoryAndAccountSelectorViewModelBase<GHGitRepositoryMapping, GithubAccount> {
    @NotNull
    private final StateFlow<Boolean> githubLoginAvailableState;
    @NotNull
    private final StateFlow<Boolean> gheLoginAvailableState;

    public GHRepositoryAndAccountSelectorViewModel(@NotNull CoroutineScope scope, @NotNull GHHostedRepositoriesManager repositoriesManager, @NotNull GHAccountManager accountManager, @NotNull Function3<? super GHGitRepositoryMapping, ? super GithubAccount, ? super Continuation<? super Unit>, ? extends Object> onSelected) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)repositoriesManager, (String)"repositoriesManager");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        Intrinsics.checkNotNullParameter(onSelected, (String)"onSelected");
        super(scope, (HostedGitRepositoriesManager)repositoriesManager, (AccountManager)accountManager, onSelected);
        this.githubLoginAvailableState = CoroutineUtilKt.combineState((CoroutineScope)scope, (StateFlow)((StateFlow)this.getRepoSelectionState()), (StateFlow)((StateFlow)this.getAccountSelectionState()), (StateFlow)this.getMissingCredentialsState(), (Function3)((Function3)new Function3<GHGitRepositoryMapping, GithubAccount, Boolean, Boolean>((Object)this){

            public final Boolean invoke(GHGitRepositoryMapping p0, GithubAccount p1, Boolean p2) {
                return GHRepositoryAndAccountSelectorViewModel.access$isGithubLoginAvailable((GHRepositoryAndAccountSelectorViewModel)((Object)this.receiver), p0, p1, p2);
            }
        }));
        this.gheLoginAvailableState = CoroutineUtilKt.combineState((CoroutineScope)scope, (StateFlow)((StateFlow)this.getRepoSelectionState()), (StateFlow)((StateFlow)this.getAccountSelectionState()), (StateFlow)this.getMissingCredentialsState(), (Function3)((Function3)new Function3<GHGitRepositoryMapping, GithubAccount, Boolean, Boolean>((Object)this){

            public final Boolean invoke(GHGitRepositoryMapping p0, GithubAccount p1, Boolean p2) {
                return GHRepositoryAndAccountSelectorViewModel.access$isGheLoginVisible((GHRepositoryAndAccountSelectorViewModel)((Object)this.receiver), p0, p1, p2);
            }
        }));
    }

    @NotNull
    public final StateFlow<Boolean> getGithubLoginAvailableState() {
        return this.githubLoginAvailableState;
    }

    private final boolean isGithubLoginAvailable(GHGitRepositoryMapping repo, GithubAccount account, Boolean credsMissing) {
        if (repo == null) {
            return false;
        }
        return repo.getRepository().getServerPath().isGithubDotCom() && (account == null || Intrinsics.areEqual((Object)credsMissing, (Object)true));
    }

    @NotNull
    public final StateFlow<Boolean> getGheLoginAvailableState() {
        return this.gheLoginAvailableState;
    }

    private final boolean isGheLoginVisible(GHGitRepositoryMapping repo, GithubAccount account, Boolean credsMissing) {
        if (repo == null) {
            return false;
        }
        return !repo.getRepository().getServerPath().isGithubDotCom() && (account == null || Intrinsics.areEqual((Object)credsMissing, (Object)true));
    }

    public static final /* synthetic */ boolean access$isGithubLoginAvailable(GHRepositoryAndAccountSelectorViewModel $this, GHGitRepositoryMapping repo, GithubAccount account, Boolean credsMissing) {
        return $this.isGithubLoginAvailable(repo, account, credsMissing);
    }

    public static final /* synthetic */ boolean access$isGheLoginVisible(GHRepositoryAndAccountSelectorViewModel $this, GHGitRepositoryMapping repo, GithubAccount account, Boolean credsMissing) {
        return $this.isGheLoginVisible(repo, account, credsMissing);
    }
}

