/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongCharAssociativeContainer;
import com.carrotsearch.hppc.LongCharMap;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.LongCharCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.LongCharPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.LongCharProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongCharHashMap
implements LongCharMap,
Preallocable,
Cloneable,
Accountable {
    public long[] keys;
    public char[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public LongCharHashMap() {
        this(4);
    }

    public LongCharHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongCharHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public LongCharHashMap(LongCharAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public char put(long key2, char value) {
        long existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key2 == 0L) {
            this.hasEmptyKey = true;
            char previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key2 == existing) {
                char previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key2, value);
        } else {
            keys[slot] = key2;
            this.values[slot] = value;
        }
        ++this.assigned;
        return '\u0000';
    }

    @Override
    public int putAll(LongCharAssociativeContainer container) {
        int count = this.size();
        for (LongCharCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends LongCharCursor> iterable) {
        int count = this.size();
        for (LongCharCursor longCharCursor : iterable) {
            this.put(longCharCursor.key, longCharCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public char putOrAdd(long key2, char putValue, char incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key2);
        if (this.indexExists(keyIndex)) {
            putValue = (char)(this.values[keyIndex] + incrementValue);
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key2, putValue);
        }
        return putValue;
    }

    @Override
    public char addTo(long key2, char incrementValue) {
        return this.putOrAdd(key2, incrementValue, incrementValue);
    }

    @Override
    public char remove(long key2) {
        long existing;
        int mask = this.mask;
        if (key2 == 0L) {
            this.hasEmptyKey = false;
            char previousValue = this.values[mask + 1];
            this.values[mask + 1] = '\u0000';
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key2 == existing) {
                char previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return '\u0000';
    }

    @Override
    public int removeAll(LongContainer other) {
        int before2 = this.size();
        if (other.size() >= this.size() && other instanceof LongLookupContainer) {
            if (this.hasEmptyKey && other.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = '\u0000';
            }
            long[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                long existing = keys[slot];
                if (existing != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (LongCursor c : other) {
                this.remove(c.value);
            }
        }
        return before2 - this.size();
    }

    @Override
    public int removeAll(LongCharPredicate predicate) {
        int before2 = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0L, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = '\u0000';
        }
        long[] keys = this.keys;
        char[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            long existing = keys[slot];
            if (existing != 0L && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before2 - this.size();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        int before2 = this.size();
        if (this.hasEmptyKey && predicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = '\u0000';
        }
        long[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            long existing = keys[slot];
            if (existing != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before2 - this.size();
    }

    @Override
    public char get(long key2) {
        long existing;
        if (key2 == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (char)'\u0000';
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key2 == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return '\u0000';
    }

    @Override
    public char getOrDefault(long key2, char defaultValue) {
        long existing;
        if (key2 == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key2 == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(long key2) {
        long existing;
        if (key2 == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key2 == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(long key2) {
        long existing;
        int mask = this.mask;
        if (key2 == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key2 == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public char indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public char indexReplace(int index, char newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        char previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, long key2, char value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key2 == 0L) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key2, value);
            } else {
                this.keys[index] = key2;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public char indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        char previousValue = this.values[index];
        if (index > this.mask) {
            this.hasEmptyKey = false;
            this.values[index] = '\u0000';
        } else {
            this.shiftConflictingKeys(index);
        }
        return previousValue;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (LongCharCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((LongCharHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongCharHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (LongCharCursor c : other) {
            long key2 = c.key;
            if (this.containsKey(key2) && c.value == this.get(key2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            char[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size());
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<LongCharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends LongCharProcedure> T forEach(T procedure) {
        long[] keys = this.keys;
        char[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0L, values[this.mask + 1]);
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (keys[slot] != 0L) {
                procedure.apply(keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends LongCharPredicate> T forEach(T predicate) {
        long[] keys = this.keys;
        char[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply(0L, values[this.mask + 1])) {
            return predicate;
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (keys[slot] == 0L || predicate.apply(keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public CharCollection values() {
        return new ValuesContainer();
    }

    public LongCharHashMap clone() {
        try {
            LongCharHashMap cloned = (LongCharHashMap)super.clone();
            cloned.keys = (long[])this.keys.clone();
            cloned.values = (char[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.nextIterationSeed();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongCharCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static LongCharHashMap from(long[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongCharHashMap map = new LongCharHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(long key2) {
        assert (key2 != 0L);
        return BitMixer.mixPhi(key2);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(long[] fromKeys, char[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        long[] keys = this.keys;
        char[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            long existing = fromKeys[from];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        long[] prevKeys = this.keys;
        char[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new char[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, long pendingKey, char pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0L && pendingKey != 0L);
        long[] prevKeys = this.keys;
        char[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        long existing;
        long[] keys = this.keys;
        char[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        values[gapSlot] = '\u0000';
        --this.assigned;
    }

    private final class EntryIterator
    extends AbstractIterator<LongCharCursor> {
        private final LongCharCursor cursor = new LongCharCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = LongCharHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongCharHashMap.this.mask;
        }

        @Override
        protected LongCharCursor fetch() {
            int mask = LongCharHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                long existing = LongCharHashMap.this.keys[this.slot];
                if (existing == 0L) continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = LongCharHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && LongCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = 0L;
                this.cursor.value = LongCharHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (LongCharCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongCharHashMap owner;

        public KeysContainer() {
            this.owner = LongCharHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(long e) {
            if (this.owner.containsKey(e)) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final LongCharHashMap owner;

        private ValuesContainer() {
            this.owner = LongCharHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(char value) {
            for (LongCharCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            for (LongCharCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            for (LongCharCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(char e) {
            return this.owner.removeAll((long key2, char value) -> e == value);
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll((long key2, char value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = LongCharHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongCharHashMap.this.mask;
        }

        @Override
        protected CharCursor fetch() {
            int mask = LongCharHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (LongCharHashMap.this.keys[this.slot] == 0L) continue;
                this.cursor.index = this.slot;
                this.cursor.value = LongCharHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && LongCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = LongCharHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = LongCharHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongCharHashMap.this.mask;
        }

        @Override
        protected LongCursor fetch() {
            int mask = LongCharHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                long existing = LongCharHashMap.this.keys[this.slot];
                if (existing == 0L) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && LongCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

